/*
 * Decompiled with CFR 0.152.
 */
package com.nortal.test.report.allure.hook;

import com.nortal.test.core.exception.TestAutomationException;
import com.nortal.test.core.report.ReportPublisher;
import com.nortal.test.core.services.hooks.AfterSuiteHook;
import com.nortal.test.report.allure.configuration.AllureReportProperties;
import com.nortal.test.report.allure.services.AllureReportZipService;
import io.qameta.allure.Commands;
import io.qameta.allure.option.ConfigOptions;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.function.IOConsumer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0015H\u0016J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0016H\u0012J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0016H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0092D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/nortal/test/report/allure/hook/AllureReportGenerationHook;", "Lcom/nortal/test/core/services/hooks/AfterSuiteHook;", "allureReportProperties", "Lcom/nortal/test/report/allure/configuration/AllureReportProperties;", "reportPublisher", "Lcom/nortal/test/core/report/ReportPublisher;", "allureReportZipService", "Lcom/nortal/test/report/allure/services/AllureReportZipService;", "(Lcom/nortal/test/report/allure/configuration/AllureReportProperties;Lcom/nortal/test/core/report/ReportPublisher;Lcom/nortal/test/report/allure/services/AllureReportZipService;)V", "entryFileName", "", "log", "Lorg/slf4j/Logger;", "afterSuitOrder", "", "afterSuite", "", "processResource", "uri", "Ljava/net/URI;", "action", "Lorg/apache/commons/io/function/IOConsumer;", "Ljava/nio/file/Path;", "tryServeReport", "commands", "Lio/qameta/allure/Commands;", "outputDir", "tryZipReport", "reportDir", "test-automation-allure"})
public class AllureReportGenerationHook
implements AfterSuiteHook {
    @NotNull
    private final AllureReportProperties allureReportProperties;
    @NotNull
    private final ReportPublisher reportPublisher;
    @NotNull
    private final AllureReportZipService allureReportZipService;
    @NotNull
    private final Logger log;
    @NotNull
    private final String entryFileName;

    public AllureReportGenerationHook(@NotNull AllureReportProperties allureReportProperties, @NotNull ReportPublisher reportPublisher, @NotNull AllureReportZipService allureReportZipService) {
        Intrinsics.checkNotNullParameter((Object)allureReportProperties, (String)"allureReportProperties");
        Intrinsics.checkNotNullParameter((Object)reportPublisher, (String)"reportPublisher");
        Intrinsics.checkNotNullParameter((Object)allureReportZipService, (String)"allureReportZipService");
        this.allureReportProperties = allureReportProperties;
        this.reportPublisher = reportPublisher;
        this.allureReportZipService = allureReportZipService;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(javaClass)");
        this.log = logger;
        this.entryFileName = "index.html";
    }

    public int afterSuitOrder() {
        return 50000;
    }

    public void afterSuite() {
        this.log.info("Generating Allure Report..");
        Path reportDir = FileSystems.getDefault().getPath(this.allureReportProperties.getReportDir(), new String[0]);
        Path executionResultDir = FileSystems.getDefault().getPath(this.allureReportProperties.getResultDir(), new String[0]);
        URL uRL = this.getClass().getResource("/allure_home");
        if (uRL == null) {
            throw new TestAutomationException("Missing allure_home under classpath!", null, 2, null);
        }
        URL resource = uRL;
        URI uRI = resource.toURI();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"resource.toURI()");
        this.processResource(uRI, (IOConsumer<Path>)((IOConsumer)arg_0 -> AllureReportGenerationHook.afterSuite$lambda$0(reportDir, executionResultDir, this, arg_0)));
    }

    private void tryServeReport(Commands commands, Path outputDir) {
        if (this.allureReportProperties.getServeReport().getEnabled()) {
            commands.serve(CollectionsKt.listOf((Object)outputDir), this.allureReportProperties.getServeReport().getHostname(), this.allureReportProperties.getServeReport().getPort(), new ConfigOptions());
        }
    }

    private void tryZipReport(Path reportDir) {
        if (this.allureReportProperties.getZipReport().getEnabled()) {
            String zipOutputDir = this.allureReportProperties.getZipReport().getZipDir();
            this.allureReportZipService.zipReport(((Object)reportDir).toString(), zipOutputDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResource(@NotNull URI uri, @NotNull IOConsumer<Path> action) throws IOException {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        try {
            Path path = Paths.get(uri);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(uri)");
            Path p = path;
            action.accept((Object)p);
        }
        catch (FileSystemNotFoundException ex) {
            Closeable closeable = FileSystems.newFileSystem(uri, MapsKt.emptyMap());
            Throwable throwable = null;
            try {
                FileSystem fs = (FileSystem)closeable;
                boolean bl = false;
                Path p = fs.provider().getPath(uri);
                action.accept((Object)p);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    private static final void afterSuite$lambda$0(Path $reportDir, Path $executionResultDir, AllureReportGenerationHook this$0, Path allureHome) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Commands commands = new Commands(allureHome);
        commands.generate($reportDir, CollectionsKt.listOf((Object)$executionResultDir), true, new ConfigOptions());
        ReportPublisher reportPublisher = this$0.reportPublisher;
        Intrinsics.checkNotNullExpressionValue((Object)$reportDir, (String)"reportDir");
        reportPublisher.publish($reportDir, this$0.entryFileName);
        Intrinsics.checkNotNullExpressionValue((Object)$executionResultDir, (String)"executionResultDir");
        this$0.tryServeReport(commands, $executionResultDir);
        this$0.tryZipReport($reportDir);
    }
}

