/*
 * Decompiled with CFR 0.152.
 */
package com.nortal.test.testcontainers;

import com.nortal.test.testcontainers.AuxiliaryContainer;
import com.nortal.test.testcontainers.configuration.ContainerProperties;
import com.nortal.test.testcontainers.configuration.ContextContainerProperties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u000b\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\fJ\r\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\fJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016R\u0012\u0010\u0005\u001a\u00020\u00068\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/nortal/test/testcontainers/AbstractAuxiliaryContainer;", "T", "Lorg/testcontainers/containers/GenericContainer;", "Lcom/nortal/test/testcontainers/AuxiliaryContainer;", "()V", "containerProperties", "Lcom/nortal/test/testcontainers/configuration/ContainerProperties;", "log", "Lorg/slf4j/Logger;", "testContainer", "Lorg/testcontainers/containers/GenericContainer;", "configure", "()Lorg/testcontainers/containers/GenericContainer;", "getTestContainer", "isReusable", "", "isRunning", "start", "", "network", "Lorg/testcontainers/containers/Network;", "verifyRunning", "test-automation-containers"})
public abstract class AbstractAuxiliaryContainer<T extends GenericContainer<T>>
implements AuxiliaryContainer<T> {
    @Autowired
    private ContainerProperties containerProperties;
    @NotNull
    private final Logger log;
    @Nullable
    private T testContainer;

    public AbstractAuxiliaryContainer() {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(javaClass)");
        this.log = logger;
    }

    @Override
    public void start(@Nullable Network network) {
        T newTestContainer = this.configure();
        if (network != null) {
            newTestContainer.withNetwork(network);
        }
        newTestContainer.withReuse(this.isReusable());
        this.log.info("Starting container [{}] reuse-between-runs: {}", (Object)this.getClass().getName(), (Object)newTestContainer.isShouldBeReused());
        newTestContainer.start();
        this.testContainer = newTestContainer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isReusable() {
        ContainerProperties containerProperties = this.containerProperties;
        if (containerProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"containerProperties");
            containerProperties = null;
        }
        if (!containerProperties.getTestableContainer().getReuseBetweenRuns()) return false;
        ContainerProperties containerProperties2 = this.containerProperties;
        if (containerProperties2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"containerProperties");
            containerProperties2 = null;
        }
        ContextContainerProperties contextContainerProperties = containerProperties2.getContextContainers().get(this.getConfigurationKey());
        if (contextContainerProperties == null) return false;
        if (!contextContainerProperties.getReuseBetweenRuns()) return false;
        return true;
    }

    @Override
    @NotNull
    public T getTestContainer() {
        this.verifyRunning();
        T t = this.testContainer;
        Intrinsics.checkNotNull(t);
        return t;
    }

    public void verifyRunning() {
        if (!this.isRunning()) {
            throw new AssertionError((Object)"Contextual container is not started yet! Please start the context before trying to call this method.");
        }
    }

    public boolean isRunning() {
        T t = this.testContainer;
        return t != null ? t.isRunning() : false;
    }

    @NotNull
    public abstract T configure();
}

