/*
 * Decompiled with CFR 0.152.
 */
package com.nortal.test.testcontainers;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\u0010\u0010\t\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0018\u00010\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/nortal/test/testcontainers/ContainerUtils;", "", "()V", "log", "Lorg/slf4j/Logger;", "overrideNetworkAliases", "", "genericContainer", "Lorg/testcontainers/containers/GenericContainer;", "aliases", "", "", "test-automation-containers"})
public final class ContainerUtils {
    @NotNull
    public static final ContainerUtils INSTANCE = new ContainerUtils();
    @NotNull
    private static final Logger log;

    private ContainerUtils() {
    }

    public final void overrideNetworkAliases(@Nullable GenericContainer<?> genericContainer, @Nullable List<String> aliases) {
        try {
            GenericContainer<?> genericContainer2 = genericContainer;
            if (genericContainer2 != null) {
                genericContainer2.setNetworkAliases(aliases);
            }
        }
        catch (IllegalAccessException e) {
            log.error("Failed to override network alias", (Throwable)e);
        }
    }

    static {
        Logger logger = LoggerFactory.getLogger(INSTANCE.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(javaClass)");
        log = logger;
    }
}

