/*
 * Decompiled with CFR 0.152.
 */
package com.nortal.test.testcontainers;

import com.github.dockerjava.api.command.CreateNetworkCmd;
import com.github.dockerjava.api.model.Network;
import com.nortal.test.core.configuration.TestAutomationProperties;
import com.nortal.test.testcontainers.configuration.ContainerProperties;
import com.nortal.test.testcontainers.model.ReusedNetwork;
import jakarta.annotation.PostConstruct;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.Network;

@Component
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\nH\u0012J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0012J\b\u0010\u0013\u001a\u00020\nH\u0012J\b\u0010\u0014\u001a\u00020\u0015H\u0012J\b\u0010\u0016\u001a\u00020\u0017H\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/nortal/test/testcontainers/TestContainerNetworkProvider;", "", "testAutomationProperties", "Lcom/nortal/test/core/configuration/TestAutomationProperties;", "containerProperties", "Lcom/nortal/test/testcontainers/configuration/ContainerProperties;", "(Lcom/nortal/test/core/configuration/TestAutomationProperties;Lcom/nortal/test/testcontainers/configuration/ContainerProperties;)V", "log", "Lorg/slf4j/Logger;", "network", "Lorg/testcontainers/containers/Network;", "getNetwork", "()Lorg/testcontainers/containers/Network;", "setNetwork", "(Lorg/testcontainers/containers/Network;)V", "createReusableNetwork", "findExistingReusableNetwork", "Ljava/util/Optional;", "Lcom/github/dockerjava/api/model/Network;", "getReusableNetwork", "getReusableNetworkName", "", "startContext", "", "Companion", "test-automation-containers"})
public class TestContainerNetworkProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TestAutomationProperties testAutomationProperties;
    @NotNull
    private final ContainerProperties containerProperties;
    @NotNull
    private final Logger log;
    @Nullable
    private org.testcontainers.containers.Network network;
    @NotNull
    private static final String REUSABLE_NETWORK_NAME_PREFIX = "TEST-AUTOMATION-REUSABLE-NETWORK-";

    public TestContainerNetworkProvider(@NotNull TestAutomationProperties testAutomationProperties, @NotNull ContainerProperties containerProperties) {
        Intrinsics.checkNotNullParameter((Object)testAutomationProperties, (String)"testAutomationProperties");
        Intrinsics.checkNotNullParameter((Object)containerProperties, (String)"containerProperties");
        this.testAutomationProperties = testAutomationProperties;
        this.containerProperties = containerProperties;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(javaClass)");
        this.log = logger;
    }

    @Nullable
    public org.testcontainers.containers.Network getNetwork() {
        return this.network;
    }

    public void setNetwork(@Nullable org.testcontainers.containers.Network network) {
        this.network = network;
    }

    @PostConstruct
    public void startContext() {
        this.setNetwork(this.containerProperties.getTestableContainer().getReuseBetweenRuns() ? this.getReusableNetwork() : org.testcontainers.containers.Network.newNetwork());
        org.testcontainers.containers.Network network = this.getNetwork();
        this.log.info("Initializing docker network.. ID: [{}]", (Object)(network != null ? network.getId() : null));
    }

    private org.testcontainers.containers.Network getReusableNetwork() {
        org.testcontainers.containers.Network network;
        Optional<Network> reusableNetworkOptional = this.findExistingReusableNetwork();
        if (!reusableNetworkOptional.isPresent()) {
            network = this.createReusableNetwork();
        } else {
            String string = reusableNetworkOptional.get().getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"reusableNetworkOptional.get().id");
            network = new ReusedNetwork(string);
        }
        return network;
    }

    private String getReusableNetworkName() {
        return REUSABLE_NETWORK_NAME_PREFIX + this.testAutomationProperties.getEnvironment();
    }

    private org.testcontainers.containers.Network createReusableNetwork() {
        Network.NetworkImpl networkImpl = org.testcontainers.containers.Network.builder().createNetworkCmdModifier(arg_0 -> TestContainerNetworkProvider.createReusableNetwork$lambda$0(this, arg_0)).build();
        Intrinsics.checkNotNullExpressionValue((Object)networkImpl, (String)"builder()\n            .c\u2026)) }\n            .build()");
        return (org.testcontainers.containers.Network)networkImpl;
    }

    private Optional<Network> findExistingReusableNetwork() {
        List networks = (List)DockerClientFactory.instance().client().listNetworksCmd().exec();
        Optional<Object> optional = networks.stream().filter(arg_0 -> TestContainerNetworkProvider.findExistingReusableNetwork$lambda$1((Function1)new Function1<Network, Boolean>(this){
            final /* synthetic */ TestContainerNetworkProvider this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@Nullable Network ntwk) {
                Network network = ntwk;
                Intrinsics.checkNotNull((Object)network);
                return Intrinsics.areEqual((Object)network.getName(), (Object)TestContainerNetworkProvider.access$getReusableNetworkName(this.this$0));
            }
        }, arg_0)).findAny();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"private fun findExisting\u2026kName() }.findAny()\n    }");
        return optional;
    }

    private static final void createReusableNetwork$lambda$0(TestContainerNetworkProvider this$0, CreateNetworkCmd createNetworkCmd) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)createNetworkCmd, (String)"createNetworkCmd");
        createNetworkCmd.withName(this$0.getReusableNetworkName());
    }

    private static final boolean findExistingReusableNetwork$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ String access$getReusableNetworkName(TestContainerNetworkProvider $this) {
        return $this.getReusableNetworkName();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/nortal/test/testcontainers/TestContainerNetworkProvider$Companion;", "", "()V", "REUSABLE_NETWORK_NAME_PREFIX", "", "test-automation-containers"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

