/*
 * Decompiled with CFR 0.152.
 */
package com.nortal.test.testcontainers;

import com.nortal.test.core.services.TestableApplicationInfoProvider;
import com.nortal.test.testcontainers.ContainerUtils;
import com.nortal.test.testcontainers.TestContainerNetworkProvider;
import com.nortal.test.testcontainers.TestableApplicationContainerProvider;
import com.nortal.test.testcontainers.TestableContainerInitializer;
import com.nortal.test.testcontainers.configuration.TestableContainerProperties;
import com.nortal.test.testcontainers.configurator.TestContainerConfigurator;
import com.nortal.test.testcontainers.images.builder.ImageFromDockerfile;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermissions;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.CustomFixedHostPortGenericContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 !2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001!B+\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\f\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u000fH\u0016J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0011H\u0016J\b\u0010\u001b\u001a\u00020\u0011H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0014\u0010\u001e\u001a\u00020\u001d2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0012J\u0014\u0010 \u001a\u00020\u001d2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0014R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0092\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0016X\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/nortal/test/testcontainers/TestContainerService;", "Lcom/nortal/test/core/services/TestableApplicationInfoProvider;", "Lcom/nortal/test/testcontainers/TestableApplicationContainerProvider;", "Lcom/nortal/test/testcontainers/TestableContainerInitializer;", "testContainerNetworkProvider", "Lcom/nortal/test/testcontainers/TestContainerNetworkProvider;", "testableContainerProperties", "Lcom/nortal/test/testcontainers/configuration/TestableContainerProperties;", "testContainerConfigurator", "Lcom/nortal/test/testcontainers/configurator/TestContainerConfigurator;", "initListeners", "", "Lcom/nortal/test/testcontainers/configurator/TestContainerConfigurator$TestContainerInitListener;", "(Lcom/nortal/test/testcontainers/TestContainerNetworkProvider;Lcom/nortal/test/testcontainers/configuration/TestableContainerProperties;Lcom/nortal/test/testcontainers/configurator/TestContainerConfigurator;Ljava/util/List;)V", "exposedContainerHost", "", "exposedContainerPort", "", "Ljava/lang/Integer;", "log", "Lorg/slf4j/Logger;", "runningContainer", "Lorg/testcontainers/containers/GenericContainer;", "getContainer", "getHost", "getMappedPort", "internalPort", "getPort", "initialize", "", "mountDirectories", "applicationContainer", "startContainer", "Companion", "test-automation-containers"})
@SourceDebugExtension(value={"SMAP\nTestContainerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestContainerService.kt\ncom/nortal/test/testcontainers/TestContainerService\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,163:1\n37#2,2:164\n1855#3,2:166\n1855#3,2:168\n1855#3,2:170\n1855#3,2:172\n*S KotlinDebug\n*F\n+ 1 TestContainerService.kt\ncom/nortal/test/testcontainers/TestContainerService\n*L\n76#1:164,2\n84#1:166,2\n90#1:168,2\n94#1:170,2\n130#1:172,2\n*E\n"})
public class TestContainerService
implements TestableApplicationInfoProvider,
TestableApplicationContainerProvider,
TestableContainerInitializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TestContainerNetworkProvider testContainerNetworkProvider;
    @NotNull
    private final TestableContainerProperties testableContainerProperties;
    @NotNull
    private final TestContainerConfigurator testContainerConfigurator;
    @NotNull
    private final List<TestContainerConfigurator.TestContainerInitListener> initListeners;
    @NotNull
    private final Logger log;
    @Nullable
    private String exposedContainerHost;
    @Nullable
    private Integer exposedContainerPort;
    @Nullable
    private GenericContainer<?> runningContainer;
    @NotNull
    private static final AtomicBoolean INIT_FAILED = new AtomicBoolean(false);
    @NotNull
    public static final String TESTCONTAINERS_IMAGE_LABEL = "test-automation.image";
    @NotNull
    private static final String ERROR_NOT_INITIALIZED = "Testable container was not initialized. Check execution order.";

    public TestContainerService(@NotNull TestContainerNetworkProvider testContainerNetworkProvider, @NotNull TestableContainerProperties testableContainerProperties, @NotNull TestContainerConfigurator testContainerConfigurator, @NotNull List<? extends TestContainerConfigurator.TestContainerInitListener> initListeners) {
        Intrinsics.checkNotNullParameter((Object)testContainerNetworkProvider, (String)"testContainerNetworkProvider");
        Intrinsics.checkNotNullParameter((Object)testableContainerProperties, (String)"testableContainerProperties");
        Intrinsics.checkNotNullParameter((Object)testContainerConfigurator, (String)"testContainerConfigurator");
        Intrinsics.checkNotNullParameter(initListeners, (String)"initListeners");
        this.testContainerNetworkProvider = testContainerNetworkProvider;
        this.testableContainerProperties = testableContainerProperties;
        this.testContainerConfigurator = testContainerConfigurator;
        this.initListeners = initListeners;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(javaClass)");
        this.log = logger;
    }

    @Override
    public void initialize() {
        Logger logger = LoggerFactory.getLogger((String)this.testableContainerProperties.getInternalNetworkAlias());
        Slf4jLogConsumer logConsumer = new Slf4jLogConsumer(logger).withSeparateOutputStreams();
        ImageFromDockerfile imageDefinition = this.testContainerConfigurator.imageDefinition();
        Collection $this$toTypedArray$iv = this.testContainerConfigurator.exposedPorts();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new Integer[0]);
        CustomFixedHostPortGenericContainer customFixedHostPortGenericContainer = (CustomFixedHostPortGenericContainer)((CustomFixedHostPortGenericContainer)((CustomFixedHostPortGenericContainer)((CustomFixedHostPortGenericContainer)new CustomFixedHostPortGenericContainer((Future)((Object)imageDefinition)).withNetwork(this.testContainerNetworkProvider.getNetwork())).withExposedPorts(Arrays.copyOf(objectArray, objectArray.length))).withEnv(this.testContainerConfigurator.environmentalVariables())).withLogConsumer((Consumer)logConsumer);
        objectArray = new String[]{this.testableContainerProperties.getInternalNetworkAlias()};
        CustomFixedHostPortGenericContainer container = (CustomFixedHostPortGenericContainer)((CustomFixedHostPortGenericContainer)((CustomFixedHostPortGenericContainer)((CustomFixedHostPortGenericContainer)customFixedHostPortGenericContainer.withNetworkAliases((String[])objectArray)).withReuse(this.testableContainerProperties.getReuseBetweenRuns())).withLabel(TESTCONTAINERS_IMAGE_LABEL, imageDefinition.getDockerImageNameWithVersion())).withStartupTimeout(Duration.ofSeconds(this.testableContainerProperties.getStartupTimeout()));
        Iterable $this$forEach$iv = this.testContainerConfigurator.fixedExposedPorts();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)container), (String)"container");
            CustomFixedHostPortGenericContainer.withFixedExposedPort$default(container, it, it, null, 4, null);
        }
        Intrinsics.checkNotNullExpressionValue((Object)((Object)container), (String)"container");
        this.mountDirectories(container);
        $this$forEach$iv = this.initListeners;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TestContainerConfigurator.TestContainerInitListener it = (TestContainerConfigurator.TestContainerInitListener)element$iv;
            boolean bl = false;
            it.beforeStart(container);
        }
        this.startContainer(container);
        $this$forEach$iv = this.initListeners;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TestContainerConfigurator.TestContainerInitListener it = (TestContainerConfigurator.TestContainerInitListener)element$iv;
            boolean bl = false;
            it.afterStart(container);
        }
        this.runningContainer = container;
    }

    protected void startContainer(@NotNull GenericContainer<?> applicationContainer) {
        Intrinsics.checkNotNullParameter(applicationContainer, (String)"applicationContainer");
        if (INIT_FAILED.get()) {
            this.log.warn("Previous attempt to initialize container has failed. Disabling any subsequent tries.");
        } else {
            this.log.info("Starting application container..");
            StopWatch timer = StopWatch.createStarted();
            if (this.testableContainerProperties.getReuseBetweenRuns()) {
                ContainerUtils.INSTANCE.overrideNetworkAliases(applicationContainer, Collections.emptyList());
            }
            try {
                applicationContainer.start();
            }
            catch (ContainerLaunchException exception) {
                INIT_FAILED.set(true);
                throw exception;
            }
            this.log.info("Application container started in {} ms", (Object)timer.getTime());
            int firstPort = ((Number)CollectionsKt.first(this.testContainerConfigurator.exposedPorts())).intValue();
            this.exposedContainerPort = applicationContainer.getMappedPort(firstPort);
            this.exposedContainerHost = applicationContainer.getHost();
            Object[] objectArray = new Object[]{this.exposedContainerHost, firstPort, this.exposedContainerPort};
            this.log.info("Mapping the exposed internal application on {} port of {} to {}", objectArray);
        }
    }

    private void mountDirectories(GenericContainer<?> applicationContainer) {
        Iterable $this$forEach$iv = this.testableContainerProperties.getDirectoryMounts();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            String[] stringArray = new String[]{":"};
            List mappingSplit = StringsKt.split$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            String containerDir = (String)mappingSplit.get(0);
            String hostDir = (String)mappingSplit.get(1);
            Path logDirPath = Paths.get(hostDir, new String[0]);
            File logDir = logDirPath.toFile();
            logDir.mkdirs();
            if (SystemUtils.IS_OS_UNIX) {
                Files.setPosixFilePermissions(logDirPath, PosixFilePermissions.fromString("rwxrwxrwx"));
            }
            applicationContainer.withFileSystemBind(logDir.getAbsolutePath(), containerDir, BindMode.READ_WRITE);
            this.log.info("Mounting container dir {} to {}", (Object)containerDir, (Object)hostDir);
        }
    }

    @NotNull
    public String getHost() {
        String string = this.exposedContainerHost;
        if (string == null) {
            throw new AssertionError((Object)ERROR_NOT_INITIALIZED);
        }
        return string;
    }

    public int getPort() {
        Integer n = this.exposedContainerPort;
        if (n == null) {
            throw new AssertionError((Object)ERROR_NOT_INITIALIZED);
        }
        return n;
    }

    public int getMappedPort(int internalPort) {
        GenericContainer<?> genericContainer = this.runningContainer;
        Integer n = genericContainer != null ? genericContainer.getMappedPort(internalPort) : null;
        if (n == null) {
            throw new AssertionError((Object)ERROR_NOT_INITIALIZED);
        }
        return n;
    }

    @Override
    @NotNull
    public GenericContainer<?> getContainer() {
        GenericContainer<?> genericContainer = this.runningContainer;
        if (genericContainer == null) {
            throw new AssertionError((Object)ERROR_NOT_INITIALIZED);
        }
        return genericContainer;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/nortal/test/testcontainers/TestContainerService$Companion;", "", "()V", "ERROR_NOT_INITIALIZED", "", "INIT_FAILED", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getINIT_FAILED", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "TESTCONTAINERS_IMAGE_LABEL", "test-automation-containers"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AtomicBoolean getINIT_FAILED() {
            return INIT_FAILED;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

