/*
 * Decompiled with CFR 0.152.
 */
package com.nortal.test.testcontainers;

import com.nortal.test.testcontainers.AuxiliaryContainer;
import com.nortal.test.testcontainers.TestContainerNetworkProvider;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.time.StopWatch;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.testcontainers.containers.Network;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u001f\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0014J\b\u0010\r\u001a\u00020\u000bH\u0016R\u0018\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/nortal/test/testcontainers/TestContextContainerService;", "", "contextContainers", "", "Lcom/nortal/test/testcontainers/AuxiliaryContainer;", "testContainerNetworkProvider", "Lcom/nortal/test/testcontainers/TestContainerNetworkProvider;", "(Ljava/util/Collection;Lcom/nortal/test/testcontainers/TestContainerNetworkProvider;)V", "log", "Lorg/slf4j/Logger;", "startContainer", "", "auxiliaryContainer", "startContext", "test-automation-containers"})
public class TestContextContainerService {
    @NotNull
    private final Collection<AuxiliaryContainer<?>> contextContainers;
    @NotNull
    private final TestContainerNetworkProvider testContainerNetworkProvider;
    @NotNull
    private final Logger log;

    public TestContextContainerService(@NotNull Collection<? extends AuxiliaryContainer<?>> contextContainers, @NotNull TestContainerNetworkProvider testContainerNetworkProvider) {
        Intrinsics.checkNotNullParameter(contextContainers, (String)"contextContainers");
        Intrinsics.checkNotNullParameter((Object)testContainerNetworkProvider, (String)"testContainerNetworkProvider");
        this.contextContainers = contextContainers;
        this.testContainerNetworkProvider = testContainerNetworkProvider;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(javaClass)");
        this.log = logger;
    }

    public void startContext() {
        this.log.info("Starting context for {} containers", (Object)this.contextContainers.size());
        StopWatch timer = StopWatch.createStarted();
        this.contextContainers.parallelStream().forEach(arg_0 -> TestContextContainerService.startContext$lambda$0((Function1)new Function1<AuxiliaryContainer<?>, Unit>(this){
            final /* synthetic */ TestContextContainerService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(AuxiliaryContainer<?> it) {
                Intrinsics.checkNotNullExpressionValue(it, (String)"it");
                this.this$0.startContainer(it);
            }
        }, arg_0));
        this.log.info("Context containers started in {} ms", (Object)timer.getTime());
    }

    protected void startContainer(@NotNull AuxiliaryContainer<?> auxiliaryContainer) {
        Intrinsics.checkNotNullParameter(auxiliaryContainer, (String)"auxiliaryContainer");
        Network network = this.testContainerNetworkProvider.getNetwork();
        auxiliaryContainer.start(network);
    }

    private static final void startContext$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

