/*
 * Decompiled with CFR 0.152.
 */
package com.nortal.test.testcontainers.configurator;

import com.nortal.test.testcontainers.configuration.TestableContainerProperties;
import com.nortal.test.testcontainers.configurator.TestContainerConfigurator;
import com.nortal.test.testcontainers.images.builder.ImageFromDockerfile;
import com.nortal.test.testcontainers.images.builder.ReusableImageFromDockerfile;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.testcontainers.images.builder.dockerfile.DockerfileBuilder;
import org.testcontainers.images.builder.traits.DockerfileTrait;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0012\u0010\u0005\u001a\u00020\u00068\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\n8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/nortal/test/testcontainers/configurator/GenericTestContainerConfigurator;", "Lcom/nortal/test/testcontainers/configurator/TestContainerConfigurator;", "dockerImage", "", "(Ljava/lang/String;)V", "containerCustomizer", "Lcom/nortal/test/testcontainers/configurator/TestContainerConfigurator$TestContainerCustomizer;", "log", "Lorg/slf4j/Logger;", "testableContainerProperties", "Lcom/nortal/test/testcontainers/configuration/TestableContainerProperties;", "environmentalVariables", "", "exposedPorts", "", "", "imageDefinition", "Lcom/nortal/test/testcontainers/images/builder/ImageFromDockerfile;", "test-automation-containers"})
public class GenericTestContainerConfigurator
implements TestContainerConfigurator {
    @NotNull
    private final String dockerImage;
    @NotNull
    private final Logger log;
    @Autowired
    private TestableContainerProperties testableContainerProperties;
    @Autowired
    private TestContainerConfigurator.TestContainerCustomizer containerCustomizer;

    public GenericTestContainerConfigurator(@NotNull String dockerImage) {
        Intrinsics.checkNotNullParameter((Object)dockerImage, (String)"dockerImage");
        this.dockerImage = dockerImage;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(javaClass)");
        this.log = logger;
    }

    @Override
    @NotNull
    public ImageFromDockerfile imageDefinition() {
        this.log.info("Will run tests against container with image " + this.dockerImage);
        TestableContainerProperties testableContainerProperties = this.testableContainerProperties;
        if (testableContainerProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testableContainerProperties");
            testableContainerProperties = null;
        }
        DockerfileTrait dockerfileTrait = new ReusableImageFromDockerfile(this.dockerImage, false, testableContainerProperties.getReuseBetweenRuns()).withDockerfileFromBuilder(arg_0 -> GenericTestContainerConfigurator.imageDefinition$lambda$0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)dockerfileTrait, (String)"ReusableImageFromDockerf\u2026 { it.from(dockerImage) }");
        return (ImageFromDockerfile)dockerfileTrait;
    }

    @Override
    @NotNull
    public Map<String, String> environmentalVariables() {
        TestContainerConfigurator.TestContainerCustomizer testContainerCustomizer = this.containerCustomizer;
        if (testContainerCustomizer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"containerCustomizer");
            testContainerCustomizer = null;
        }
        return testContainerCustomizer.additionalEnvironmentalVariables();
    }

    @Override
    @NotNull
    public List<Integer> exposedPorts() {
        TestContainerConfigurator.TestContainerCustomizer testContainerCustomizer = this.containerCustomizer;
        if (testContainerCustomizer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"containerCustomizer");
            testContainerCustomizer = null;
        }
        return testContainerCustomizer.additionalExposedPorts();
    }

    private static final void imageDefinition$lambda$0(GenericTestContainerConfigurator this$0, DockerfileBuilder it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        it.from(this$0.dockerImage);
    }
}

