/*
 * Decompiled with CFR 0.152.
 */
package com.nortal.test.testcontainers.configurator;

import com.nortal.test.core.exception.TestConfigurationException;
import com.nortal.test.testcontainers.configuration.SpringBootTestContainerProperties;
import com.nortal.test.testcontainers.configuration.TestableContainerProperties;
import com.nortal.test.testcontainers.configurator.TestContainerConfigurator;
import com.nortal.test.testcontainers.images.builder.ImageFromDockerfile;
import com.nortal.test.testcontainers.images.builder.ReusableImageFromDockerfile;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.images.builder.dockerfile.DockerfileBuilder;
import org.testcontainers.utility.MountableFile;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 &2\u00020\u00012\u00020\u0002:\u0002&'B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0016J\u0014\u0010\u0010\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u0014\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J\u0013\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u001cH\u0002\u00a2\u0006\u0002\u0010\u001dJ\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018H\u0002J\b\u0010\u001f\u001a\u00020\u0016H\u0002J\b\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002R\u0012\u0010\u0004\u001a\u00020\u00058\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00078\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u000b8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/nortal/test/testcontainers/configurator/SpringBootTestContainerConfigurator;", "Lcom/nortal/test/testcontainers/configurator/TestContainerConfigurator;", "Lcom/nortal/test/testcontainers/configurator/TestContainerConfigurator$TestContainerInitListener;", "()V", "containerCustomizer", "Lcom/nortal/test/testcontainers/configurator/SpringBootTestContainerConfigurator$TestContainerCustomizer;", "containerProperties", "Lcom/nortal/test/testcontainers/configuration/SpringBootTestContainerProperties;", "log", "Lorg/slf4j/Logger;", "testableContainerProperties", "Lcom/nortal/test/testcontainers/configuration/TestableContainerProperties;", "afterStart", "", "container", "Lorg/testcontainers/containers/GenericContainer;", "beforeStart", "configure", "Lorg/testcontainers/images/builder/dockerfile/DockerfileBuilder;", "builder", "environmentalVariables", "", "", "exposedPorts", "", "", "fixedExposedPorts", "getCommandParts", "", "()[Ljava/lang/String;", "getDebugPart", "getJacocoPart", "imageDefinition", "Lcom/nortal/test/testcontainers/images/builder/ImageFromDockerfile;", "isMatchingJarFile", "", "path", "Ljava/nio/file/Path;", "Companion", "TestContainerCustomizer", "test-automation-containers"})
@SourceDebugExtension(value={"SMAP\nSpringBootTestContainerConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringBootTestContainerConfigurator.kt\ncom/nortal/test/testcontainers/configurator/SpringBootTestContainerConfigurator\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,204:1\n37#2,2:205\n*S KotlinDebug\n*F\n+ 1 SpringBootTestContainerConfigurator.kt\ncom/nortal/test/testcontainers/configurator/SpringBootTestContainerConfigurator\n*L\n182#1:205,2\n*E\n"})
public class SpringBootTestContainerConfigurator
implements TestContainerConfigurator,
TestContainerConfigurator.TestContainerInitListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger log;
    @Autowired
    private TestableContainerProperties testableContainerProperties;
    @Autowired
    private SpringBootTestContainerProperties containerProperties;
    @Autowired
    private TestContainerCustomizer containerCustomizer;
    @NotNull
    private static final String APP_JAR_PATH = "/app.jar";
    @NotNull
    private static final String JACOCO_CLASSPATH_PATH = "jacoco/org.jacoco.agent.jar";
    @NotNull
    private static final String JACOCO_AGENT_JAR_PATH = "/jacocoagent.jar";

    public SpringBootTestContainerConfigurator() {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(javaClass)");
        this.log = logger;
    }

    @Override
    @NotNull
    public ImageFromDockerfile imageDefinition() {
        Ref.ObjectRef jarBuildDir = new Ref.ObjectRef();
        SpringBootTestContainerProperties springBootTestContainerProperties = this.containerProperties;
        if (springBootTestContainerProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"containerProperties");
            springBootTestContainerProperties = null;
        }
        jarBuildDir.element = springBootTestContainerProperties.getJarBuildDir();
        Path appJarDir = Paths.get((String)jarBuildDir.element, new String[0]);
        Path appJarPath = Files.find(appJarDir, 1, (arg_0, arg_1) -> SpringBootTestContainerConfigurator.imageDefinition$lambda$0(this, arg_0, arg_1), new FileVisitOption[0]).findFirst().orElseThrow(() -> SpringBootTestContainerConfigurator.imageDefinition$lambda$1(jarBuildDir));
        this.log.info("Will use {} jar for container creation", (Object)((Object)appJarPath).toString());
        TestableContainerProperties testableContainerProperties = this.testableContainerProperties;
        if (testableContainerProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testableContainerProperties");
            testableContainerProperties = null;
        }
        String string = testableContainerProperties.getInternalNetworkAlias();
        TestableContainerProperties testableContainerProperties2 = this.testableContainerProperties;
        if (testableContainerProperties2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testableContainerProperties");
            testableContainerProperties2 = null;
        }
        ImageFromDockerfile reusableImageFromDockerfile = (ImageFromDockerfile)((ImageFromDockerfile)new ReusableImageFromDockerfile(string, false, testableContainerProperties2.getReuseBetweenRuns()).withFileFromPath(APP_JAR_PATH, appJarPath)).withFileFromClasspath(JACOCO_AGENT_JAR_PATH, JACOCO_CLASSPATH_PATH);
        TestContainerCustomizer testContainerCustomizer = this.containerCustomizer;
        if (testContainerCustomizer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"containerCustomizer");
            testContainerCustomizer = null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)((Object)reusableImageFromDockerfile), (String)"reusableImageFromDockerfile");
        testContainerCustomizer.customizeImageDefinition(reusableImageFromDockerfile);
        reusableImageFromDockerfile.withDockerfileFromBuilder(arg_0 -> SpringBootTestContainerConfigurator.imageDefinition$lambda$2(this, arg_0));
        return reusableImageFromDockerfile;
    }

    @Override
    public void beforeStart(@NotNull GenericContainer<?> container) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        SpringBootTestContainerProperties springBootTestContainerProperties = this.containerProperties;
        if (springBootTestContainerProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"containerProperties");
            springBootTestContainerProperties = null;
        }
        if (springBootTestContainerProperties.getJacoco().getEnabled()) {
            MountableFile mountableFile = MountableFile.forClasspathResource((String)JACOCO_CLASSPATH_PATH);
            container.withCopyFileToContainer(mountableFile, JACOCO_AGENT_JAR_PATH);
        }
    }

    @Override
    public void afterStart(@NotNull GenericContainer<?> container) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
    }

    @Override
    @NotNull
    public List<Integer> fixedExposedPorts() {
        List ports = new ArrayList();
        SpringBootTestContainerProperties springBootTestContainerProperties = this.containerProperties;
        if (springBootTestContainerProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"containerProperties");
            springBootTestContainerProperties = null;
        }
        if (springBootTestContainerProperties.getJarDebugEnabled()) {
            SpringBootTestContainerProperties springBootTestContainerProperties2 = this.containerProperties;
            if (springBootTestContainerProperties2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"containerProperties");
                springBootTestContainerProperties2 = null;
            }
            ports.add(springBootTestContainerProperties2.getDebugPort());
        }
        return ports;
    }

    @Override
    @NotNull
    public List<Integer> exposedPorts() {
        List ports = new ArrayList();
        TestContainerCustomizer testContainerCustomizer = this.containerCustomizer;
        if (testContainerCustomizer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"containerCustomizer");
            testContainerCustomizer = null;
        }
        ports.addAll((Collection)testContainerCustomizer.additionalExposedPorts());
        SpringBootTestContainerProperties springBootTestContainerProperties = this.containerProperties;
        if (springBootTestContainerProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"containerProperties");
            springBootTestContainerProperties = null;
        }
        if (springBootTestContainerProperties.getJacoco().getEnabled()) {
            SpringBootTestContainerProperties springBootTestContainerProperties2 = this.containerProperties;
            if (springBootTestContainerProperties2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"containerProperties");
                springBootTestContainerProperties2 = null;
            }
            ports.add(springBootTestContainerProperties2.getJacoco().getPort());
        }
        return ports;
    }

    @Override
    @NotNull
    public Map<String, String> environmentalVariables() {
        SpringBootTestContainerProperties springBootTestContainerProperties = this.containerProperties;
        if (springBootTestContainerProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"containerProperties");
            springBootTestContainerProperties = null;
        }
        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"spring.profiles.active", (Object)springBootTestContainerProperties.getSpringProfilesToActivate()));
        TestContainerCustomizer testContainerCustomizer = this.containerCustomizer;
        if (testContainerCustomizer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"containerCustomizer");
            testContainerCustomizer = null;
        }
        return MapsKt.plus((Map)map, testContainerCustomizer.additionalEnvironmentalVariables());
    }

    private final DockerfileBuilder configure(DockerfileBuilder builder) {
        TestContainerCustomizer testContainerCustomizer;
        SpringBootTestContainerProperties springBootTestContainerProperties = this.containerProperties;
        if (springBootTestContainerProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"containerProperties");
            springBootTestContainerProperties = null;
        }
        String baseImage = springBootTestContainerProperties.getBaseImage();
        String[] stringArray = this.getCommandParts();
        ((DockerfileBuilder)((DockerfileBuilder)builder.from(baseImage)).copy(APP_JAR_PATH, APP_JAR_PATH)).entryPoint(Arrays.copyOf(stringArray, stringArray.length));
        SpringBootTestContainerProperties springBootTestContainerProperties2 = this.containerProperties;
        if (springBootTestContainerProperties2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"containerProperties");
            springBootTestContainerProperties2 = null;
        }
        if (springBootTestContainerProperties2.getJacoco().getEnabled()) {
            builder.copy(JACOCO_AGENT_JAR_PATH, JACOCO_AGENT_JAR_PATH);
        }
        if ((testContainerCustomizer = this.containerCustomizer) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"containerCustomizer");
            testContainerCustomizer = null;
        }
        testContainerCustomizer.customizeDockerFileBuilder(builder);
        return builder;
    }

    private final boolean isMatchingJarFile(Path path) {
        CharSequence charSequence = ((Object)path.getFileName()).toString();
        SpringBootTestContainerProperties springBootTestContainerProperties = this.containerProperties;
        if (springBootTestContainerProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"containerProperties");
            springBootTestContainerProperties = null;
        }
        return new Regex(springBootTestContainerProperties.getJarRegexMatcher()).matches(charSequence);
    }

    private final String[] getCommandParts() {
        SpringBootTestContainerProperties springBootTestContainerProperties;
        List commandParts = new ArrayList();
        commandParts.add("java");
        SpringBootTestContainerProperties springBootTestContainerProperties2 = this.containerProperties;
        if (springBootTestContainerProperties2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"containerProperties");
            springBootTestContainerProperties2 = null;
        }
        commandParts.add(springBootTestContainerProperties2.getMemorySettings());
        TestContainerCustomizer testContainerCustomizer = this.containerCustomizer;
        if (testContainerCustomizer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"containerCustomizer");
            testContainerCustomizer = null;
        }
        commandParts.addAll((Collection)testContainerCustomizer.customizeCommandParts());
        SpringBootTestContainerProperties springBootTestContainerProperties3 = this.containerProperties;
        if (springBootTestContainerProperties3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"containerProperties");
            springBootTestContainerProperties3 = null;
        }
        if (springBootTestContainerProperties3.getJarDebugEnabled()) {
            commandParts.addAll((Collection)this.getDebugPart());
        }
        if ((springBootTestContainerProperties = this.containerProperties) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"containerProperties");
            springBootTestContainerProperties = null;
        }
        if (springBootTestContainerProperties.getJacoco().getEnabled()) {
            commandParts.add(this.getJacocoPart());
        }
        commandParts.add("-jar");
        commandParts.add(APP_JAR_PATH);
        Collection $this$toTypedArray$iv = commandParts;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    private final String getJacocoPart() {
        String string = "-javaagent:/jacocoagent.jar=address=*,port=%d,output=tcpserver";
        Object[] objectArray = new Object[1];
        SpringBootTestContainerProperties springBootTestContainerProperties = this.containerProperties;
        if (springBootTestContainerProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"containerProperties");
            springBootTestContainerProperties = null;
        }
        objectArray[0] = springBootTestContainerProperties.getJacoco().getPort();
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }

    private final List<String> getDebugPart() {
        Object[] objectArray = new String[2];
        objectArray[0] = "-Xdebug";
        String string = "-Xrunjdwp:transport=dt_socket,address=*:%d,server=y,suspend=%s";
        Object[] objectArray2 = new Object[2];
        SpringBootTestContainerProperties springBootTestContainerProperties = this.containerProperties;
        if (springBootTestContainerProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"containerProperties");
            springBootTestContainerProperties = null;
        }
        objectArray2[0] = springBootTestContainerProperties.getDebugPort();
        SpringBootTestContainerProperties springBootTestContainerProperties2 = this.containerProperties;
        if (springBootTestContainerProperties2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"containerProperties");
            springBootTestContainerProperties2 = null;
        }
        objectArray2[1] = springBootTestContainerProperties2.getWaitForDebugger() ? "y" : "n";
        Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(format, *args)");
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final boolean imageDefinition$lambda$0(SpringBootTestContainerConfigurator this$0, Path t, BasicFileAttributes basicFileAttributes) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)t, (String)"t");
        return this$0.isMatchingJarFile(t);
    }

    private static final TestConfigurationException imageDefinition$lambda$1(Ref.ObjectRef $jarBuildDir) {
        Intrinsics.checkNotNullParameter((Object)$jarBuildDir, (String)"$jarBuildDir");
        return new TestConfigurationException("Failed to find jar in " + $jarBuildDir.element);
    }

    private static final void imageDefinition$lambda$2(SpringBootTestContainerConfigurator this$0, DockerfileBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder");
        this$0.configure(builder).build();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/nortal/test/testcontainers/configurator/SpringBootTestContainerConfigurator$Companion;", "", "()V", "APP_JAR_PATH", "", "JACOCO_AGENT_JAR_PATH", "JACOCO_CLASSPATH_PATH", "test-automation-containers"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lcom/nortal/test/testcontainers/configurator/SpringBootTestContainerConfigurator$TestContainerCustomizer;", "Lcom/nortal/test/testcontainers/configurator/TestContainerConfigurator$TestContainerCustomizer;", "customizeCommandParts", "", "", "customizeDockerFileBuilder", "", "builder", "Lorg/testcontainers/images/builder/dockerfile/DockerfileBuilder;", "customizeImageDefinition", "reusableImageFromDockerfile", "Lcom/nortal/test/testcontainers/images/builder/ImageFromDockerfile;", "test-automation-containers"})
    public static interface TestContainerCustomizer
    extends TestContainerConfigurator.TestContainerCustomizer {
        public void customizeImageDefinition(@NotNull ImageFromDockerfile var1);

        @NotNull
        default public List<String> customizeCommandParts() {
            return CollectionsKt.emptyList();
        }

        public void customizeDockerFileBuilder(@NotNull DockerfileBuilder var1);
    }
}

