/*
 * Decompiled with CFR 0.152.
 */
package com.nortal.test.testcontainers.hook;

import com.nortal.test.core.exception.TestAutomationException;
import com.nortal.test.core.services.ScenarioExecutionContext;
import com.nortal.test.core.services.hooks.BeforeScenarioHook;
import com.nortal.test.core.services.hooks.BeforeSuiteHook;
import com.nortal.test.testcontainers.TestContainerService;
import com.nortal.test.testcontainers.TestContextContainerService;
import com.nortal.test.testcontainers.TestableContainerInitializer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000bH\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/nortal/test/testcontainers/hook/ContainerHealthCheckHook;", "Lcom/nortal/test/core/services/hooks/BeforeSuiteHook;", "Lcom/nortal/test/core/services/hooks/BeforeScenarioHook;", "testContextContainerService", "Lcom/nortal/test/testcontainers/TestContextContainerService;", "testableContainerInitializer", "Lcom/nortal/test/testcontainers/TestableContainerInitializer;", "(Lcom/nortal/test/testcontainers/TestContextContainerService;Lcom/nortal/test/testcontainers/TestableContainerInitializer;)V", "log", "Lorg/slf4j/Logger;", "before", "", "scenario", "Lcom/nortal/test/core/services/ScenarioExecutionContext;", "beforeScenarioOrder", "", "beforeSuite", "beforeSuiteOrder", "test-automation-containers"})
public class ContainerHealthCheckHook
implements BeforeSuiteHook,
BeforeScenarioHook {
    @NotNull
    private final TestContextContainerService testContextContainerService;
    @NotNull
    private final TestableContainerInitializer testableContainerInitializer;
    @NotNull
    private final Logger log;

    public ContainerHealthCheckHook(@NotNull TestContextContainerService testContextContainerService, @NotNull TestableContainerInitializer testableContainerInitializer) {
        Intrinsics.checkNotNullParameter((Object)testContextContainerService, (String)"testContextContainerService");
        Intrinsics.checkNotNullParameter((Object)testableContainerInitializer, (String)"testableContainerInitializer");
        this.testContextContainerService = testContextContainerService;
        this.testableContainerInitializer = testableContainerInitializer;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(javaClass)");
        this.log = logger;
    }

    public int beforeSuiteOrder() {
        return 9900;
    }

    public void beforeSuite() {
        try {
            this.testContextContainerService.startContext();
            this.testableContainerInitializer.initialize();
        }
        catch (Exception exception) {
            this.log.error("Container startup has failed.", (Throwable)exception);
            throw new TestAutomationException("Container startup has failed.", exception);
        }
    }

    public void before(@NotNull ScenarioExecutionContext scenario) {
        Intrinsics.checkNotNullParameter((Object)scenario, (String)"scenario");
        if (TestContainerService.Companion.getINIT_FAILED().get()) {
            throw new TestAutomationException("Stopping scenario execution as test container is in failed state", null, 2, null);
        }
    }

    public int beforeScenarioOrder() {
        return 0;
    }
}

