/*
 * Decompiled with CFR 0.152.
 */
package com.nortal.test.testcontainers.images.builder;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.command.BuildImageResultCallback;
import com.github.dockerjava.api.model.BuildResponseItem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.images.ParsedDockerfile;
import org.testcontainers.images.RemoteDockerImage;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.images.builder.traits.BuildContextBuilderTrait;
import org.testcontainers.images.builder.traits.ClasspathTrait;
import org.testcontainers.images.builder.traits.DockerfileTrait;
import org.testcontainers.images.builder.traits.FilesTrait;
import org.testcontainers.images.builder.traits.StringsTrait;
import org.testcontainers.utility.Base58;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.DockerLoggerFactory;
import org.testcontainers.utility.ImageNameSubstitutor;
import org.testcontainers.utility.LazyFuture;
import org.testcontainers.utility.ResourceReaper;

public class ImageFromDockerfile
extends LazyFuture<String>
implements BuildContextBuilderTrait<ImageFromDockerfile>,
ClasspathTrait<ImageFromDockerfile>,
FilesTrait<ImageFromDockerfile>,
StringsTrait<ImageFromDockerfile>,
DockerfileTrait<ImageFromDockerfile> {
    private final String dockerImageName;
    private boolean deleteOnExit = true;
    private final Map<String, Transferable> transferables = new HashMap<String, Transferable>();
    private final Map<String, String> buildArgs = new HashMap<String, String>();
    private Optional<String> dockerFilePath = Optional.empty();
    private Optional<Path> dockerfile = Optional.empty();
    private Optional<String> target = Optional.empty();
    private Optional<String> platform = Optional.empty();
    private Set<String> dependencyImageNames = Collections.emptySet();

    public ImageFromDockerfile() {
        this("localhost/testcontainers/" + Base58.randomString((int)16).toLowerCase());
    }

    public ImageFromDockerfile(String dockerImageName) {
        this(dockerImageName, true);
    }

    public ImageFromDockerfile(String dockerImageName, boolean deleteOnExit) {
        this.dockerImageName = dockerImageName;
        this.deleteOnExit = deleteOnExit;
    }

    public ImageFromDockerfile withFileFromTransferable(String path, Transferable transferable) {
        Transferable oldValue = this.transferables.put(path, transferable);
        if (oldValue != null) {
            this.logger().warn("overriding previous mapping for '{}'", (Object)path);
        }
        return this;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected final String resolve() {
        final Logger logger = this.logger();
        DockerClient dockerClient = DockerClientFactory.instance().client();
        try (PipedInputStream in = new PipedInputStream();){
            String string;
            try (PipedOutputStream out = new PipedOutputStream(in);){
                if (this.deleteOnExit) {
                    ResourceReaper.instance().registerImageForCleanup(this.dockerImageName);
                }
                BuildImageResultCallback resultCallback = new BuildImageResultCallback(){

                    public void onNext(BuildResponseItem item) {
                        super.onNext(item);
                        if (item.isErrorIndicated()) {
                            logger.error(item.getErrorDetail().getMessage());
                        } else {
                            logger.info(StringUtils.chomp((String)item.getStream(), (String)"\n"));
                        }
                    }
                };
                BuildImageCmd buildImageCmd = dockerClient.buildImageCmd((InputStream)in);
                this.configure(buildImageCmd);
                this.addApplicableLabels(buildImageCmd);
                this.prePullDependencyImages(this.dependencyImageNames);
                BuildImageResultCallback exec = (BuildImageResultCallback)buildImageCmd.exec((ResultCallback)resultCallback);
                long bytesToDockerDaemon = 0L;
                try (TarArchiveOutputStream tarArchive = new TarArchiveOutputStream((OutputStream)new GZIPOutputStream(out));){
                    tarArchive.setLongFileMode(3);
                    tarArchive.setBigNumberMode(2);
                    for (Map.Entry<String, Transferable> entry : this.transferables.entrySet()) {
                        Transferable transferable = entry.getValue();
                        String destination = entry.getKey();
                        transferable.transferTo(tarArchive, destination);
                        bytesToDockerDaemon += transferable.getSize();
                    }
                    tarArchive.finish();
                }
                logger.info("Transferred {} to Docker daemon", (Object)FileUtils.byteCountToDisplaySize((long)bytesToDockerDaemon));
                if (bytesToDockerDaemon > 0x3200000L) {
                    logger.warn("A large amount of data was sent to the Docker daemon ({}). Consider using a .dockerignore file for better performance.", (Object)FileUtils.byteCountToDisplaySize((long)bytesToDockerDaemon));
                }
                exec.awaitImageId();
                string = this.dockerImageName;
            }
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Can't close DockerClient", e);
        }
    }

    protected void addApplicableLabels(BuildImageCmd buildImageCmd) {
        HashMap labels = new HashMap();
        if (buildImageCmd.getLabels() != null) {
            labels.putAll(buildImageCmd.getLabels());
        }
        labels.putAll(DockerClientFactory.DEFAULT_LABELS);
        if (this.deleteOnExit) {
            labels.putAll(ResourceReaper.instance().getLabels());
        }
        buildImageCmd.withLabels(labels);
    }

    protected void configure(BuildImageCmd buildImageCmd) {
        buildImageCmd.withTag(this.getDockerImageName());
        this.dockerFilePath.ifPresent(arg_0 -> ((BuildImageCmd)buildImageCmd).withDockerfilePath(arg_0));
        this.dockerfile.ifPresent(p -> {
            buildImageCmd.withDockerfile(p.toFile());
            this.dependencyImageNames = new ParsedDockerfile(p).getDependencyImageNames();
            if (this.dependencyImageNames.size() > 0) {
                buildImageCmd.withPull(Boolean.valueOf(false));
            }
        });
        this.buildArgs.forEach((arg_0, arg_1) -> ((BuildImageCmd)buildImageCmd).withBuildArg(arg_0, arg_1));
        this.target.ifPresent(arg_0 -> ((BuildImageCmd)buildImageCmd).withTarget(arg_0));
        this.platform.ifPresent(arg_0 -> ((BuildImageCmd)buildImageCmd).withPlatform(arg_0));
    }

    private void prePullDependencyImages(Set<String> imagesToPull) {
        imagesToPull.forEach(imageName -> {
            try {
                this.logger().info("Pre-emptively checking local images for '{}', referenced via a Dockerfile. If not available, it will be pulled.", imageName);
                new RemoteDockerImage(DockerImageName.parse((String)imageName)).withImageNameSubstitutor(ImageNameSubstitutor.noop()).get();
            }
            catch (Exception e) {
                this.logger().warn("Unable to pre-fetch an image ({}) depended upon by Dockerfile - image build will continue but may fail. Exception message was: {}", imageName, (Object)e.getMessage());
            }
        });
    }

    public ImageFromDockerfile withBuildArg(String key, String value) {
        this.buildArgs.put(key, value);
        return this;
    }

    public ImageFromDockerfile withBuildArgs(Map<String, String> args) {
        this.buildArgs.putAll(args);
        return this;
    }

    @Deprecated
    public ImageFromDockerfile withDockerfilePath(String relativePathFromBuildContextDirectory) {
        this.dockerFilePath = Optional.of(relativePathFromBuildContextDirectory);
        return this;
    }

    public ImageFromDockerfile withTarget(String target) {
        this.target = Optional.of(target);
        return this;
    }

    public ImageFromDockerfile withPlatform(String platform) {
        this.platform = Optional.of(platform);
        return this;
    }

    public ImageFromDockerfile withDockerfile(Path dockerfile) {
        this.dockerfile = Optional.of(dockerfile);
        return this;
    }

    public String getDockerImageName() {
        return this.dockerImageName;
    }

    public String getDockerImageNameWithVersion() {
        return this.dockerImageName + ":latest";
    }

    private Logger logger() {
        return DockerLoggerFactory.getLogger((String)this.dockerImageName);
    }
}

