/*
 * Decompiled with CFR 0.152.
 */
package com.nortal.test.testcontainers.images.builder;

import com.github.dockerjava.api.command.BuildImageCmd;
import com.nortal.test.testcontainers.images.builder.ImageFromDockerfile;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.images.DockerTestUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014J\b\u0010\u000e\u001a\u00020\u0003H\u0016J(\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0010H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/nortal/test/testcontainers/images/builder/ReusableImageFromDockerfile;", "Lcom/nortal/test/testcontainers/images/builder/ImageFromDockerfile;", "dockerImageName", "", "deleteOnExit", "", "reusableContainer", "(Ljava/lang/String;ZZ)V", "log", "Lorg/slf4j/Logger;", "addApplicableLabels", "", "buildImageCmd", "Lcom/github/dockerjava/api/command/BuildImageCmd;", "get", "removeSessionIdLabel", "", "labels", "test-automation-containers"})
public final class ReusableImageFromDockerfile
extends ImageFromDockerfile {
    private final boolean reusableContainer;
    @NotNull
    private final Logger log;

    public ReusableImageFromDockerfile(@NotNull String dockerImageName, boolean deleteOnExit, boolean reusableContainer) {
        Intrinsics.checkNotNullParameter((Object)dockerImageName, (String)"dockerImageName");
        super(dockerImageName, deleteOnExit);
        this.reusableContainer = reusableContainer;
        Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(javaClass)");
        this.log = logger;
    }

    @Override
    protected void addApplicableLabels(@Nullable BuildImageCmd buildImageCmd) {
        Map labels = new HashMap();
        BuildImageCmd buildImageCmd2 = buildImageCmd;
        Intrinsics.checkNotNull((Object)buildImageCmd2);
        if (buildImageCmd2.getLabels() != null) {
            Map map = buildImageCmd.getLabels();
            Intrinsics.checkNotNull((Object)map);
            labels.putAll(map);
        }
        if (this.reusableContainer) {
            Map map = DockerClientFactory.DEFAULT_LABELS;
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"DEFAULT_LABELS");
            labels.putAll(this.removeSessionIdLabel(map));
        } else {
            Map map = DockerClientFactory.DEFAULT_LABELS;
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"DEFAULT_LABELS");
            labels.putAll(map);
        }
        buildImageCmd.withLabels(labels);
    }

    @NotNull
    public String get() {
        if (this.reusableContainer) {
            String string = this.getDockerImageNameWithVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dockerImageNameWithVersion");
            if (DockerTestUtils.INSTANCE.isContainerOfImageRunning(string)) {
                this.log.warn("Skipping DockerFile build as reusable container is enabled and container is running!");
                String string2 = this.getDockerImageNameWithVersion();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dockerImageNameWithVersion");
                return string2;
            }
        }
        Object object = super.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"super.get()");
        return (String)object;
    }

    private final Map<String, String> removeSessionIdLabel(Map<String, String> labels) {
        Map defaultLabels = new HashMap<String, String>(labels);
        defaultLabels.remove(DockerClientFactory.TESTCONTAINERS_SESSION_ID_LABEL);
        return defaultLabels;
    }
}

