/*
 * Decompiled with CFR 0.152.
 */
package com.nortal.test.testcontainers.jacoco;

import com.nortal.test.core.exception.TestAutomationException;
import com.nortal.test.core.services.TestableApplicationInfoProvider;
import com.nortal.test.core.services.hooks.AfterSuiteHook;
import com.nortal.test.testcontainers.configuration.TestableContainerJacocoProperties;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.apache.commons.lang3.time.StopWatch;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.data.ExecutionDataWriter;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.runtime.RemoteControlReader;
import org.jacoco.core.runtime.RemoteControlWriter;
import org.jacoco.core.tools.ExecFileLoader;
import org.jacoco.report.DirectorySourceFileLocator;
import org.jacoco.report.FileMultiReportOutput;
import org.jacoco.report.IMultiReportOutput;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISourceFileLocator;
import org.jacoco.report.html.HTMLFormatter;
import org.jacoco.report.xml.XMLFormatter;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0012J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0012J\b\u0010\u0011\u001a\u00020\nH\u0012J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0012J\b\u0010\u0013\u001a\u00020\nH\u0012J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0012J\b\u0010\u0018\u001a\u00020\nH\u0012J \u0010\u0019\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/nortal/test/testcontainers/jacoco/JacocoCoverageReportGenerator;", "Lcom/nortal/test/core/services/hooks/AfterSuiteHook;", "jacocoProperties", "Lcom/nortal/test/testcontainers/configuration/TestableContainerJacocoProperties;", "testableApplicationInfoProvider", "Lcom/nortal/test/core/services/TestableApplicationInfoProvider;", "(Lcom/nortal/test/testcontainers/configuration/TestableContainerJacocoProperties;Lcom/nortal/test/core/services/TestableApplicationInfoProvider;)V", "log", "Lorg/slf4j/Logger;", "afterSuite", "", "analyzeStructure", "Lorg/jacoco/core/analysis/IBundleCoverage;", "execFileLoader", "Lorg/jacoco/core/tools/ExecFileLoader;", "createHtmlReport", "bundleCoverage", "createTargetDir", "createXmlReport", "generateReport", "getFileOnDestDirPath", "Ljava/nio/file/Path;", "fileName", "", "transferExecutionData", "visitResults", "visitor", "Lorg/jacoco/report/IReportVisitor;", "Companion", "test-automation-containers"})
public class JacocoCoverageReportGenerator
implements AfterSuiteHook {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TestableContainerJacocoProperties jacocoProperties;
    @NotNull
    private final TestableApplicationInfoProvider testableApplicationInfoProvider;
    @NotNull
    private final Logger log;
    @NotNull
    private static final String FILE_EXEC = "system-tests.exec";
    @NotNull
    private static final String FILE_XML = "system-tests.xml";

    public JacocoCoverageReportGenerator(@NotNull TestableContainerJacocoProperties jacocoProperties, @NotNull TestableApplicationInfoProvider testableApplicationInfoProvider) {
        Intrinsics.checkNotNullParameter((Object)jacocoProperties, (String)"jacocoProperties");
        Intrinsics.checkNotNullParameter((Object)testableApplicationInfoProvider, (String)"testableApplicationInfoProvider");
        this.jacocoProperties = jacocoProperties;
        this.testableApplicationInfoProvider = testableApplicationInfoProvider;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(javaClass)");
        this.log = logger;
    }

    public void afterSuite() {
        if (!this.jacocoProperties.getEnabled()) {
            this.log.info("Jacoco is disabled. Skipping report generation.");
            return;
        }
        try {
            StopWatch stopWatch = StopWatch.createStarted();
            this.log.info("Generating Jacoco report...");
            this.transferExecutionData();
            this.generateReport();
            this.log.info("Jacoco report generated in {}ms.", (Object)stopWatch.getTime(TimeUnit.MILLISECONDS));
        }
        catch (Exception e) {
            this.log.error("Failed to generate Jacoco report", (Throwable)e);
            throw new TestAutomationException("System tests coverage report generator failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateReport() throws IOException {
        ExecFileLoader execFileLoader = new ExecFileLoader();
        Closeable closeable = Files.newInputStream(this.getFileOnDestDirPath(FILE_EXEC), new OpenOption[0]);
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            execFileLoader.load(it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        IBundleCoverage bundleCoverage = this.analyzeStructure(execFileLoader);
        this.createXmlReport(bundleCoverage, execFileLoader);
        this.createHtmlReport(bundleCoverage, execFileLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IBundleCoverage analyzeStructure(ExecFileLoader execFileLoader) throws IOException {
        CoverageBuilder coverageBuilder = new CoverageBuilder();
        Analyzer analyzer = new Analyzer(execFileLoader.getExecutionDataStore(), (ICoverageVisitor)coverageBuilder);
        AutoCloseable autoCloseable = Files.find(Paths.get("..", new String[0]), 10, (arg_0, arg_1) -> JacocoCoverageReportGenerator.analyzeStructure$lambda$1(this, arg_0, arg_1), new FileVisitOption[0]);
        Throwable throwable = null;
        try {
            Stream stream = (Stream)autoCloseable;
            boolean bl = false;
            stream.forEach(arg_0 -> JacocoCoverageReportGenerator.analyzeStructure$lambda$3$lambda$2((Function1)new Function1<Path, Unit>(analyzer){
                final /* synthetic */ Analyzer $analyzer;
                {
                    this.$analyzer = $analyzer;
                    super(1);
                }

                public final void invoke(Path path) {
                    try {
                        this.$analyzer.analyzeAll(path.toFile());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }, arg_0));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        IBundleCoverage iBundleCoverage = coverageBuilder.getBundle("System tests coverage report");
        Intrinsics.checkNotNullExpressionValue((Object)iBundleCoverage, (String)"coverageBuilder.getBundl\u2026m tests coverage report\")");
        return iBundleCoverage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createXmlReport(IBundleCoverage bundleCoverage, ExecFileLoader execFileLoader) throws IOException {
        Closeable closeable = Files.newOutputStream(this.getFileOnDestDirPath(FILE_XML), new OpenOption[0]);
        Throwable throwable = null;
        try {
            OutputStream it = (OutputStream)closeable;
            boolean bl = false;
            IReportVisitor visitor = new XMLFormatter().createVisitor(it);
            Intrinsics.checkNotNullExpressionValue((Object)visitor, (String)"visitor");
            this.visitResults(bundleCoverage, execFileLoader, visitor);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private void createHtmlReport(IBundleCoverage bundleCoverage, ExecFileLoader execFileLoader) throws IOException {
        HTMLFormatter htmlFormatter = new HTMLFormatter();
        IReportVisitor visitor = htmlFormatter.createVisitor((IMultiReportOutput)new FileMultiReportOutput(new File(this.jacocoProperties.getDestReportDir())));
        Intrinsics.checkNotNullExpressionValue((Object)visitor, (String)"visitor");
        this.visitResults(bundleCoverage, execFileLoader, visitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitResults(IBundleCoverage bundleCoverage, ExecFileLoader execFileLoader, IReportVisitor visitor) throws IOException {
        visitor.visitInfo(execFileLoader.getSessionInfoStore().getInfos(), execFileLoader.getExecutionDataStore().getContents());
        AutoCloseable autoCloseable = Files.find(Paths.get("..", new String[0]), 10, (arg_0, arg_1) -> JacocoCoverageReportGenerator.visitResults$lambda$5(this, arg_0, arg_1), new FileVisitOption[0]);
        Throwable throwable = null;
        try {
            Stream stream = (Stream)autoCloseable;
            boolean bl = false;
            stream.forEach(arg_0 -> JacocoCoverageReportGenerator.visitResults$lambda$7$lambda$6((Function1)new Function1<Path, Unit>(visitor, bundleCoverage){
                final /* synthetic */ IReportVisitor $visitor;
                final /* synthetic */ IBundleCoverage $bundleCoverage;
                {
                    this.$visitor = $visitor;
                    this.$bundleCoverage = $bundleCoverage;
                    super(1);
                }

                public final void invoke(Path path) {
                    try {
                        this.$visitor.visitBundle(this.$bundleCoverage, (ISourceFileLocator)new DirectorySourceFileLocator(path.toFile(), "UTF-8", 2));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }, arg_0));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        visitor.visitEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferExecutionData() throws IOException {
        this.createTargetDir();
        int mappedPort = this.testableApplicationInfoProvider.getMappedPort(this.jacocoProperties.getPort());
        Closeable closeable = new Socket(InetAddress.getByName(this.jacocoProperties.getHost()), mappedPort);
        Throwable throwable = null;
        try {
            Socket socket = (Socket)closeable;
            boolean bl = false;
            Closeable closeable2 = Files.newOutputStream(this.getFileOnDestDirPath(FILE_EXEC), new OpenOption[0]);
            Throwable throwable2 = null;
            try {
                OutputStream localFile = (OutputStream)closeable2;
                boolean bl2 = false;
                ExecutionDataWriter localWriter = new ExecutionDataWriter(localFile);
                RemoteControlWriter writer = new RemoteControlWriter(socket.getOutputStream());
                RemoteControlReader reader = new RemoteControlReader(socket.getInputStream());
                reader.setSessionInfoVisitor((ISessionInfoVisitor)localWriter);
                reader.setExecutionDataVisitor((IExecutionDataVisitor)localWriter);
                writer.visitDumpCommand(true, false);
                if (!reader.read()) {
                    throw new IOException("Socket closed unexpectedly.");
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private void createTargetDir() {
        File targetDir = new File(this.jacocoProperties.getDestDir());
        if (!targetDir.exists()) {
            targetDir.mkdir();
        }
    }

    private Path getFileOnDestDirPath(String fileName) {
        Path path = Paths.get(this.jacocoProperties.getDestDir() + fileName, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(jacocoProperties.destDir + fileName)");
        return path;
    }

    private static final boolean analyzeStructure$lambda$1(JacocoCoverageReportGenerator this$0, Path path, BasicFileAttributes basicFileAttributes) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        CharSequence charSequence = ((Object)path).toString();
        return new Regex(this$0.jacocoProperties.getStructureAnalysisRegex()).matches(charSequence);
    }

    private static final void analyzeStructure$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean visitResults$lambda$5(JacocoCoverageReportGenerator this$0, Path path, BasicFileAttributes basicFileAttributes) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        CharSequence charSequence = ((Object)path).toString();
        return new Regex(this$0.jacocoProperties.getSourceCodeLookupRegex()).matches(charSequence);
    }

    private static final void visitResults$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/nortal/test/testcontainers/jacoco/JacocoCoverageReportGenerator$Companion;", "", "()V", "FILE_EXEC", "", "FILE_XML", "test-automation-containers"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

