/*
 * Decompiled with CFR 0.152.
 */
package com.nortal.test.feign;

import com.nortal.test.feign.configuration.FeignProperties;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\u000f\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/nortal/test/feign/OkHttpClientFactory;", "", "feignProperties", "Lcom/nortal/test/feign/configuration/FeignProperties;", "(Lcom/nortal/test/feign/configuration/FeignProperties;)V", "preBakedHttpClient", "Lokhttp3/OkHttpClient$Builder;", "getPreBakedHttpClient", "()Lokhttp3/OkHttpClient$Builder;", "trustManager", "Ljavax/net/ssl/X509TrustManager;", "getTrustManager", "()Ljavax/net/ssl/X509TrustManager;", "getSSLSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "withInterceptors", "interceptors", "", "Lokhttp3/Interceptor;", "test-automation-feign"})
public final class OkHttpClientFactory {
    @NotNull
    private final FeignProperties feignProperties;

    public OkHttpClientFactory(@NotNull FeignProperties feignProperties) {
        Intrinsics.checkNotNullParameter((Object)feignProperties, (String)"feignProperties");
        this.feignProperties = feignProperties;
    }

    @NotNull
    public final OkHttpClient.Builder withInterceptors(@NotNull List<? extends Interceptor> interceptors) {
        Intrinsics.checkNotNullParameter(interceptors, (String)"interceptors");
        OkHttpClient.Builder builder = this.getPreBakedHttpClient();
        interceptors.forEach(arg_0 -> OkHttpClientFactory.withInterceptors$lambda$0(builder, arg_0));
        return builder;
    }

    private final OkHttpClient.Builder getPreBakedHttpClient() {
        X509TrustManager trustManager2 = this.getTrustManager();
        OkHttpClient.Builder builder = new OkHttpClient.Builder().sslSocketFactory(this.getSSLSocketFactory(trustManager2), trustManager2).hostnameVerifier(OkHttpClientFactory::_get_preBakedHttpClient_$lambda$1);
        Duration duration = Duration.ofSeconds(this.feignProperties.getReadTimeout());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(feignProperties.readTimeout)");
        OkHttpClient.Builder builder2 = builder.readTimeout(duration);
        Duration duration2 = Duration.ofSeconds(this.feignProperties.getConnectTimeout());
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(feignProperties.connectTimeout)");
        OkHttpClient.Builder builder3 = builder2.connectTimeout(duration2);
        Duration duration3 = Duration.ofSeconds(this.feignProperties.getWriteTimeout());
        Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofSeconds(feignProperties.writeTimeout)");
        OkHttpClient.Builder builder4 = builder3.writeTimeout(duration3);
        Duration duration4 = Duration.ofSeconds(this.feignProperties.getCallTimeout());
        Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"ofSeconds(feignProperties.callTimeout)");
        return builder4.callTimeout(duration4).retryOnConnectionFailure(this.feignProperties.getRetryOnConnectionFailure()).followRedirects(this.feignProperties.getFollowRedirects()).followSslRedirects(this.feignProperties.getFollowSslRedirects());
    }

    private final SSLSocketFactory getSSLSocketFactory(X509TrustManager trustManager2) {
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        TrustManager[] trustManagerArray = new TrustManager[]{trustManager2};
        sslContext.init(null, trustManagerArray, new SecureRandom());
        SSLSocketFactory sSLSocketFactory = sslContext.getSocketFactory();
        Intrinsics.checkNotNullExpressionValue((Object)sSLSocketFactory, (String)"sslContext.socketFactory");
        return sSLSocketFactory;
    }

    private final X509TrustManager getTrustManager() {
        return new X509TrustManager(){

            public void checkClientTrusted(@NotNull X509Certificate[] x509Certificates, @NotNull String s) {
                Intrinsics.checkNotNullParameter((Object)x509Certificates, (String)"x509Certificates");
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            }

            public void checkServerTrusted(@NotNull X509Certificate[] x509Certificates, @NotNull String s) {
                Intrinsics.checkNotNullParameter((Object)x509Certificates, (String)"x509Certificates");
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            }

            @NotNull
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
    }

    private static final void withInterceptors$lambda$0(OkHttpClient.Builder $builder, Interceptor interceptor) {
        Intrinsics.checkNotNullParameter((Object)$builder, (String)"$builder");
        Intrinsics.checkNotNullParameter((Object)interceptor, (String)"interceptor");
        $builder.addInterceptor(interceptor);
    }

    private static final boolean _get_preBakedHttpClient_$lambda$1(String string, SSLSession sSLSession) {
        return true;
    }
}

