/*
 * Decompiled with CFR 0.152.
 */
package com.nortal.test.feign.configuration;

import com.nortal.test.feign.DefaultTargeter;
import com.nortal.test.feign.OkHttpClientFactory;
import com.nortal.test.feign.configuration.FeignProperties;
import com.nortal.test.feign.interceptor.FeignClientInterceptor;
import feign.Client;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.openfeign.FeignClientFactory;
import org.springframework.cloud.openfeign.FeignClientProperties;
import org.springframework.cloud.openfeign.Targeter;
import org.springframework.cloud.openfeign.support.FeignEncoderProperties;
import org.springframework.cloud.openfeign.support.FeignHttpClientProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

@Configuration
@EnableConfigurationProperties(value={FeignProperties.class, FeignClientProperties.class, FeignHttpClientProperties.class, FeignEncoderProperties.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0017J\b\u0010\n\u001a\u00020\u000bH\u0017J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0017J\b\u0010\u000e\u001a\u00020\u000fH\u0017\u00a8\u0006\u0010"}, d2={"Lcom/nortal/test/feign/configuration/FeignConfiguration;", "", "()V", "feignClient", "Lfeign/Client;", "feignClientInterceptors", "", "Lcom/nortal/test/feign/interceptor/FeignClientInterceptor;", "feignProperties", "Lcom/nortal/test/feign/configuration/FeignProperties;", "feignContext", "Lorg/springframework/cloud/openfeign/FeignClientFactory;", "feignTargeter", "Lorg/springframework/cloud/openfeign/Targeter;", "httpMessageConverters", "Lorg/springframework/boot/autoconfigure/http/HttpMessageConverters;", "test-automation-feign"})
@SourceDebugExtension(value={"SMAP\nFeignConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeignConfiguration.kt\ncom/nortal/test/feign/configuration/FeignConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1045#2:88\n*S KotlinDebug\n*F\n+ 1 FeignConfiguration.kt\ncom/nortal/test/feign/configuration/FeignConfiguration\n*L\n74#1:88\n*E\n"})
public class FeignConfiguration {
    @Bean
    @NotNull
    public HttpMessageConverters httpMessageConverters() {
        HttpMessageConverter[] httpMessageConverterArray = new HttpMessageConverter[]{new MappingJackson2HttpMessageConverter()};
        return new HttpMessageConverters(httpMessageConverterArray);
    }

    @Bean
    @NotNull
    public FeignClientFactory feignContext() {
        return new FeignClientFactory();
    }

    @Bean
    @NotNull
    public Client feignClient(@NotNull List<? extends FeignClientInterceptor> feignClientInterceptors, @NotNull FeignProperties feignProperties) {
        Intrinsics.checkNotNullParameter(feignClientInterceptors, (String)"feignClientInterceptors");
        Intrinsics.checkNotNullParameter((Object)feignProperties, (String)"feignProperties");
        Iterable $this$sortedBy$iv = feignClientInterceptors;
        boolean $i$f$sortedBy = false;
        OkHttpClient client = new OkHttpClientFactory(feignProperties).withInterceptors(CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                FeignClientInterceptor it = (FeignClientInterceptor)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getOrder());
                it = (FeignClientInterceptor)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getOrder()));
            }
        })).build();
        return (Client)new feign.okhttp.OkHttpClient(client);
    }

    @Bean
    @ConditionalOnMissingBean
    @Nullable
    public Targeter feignTargeter() {
        return new DefaultTargeter();
    }
}

