/*
 * Decompiled with CFR 0.152.
 */
package com.nortal.test.feign.interceptor;

import com.nortal.test.core.report.RequestResponseReportFormatter;
import com.nortal.test.core.report.model.HttpHeaders;
import com.nortal.test.core.report.model.HttpRequest;
import com.nortal.test.core.report.model.HttpResponse;
import com.nortal.test.core.services.CucumberScopeMonitor;
import com.nortal.test.feign.interceptor.FeignClientInterceptor;
import com.nortal.test.feign.util.FeignUtils;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0012J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0012J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\nH\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/nortal/test/feign/interceptor/ReportInterceptor;", "Lcom/nortal/test/feign/interceptor/FeignClientInterceptor;", "formatter", "Lcom/nortal/test/core/report/RequestResponseReportFormatter;", "cucumberScopeMonitor", "Lcom/nortal/test/core/services/CucumberScopeMonitor;", "(Lcom/nortal/test/core/report/RequestResponseReportFormatter;Lcom/nortal/test/core/services/CucumberScopeMonitor;)V", "getOrder", "", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "resolveBody", "", "response", "resolveRequest", "Lcom/nortal/test/core/report/model/HttpRequest;", "request", "Lokhttp3/Request;", "resolveResponse", "Lcom/nortal/test/core/report/model/HttpResponse;", "test-automation-feign"})
public class ReportInterceptor
implements FeignClientInterceptor {
    @NotNull
    private final RequestResponseReportFormatter formatter;
    @NotNull
    private final CucumberScopeMonitor cucumberScopeMonitor;

    public ReportInterceptor(@NotNull RequestResponseReportFormatter formatter, @NotNull CucumberScopeMonitor cucumberScopeMonitor) {
        Intrinsics.checkNotNullParameter((Object)formatter, (String)"formatter");
        Intrinsics.checkNotNullParameter((Object)cucumberScopeMonitor, (String)"cucumberScopeMonitor");
        this.formatter = formatter;
        this.cucumberScopeMonitor = cucumberScopeMonitor;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        if (!this.cucumberScopeMonitor.isCalledWithinScope()) {
            return chain.proceed(chain.request());
        }
        try {
            Response response = chain.proceed(chain.request());
            this.formatter.formatAndAddToReport(this.resolveRequest(response.request()), this.resolveResponse(response));
        }
        catch (Exception e) {
            this.formatter.formatAndAddToReport(this.resolveRequest(chain.request()));
            throw e;
        }
        return var2_2;
    }

    public int getOrder() {
        return 100;
    }

    private HttpRequest resolveRequest(Request request) {
        Map headers = MapsKt.toMutableMap((Map)request.headers().toMultimap());
        if (request.body() != null) {
            RequestBody requestBody = request.body();
            Intrinsics.checkNotNull((Object)requestBody);
            MediaType mediaType = requestBody.contentType();
            if (mediaType != null) {
                headers.put("Content-Type", CollectionsKt.listOf((Object)mediaType.toString()));
            }
        }
        String string = request.method().toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        return new HttpRequest(string, request.url().toString(), HttpHeaders.Companion.fromMap(headers), FeignUtils.INSTANCE.convertRequestBodyToString(request));
    }

    private HttpResponse resolveResponse(Response response) {
        return new HttpResponse(response.code(), HttpHeaders.Companion.fromMap(response.headers().toMultimap()), this.resolveBody(response));
    }

    private String resolveBody(Response response) {
        ResponseBody body = response.peekBody(Long.MAX_VALUE);
        return body.string();
    }
}

