/*
 * Decompiled with CFR 0.152.
 */
package com.nortal.test.feign.util;

import java.io.Closeable;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/nortal/test/feign/util/FeignUtils;", "", "()V", "log", "Lorg/slf4j/Logger;", "convertRequestBodyToString", "", "request", "Lokhttp3/Request;", "test-automation-feign"})
public final class FeignUtils {
    @NotNull
    public static final FeignUtils INSTANCE = new FeignUtils();
    @NotNull
    private static final Logger log;

    private FeignUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String convertRequestBodyToString(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (request.body() == null) {
            return null;
        }
        try {
            Closeable closeable = (Closeable)new Buffer();
            Throwable throwable = null;
            try {
                Buffer buffer = (Buffer)closeable;
                boolean bl = false;
                Request copy = request.newBuilder().build();
                if (copy.body() != null) {
                    RequestBody requestBody = copy.body();
                    Intrinsics.checkNotNull((Object)requestBody);
                    requestBody.writeTo((BufferedSink)buffer);
                }
                String string = buffer.readUtf8();
                return string;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            log.error("Failed to read body", (Throwable)e);
            return null;
        }
    }

    static {
        Logger logger = LoggerFactory.getLogger(INSTANCE.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(javaClass)");
        log = logger;
    }
}

