/*
 * Decompiled with CFR 0.152.
 */
package com.nortal.test.selenide.configuration;

import com.codeborne.selenide.logevents.LogEventListener;
import com.codeborne.selenide.logevents.SelenideLogger;
import com.nortal.test.selenide.configuration.SelenideProperties;
import io.qameta.allure.selenide.AllureSelenide;
import jakarta.annotation.PostConstruct;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SelenideProperties.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0017R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/nortal/test/selenide/configuration/SelenideConfiguration;", "", "selenideProperties", "Lcom/nortal/test/selenide/configuration/SelenideProperties;", "(Lcom/nortal/test/selenide/configuration/SelenideProperties;)V", "log", "Lorg/slf4j/Logger;", "initSelenide", "", "test-automation-selenide"})
public class SelenideConfiguration {
    @NotNull
    private final SelenideProperties selenideProperties;
    @NotNull
    private final Logger log;

    public SelenideConfiguration(@NotNull SelenideProperties selenideProperties) {
        Intrinsics.checkNotNullParameter((Object)selenideProperties, (String)"selenideProperties");
        this.selenideProperties = selenideProperties;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(javaClass)");
        this.log = logger;
    }

    @PostConstruct
    public void initSelenide() {
        System.setProperty("chromeoptions.args", this.selenideProperties.getChromeOptionsArgs());
        this.log.info("Setting up Selenide with config: {}", (Object)this.selenideProperties);
        com.codeborne.selenide.Configuration.baseUrl = this.selenideProperties.getBaseUrl();
        com.codeborne.selenide.Configuration.timeout = this.selenideProperties.getTimeout();
        com.codeborne.selenide.Configuration.pollingInterval = this.selenideProperties.getPollingInterval();
        com.codeborne.selenide.Configuration.holdBrowserOpen = this.selenideProperties.getHoldBrowserOpen();
        com.codeborne.selenide.Configuration.reopenBrowserOnFail = this.selenideProperties.getReopenBrowserOnFail();
        com.codeborne.selenide.Configuration.browser = this.selenideProperties.getBrowser().name();
        com.codeborne.selenide.Configuration.browserVersion = this.selenideProperties.getBrowserVersion();
        com.codeborne.selenide.Configuration.remote = this.selenideProperties.getRemote();
        com.codeborne.selenide.Configuration.browserSize = this.selenideProperties.getBrowserSize();
        com.codeborne.selenide.Configuration.browserPosition = this.selenideProperties.getBrowserPosition();
        com.codeborne.selenide.Configuration.pageLoadStrategy = this.selenideProperties.getPageLoadStrategy();
        com.codeborne.selenide.Configuration.pageLoadTimeout = this.selenideProperties.getPageLoadTimeout();
        com.codeborne.selenide.Configuration.clickViaJs = this.selenideProperties.getClickViaJs();
        com.codeborne.selenide.Configuration.screenshots = this.selenideProperties.getScreenshots();
        com.codeborne.selenide.Configuration.savePageSource = this.selenideProperties.getSavePageSource();
        com.codeborne.selenide.Configuration.reportsFolder = this.selenideProperties.getReportsFolder();
        com.codeborne.selenide.Configuration.downloadsFolder = this.selenideProperties.getDownloadsFolder();
        com.codeborne.selenide.Configuration.fastSetValue = this.selenideProperties.getFastSetValue();
        com.codeborne.selenide.Configuration.selectorMode = this.selenideProperties.getSelectorMode();
        com.codeborne.selenide.Configuration.assertionMode = this.selenideProperties.getAssertionMode();
        com.codeborne.selenide.Configuration.fileDownload = this.selenideProperties.getFileDownload();
        com.codeborne.selenide.Configuration.proxyEnabled = this.selenideProperties.getProxyEnabled();
        com.codeborne.selenide.Configuration.proxyHost = this.selenideProperties.getProxyHost();
        com.codeborne.selenide.Configuration.proxyPort = this.selenideProperties.getProxyPort();
        com.codeborne.selenide.Configuration.webdriverLogsEnabled = this.selenideProperties.getWebdriverLogsEnabled();
        com.codeborne.selenide.Configuration.headless = this.selenideProperties.getHeadless();
        com.codeborne.selenide.Configuration.browserBinary = this.selenideProperties.getBrowserBinary();
        SelenideLogger.addListener((String)"AllureSelenide", (LogEventListener)((LogEventListener)new AllureSelenide().screenshots(true).savePageSource(true)));
    }
}

