/*
 * Decompiled with CFR 0.152.
 */
package com.nortal.test.selenide.hook;

import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.WebDriverRunner;
import com.nortal.test.core.services.CucumberScenarioProvider;
import com.nortal.test.core.services.hooks.AfterScenarioHook;
import com.nortal.test.selenide.configuration.SelenideCleanupMode;
import com.nortal.test.selenide.configuration.SelenideProperties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/nortal/test/selenide/hook/SelenideCleanupHook;", "Lcom/nortal/test/core/services/hooks/AfterScenarioHook;", "selenideProperties", "Lcom/nortal/test/selenide/configuration/SelenideProperties;", "(Lcom/nortal/test/selenide/configuration/SelenideProperties;)V", "log", "Lorg/slf4j/Logger;", "getSelenideProperties", "()Lcom/nortal/test/selenide/configuration/SelenideProperties;", "after", "", "scenario", "Lcom/nortal/test/core/services/CucumberScenarioProvider;", "test-automation-selenide"})
public class SelenideCleanupHook
implements AfterScenarioHook {
    @NotNull
    private final SelenideProperties selenideProperties;
    @NotNull
    private final Logger log;

    public SelenideCleanupHook(@NotNull SelenideProperties selenideProperties) {
        Intrinsics.checkNotNullParameter((Object)selenideProperties, (String)"selenideProperties");
        this.selenideProperties = selenideProperties;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(javaClass)");
        this.log = logger;
    }

    @NotNull
    public SelenideProperties getSelenideProperties() {
        return this.selenideProperties;
    }

    public void after(@Nullable CucumberScenarioProvider scenario) {
        if (!WebDriverRunner.hasWebDriverStarted()) {
            this.log.trace("Selenide is not started yet, skipping..");
            return;
        }
        if (this.getSelenideProperties().getScenarioCleanupMode() == SelenideCleanupMode.CLEAR_BROWSER_DATA) {
            this.log.trace("Clearing Selenide browser cookies and storage..");
            Selenide.clearBrowserCookies();
            Selenide.clearBrowserLocalStorage();
        } else {
            this.log.trace("Closing Selenide controller WebDriver..");
            Selenide.closeWebDriver();
        }
    }
}

