/*
 * Decompiled with CFR 0.152.
 */
package com.nortal.test.selenide.hook;

import com.codeborne.selenide.Configuration;
import com.nortal.test.core.services.hooks.BeforeSuiteHook;
import com.nortal.test.core.util.SeleniumRemoteProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/nortal/test/selenide/hook/SelenideRemoteChromePrepHook;", "Lcom/nortal/test/core/services/hooks/BeforeSuiteHook;", "seleniumRemoteProvider", "Lorg/springframework/beans/factory/ObjectProvider;", "Lcom/nortal/test/core/util/SeleniumRemoteProvider;", "(Lorg/springframework/beans/factory/ObjectProvider;)V", "log", "Lorg/slf4j/Logger;", "beforeSuite", "", "test-automation-selenide"})
public class SelenideRemoteChromePrepHook
implements BeforeSuiteHook {
    @NotNull
    private final ObjectProvider<SeleniumRemoteProvider> seleniumRemoteProvider;
    @NotNull
    private final Logger log;

    public SelenideRemoteChromePrepHook(@NotNull ObjectProvider<SeleniumRemoteProvider> seleniumRemoteProvider) {
        Intrinsics.checkNotNullParameter(seleniumRemoteProvider, (String)"seleniumRemoteProvider");
        this.seleniumRemoteProvider = seleniumRemoteProvider;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(javaClass)");
        this.log = logger;
    }

    public void beforeSuite() {
        this.seleniumRemoteProvider.ifAvailable(arg_0 -> SelenideRemoteChromePrepHook.beforeSuite$lambda$0(this, arg_0));
    }

    private static final void beforeSuite$lambda$0(SelenideRemoteChromePrepHook this$0, SeleniumRemoteProvider it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.log.info("Selenium remote provider is available. Configuring selenide to use {} as a remote.", (Object)it.getRemoteUrl());
        Configuration.remote = it.getRemoteUrl();
    }
}

