/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.cache.disc.impl;

import com.nostra13.universalimageloader.cache.disc.BaseDiscCache;
import com.nostra13.universalimageloader.cache.disc.naming.FileNameGenerator;
import com.nostra13.universalimageloader.core.DefaultConfigurationFactory;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class LimitedAgeDiscCache
extends BaseDiscCache {
    private final long maxFileAge;
    private final Map<File, Long> loadingDates = Collections.synchronizedMap(new HashMap());

    public LimitedAgeDiscCache(File cacheDir, long maxAge) {
        this(cacheDir, DefaultConfigurationFactory.createFileNameGenerator(), maxAge);
    }

    public LimitedAgeDiscCache(File cacheDir, FileNameGenerator fileNameGenerator, long maxAge) {
        super(cacheDir, fileNameGenerator);
        this.maxFileAge = maxAge * 1000L;
        this.readLoadingDates();
    }

    private void readLoadingDates() {
        File[] cachedFiles;
        for (File cachedFile : cachedFiles = this.getCacheDir().listFiles()) {
            this.loadingDates.put(cachedFile, cachedFile.lastModified());
        }
    }

    @Override
    public void put(String key, File file) {
        long currentTime = System.currentTimeMillis();
        file.setLastModified(currentTime);
        this.loadingDates.put(file, currentTime);
    }

    @Override
    public File get(String key) {
        File file = super.get(key);
        if (file.exists()) {
            Long loadingDate = this.loadingDates.get(file);
            if (loadingDate == null) {
                loadingDate = file.lastModified();
            }
            if (System.currentTimeMillis() - loadingDate > this.maxFileAge) {
                file.delete();
                this.loadingDates.remove(file);
            }
        }
        return file;
    }
}

