/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core;

import android.graphics.Bitmap;
import android.widget.ImageView;
import com.nostra13.universalimageloader.core.ImageLoader;
import com.nostra13.universalimageloader.core.ImageLoadingInfo;
import com.nostra13.universalimageloader.core.assist.ImageLoadingListener;
import com.nostra13.universalimageloader.core.display.BitmapDisplayer;
import com.nostra13.universalimageloader.utils.L;

final class DisplayBitmapTask
implements Runnable {
    private static final String LOG_DISPLAY_IMAGE_IN_IMAGEVIEW = "Display image in ImageView [%s]";
    private static final String LOG_TASK_CANCELLED = "ImageView is reused for another image. Task is cancelled. [%s]";
    private final Bitmap bitmap;
    private final ImageView imageView;
    private final String memoryCacheKey;
    private final BitmapDisplayer bitmapDisplayer;
    private final ImageLoadingListener listener;
    private boolean loggingEnabled;

    public DisplayBitmapTask(Bitmap bitmap, ImageLoadingInfo imageLoadingInfo) {
        this.bitmap = bitmap;
        this.imageView = imageLoadingInfo.imageView;
        this.memoryCacheKey = imageLoadingInfo.memoryCacheKey;
        this.bitmapDisplayer = imageLoadingInfo.options.getDisplayer();
        this.listener = imageLoadingInfo.listener;
    }

    @Override
    public void run() {
        if (this.isViewWasReused()) {
            if (this.loggingEnabled) {
                L.i(LOG_TASK_CANCELLED, this.memoryCacheKey);
            }
            this.listener.onLoadingCancelled();
        } else {
            if (this.loggingEnabled) {
                L.i(LOG_DISPLAY_IMAGE_IN_IMAGEVIEW, this.memoryCacheKey);
            }
            Bitmap displayedBitmap = this.bitmapDisplayer.display(this.bitmap, this.imageView);
            this.listener.onLoadingComplete(displayedBitmap);
            ImageLoader.getInstance().cancelDisplayTask(this.imageView);
        }
    }

    private boolean isViewWasReused() {
        String currentCacheKey = ImageLoader.getInstance().getLoadingUriForView(this.imageView);
        return !this.memoryCacheKey.equals(currentCacheKey);
    }

    void setLoggingEnabled(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
    }
}

