/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.SystemClock;
import android.widget.ImageView;
import com.nostra13.universalimageloader.cache.disc.DiscCacheAware;
import com.nostra13.universalimageloader.core.DisplayBitmapTask;
import com.nostra13.universalimageloader.core.DisplayImageOptions;
import com.nostra13.universalimageloader.core.ImageDecoder;
import com.nostra13.universalimageloader.core.ImageLoader;
import com.nostra13.universalimageloader.core.ImageLoaderConfiguration;
import com.nostra13.universalimageloader.core.ImageLoadingInfo;
import com.nostra13.universalimageloader.core.assist.FailReason;
import com.nostra13.universalimageloader.core.assist.ImageLoadingListener;
import com.nostra13.universalimageloader.core.assist.ImageScaleType;
import com.nostra13.universalimageloader.core.assist.ImageSize;
import com.nostra13.universalimageloader.core.assist.ViewScaleType;
import com.nostra13.universalimageloader.core.download.ImageDownloader;
import com.nostra13.universalimageloader.utils.FileUtils;
import com.nostra13.universalimageloader.utils.L;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

final class LoadAndDisplayImageTask
implements Runnable {
    private static final String LOG_WAITING_FOR_RESUME = "ImageLoader is paused. Waiting...  [%s]";
    private static final String LOG_RESUME_AFTER_PAUSE = ".. Resume loading [%s]";
    private static final String LOG_DELAY_BEFORE_LOADING = "Delay %d ms before loading...  [%s]";
    private static final String LOG_START_DISPLAY_IMAGE_TASK = "Start display image task [%s]";
    private static final String LOG_WAITING_FOR_IMAGE_LOADED = "Image already is loading. Waiting... [%s]";
    private static final String LOG_GET_IMAGE_FROM_MEMORY_CACHE_AFTER_WAITING = "...Get cached bitmap from memory after waiting. [%s]";
    private static final String LOG_LOAD_IMAGE_FROM_INTERNET = "Load image from Internet [%s]";
    private static final String LOG_LOAD_IMAGE_FROM_DISC_CACHE = "Load image from disc cache [%s]";
    private static final String LOG_CACHE_IMAGE_IN_MEMORY = "Cache image in memory [%s]";
    private static final String LOG_CACHE_IMAGE_ON_DISC = "Cache image on disc [%s]";
    private static final String LOG_TASK_CANCELLED = "ImageView is reused for another image. Task is cancelled. [%s]";
    private static final String LOG_TASK_INTERRUPTED = "Task was interrupted [%s]";
    private static final int ATTEMPT_COUNT_TO_DECODE_BITMAP = 3;
    private static final int BUFFER_SIZE = 8192;
    private final ImageLoaderConfiguration configuration;
    private final ImageLoadingInfo imageLoadingInfo;
    private final Handler handler;
    private final ImageDownloader downloader;
    private final boolean loggingEnabled;
    private final String uri;
    private final String memoryCacheKey;
    private final ImageView imageView;
    private final ImageSize targetSize;
    private final DisplayImageOptions options;
    private final ImageLoadingListener listener;

    public LoadAndDisplayImageTask(ImageLoaderConfiguration configuration, ImageLoadingInfo imageLoadingInfo, Handler handler) {
        this.configuration = configuration;
        this.imageLoadingInfo = imageLoadingInfo;
        this.handler = handler;
        this.downloader = configuration.downloader;
        this.loggingEnabled = configuration.loggingEnabled;
        this.uri = imageLoadingInfo.uri;
        this.memoryCacheKey = imageLoadingInfo.memoryCacheKey;
        this.imageView = imageLoadingInfo.imageView;
        this.targetSize = imageLoadingInfo.targetSize;
        this.options = imageLoadingInfo.options;
        this.listener = imageLoadingInfo.listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Bitmap bmp;
        AtomicBoolean pause = ImageLoader.getInstance().getPause();
        if (pause.get()) {
            AtomicBoolean atomicBoolean = pause;
            synchronized (atomicBoolean) {
                if (this.loggingEnabled) {
                    L.i(LOG_WAITING_FOR_RESUME, this.memoryCacheKey);
                }
                try {
                    pause.wait();
                }
                catch (InterruptedException e) {
                    L.e(LOG_TASK_INTERRUPTED, this.memoryCacheKey);
                    return;
                }
                if (this.loggingEnabled) {
                    L.i(LOG_RESUME_AFTER_PAUSE, this.memoryCacheKey);
                }
            }
        }
        if (this.checkTaskIsNotActual()) {
            return;
        }
        if (this.options.isDelayBeforeLoading()) {
            if (this.loggingEnabled) {
                L.i(LOG_DELAY_BEFORE_LOADING, this.options.getDelayBeforeLoading(), this.memoryCacheKey);
            }
            try {
                Thread.sleep(this.options.getDelayBeforeLoading());
            }
            catch (InterruptedException e) {
                L.e(LOG_TASK_INTERRUPTED, this.memoryCacheKey);
                return;
            }
            if (this.checkTaskIsNotActual()) {
                return;
            }
        }
        ReentrantLock loadFromUriLock = this.imageLoadingInfo.loadFromUriLock;
        if (this.loggingEnabled) {
            L.i(LOG_START_DISPLAY_IMAGE_TASK, this.memoryCacheKey);
            if (loadFromUriLock.isLocked()) {
                L.i(LOG_WAITING_FOR_IMAGE_LOADED, this.memoryCacheKey);
            }
        }
        loadFromUriLock.lock();
        try {
            if (this.checkTaskIsNotActual()) {
                return;
            }
            bmp = ImageLoader.getInstance().getMemoryCache().get(this.memoryCacheKey);
            if (bmp == null) {
                bmp = this.tryLoadBitmap();
                if (bmp == null) {
                    return;
                }
                if (this.checkTaskIsNotActual() || this.checkTaskIsInterrupted()) {
                    return;
                }
                if (this.options.isCacheInMemory()) {
                    if (this.loggingEnabled) {
                        L.i(LOG_CACHE_IMAGE_IN_MEMORY, this.memoryCacheKey);
                    }
                    this.configuration.memoryCache.put(this.memoryCacheKey, bmp);
                }
            } else if (this.loggingEnabled) {
                L.i(LOG_GET_IMAGE_FROM_MEMORY_CACHE_AFTER_WAITING, this.memoryCacheKey);
            }
        }
        finally {
            loadFromUriLock.unlock();
        }
        if (this.checkTaskIsNotActual() || this.checkTaskIsInterrupted()) {
            return;
        }
        DisplayBitmapTask displayBitmapTask = new DisplayBitmapTask(bmp, this.imageLoadingInfo);
        displayBitmapTask.setLoggingEnabled(this.loggingEnabled);
        this.handler.post((Runnable)displayBitmapTask);
    }

    private boolean checkTaskIsNotActual() {
        boolean imageViewWasReused;
        String currentCacheKey = ImageLoader.getInstance().getLoadingUriForView(this.imageView);
        boolean bl = imageViewWasReused = !this.memoryCacheKey.equals(currentCacheKey);
        if (imageViewWasReused) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    LoadAndDisplayImageTask.this.listener.onLoadingCancelled();
                }
            });
        }
        if (this.loggingEnabled && imageViewWasReused) {
            L.i(LOG_TASK_CANCELLED, this.memoryCacheKey);
        }
        return imageViewWasReused;
    }

    private boolean checkTaskIsInterrupted() {
        boolean interrupted = Thread.interrupted();
        if (this.loggingEnabled && interrupted) {
            L.e(LOG_TASK_INTERRUPTED, this.memoryCacheKey);
        }
        return interrupted;
    }

    private Bitmap tryLoadBitmap() {
        DiscCacheAware discCache = this.configuration.discCache;
        File imageFile = discCache.get(this.uri);
        Bitmap bitmap = null;
        try {
            URI imageUriForDecoding;
            if (imageFile.exists()) {
                Bitmap b;
                if (this.loggingEnabled) {
                    L.i(LOG_LOAD_IMAGE_FROM_DISC_CACHE, this.memoryCacheKey);
                }
                if ((b = this.decodeImage(imageFile.toURI())) != null) {
                    return b;
                }
            }
            if (this.loggingEnabled) {
                L.i(LOG_LOAD_IMAGE_FROM_INTERNET, this.memoryCacheKey);
            }
            if (this.options.isCacheOnDisc()) {
                if (this.loggingEnabled) {
                    L.i(LOG_CACHE_IMAGE_ON_DISC, this.memoryCacheKey);
                }
                this.saveImageOnDisc(imageFile);
                discCache.put(this.uri, imageFile);
                imageUriForDecoding = imageFile.toURI();
            } else {
                imageUriForDecoding = new URI(this.uri);
            }
            bitmap = this.decodeImage(imageUriForDecoding);
            if (bitmap == null) {
                this.fireImageLoadingFailedEvent(FailReason.IO_ERROR);
            }
        }
        catch (IOException e) {
            L.e(e);
            this.fireImageLoadingFailedEvent(FailReason.IO_ERROR);
            if (imageFile.exists()) {
                imageFile.delete();
            }
        }
        catch (OutOfMemoryError e) {
            L.e(e);
            this.fireImageLoadingFailedEvent(FailReason.OUT_OF_MEMORY);
        }
        catch (Throwable e) {
            L.e(e);
            this.fireImageLoadingFailedEvent(FailReason.UNKNOWN);
        }
        return bitmap;
    }

    private Bitmap decodeImage(URI imageUri) throws IOException {
        Bitmap bmp = null;
        if (this.configuration.handleOutOfMemory) {
            bmp = this.decodeWithOOMHandling(imageUri);
        } else {
            ImageDecoder decoder = new ImageDecoder(imageUri, this.downloader, this.options);
            decoder.setLoggingEnabled(this.loggingEnabled);
            ViewScaleType viewScaleType = ViewScaleType.fromImageView(this.imageView);
            bmp = decoder.decode(this.targetSize, this.options.getImageScaleType(), viewScaleType);
        }
        return bmp;
    }

    private Bitmap decodeWithOOMHandling(URI imageUri) throws IOException {
        Bitmap result = null;
        ImageDecoder decoder = new ImageDecoder(imageUri, this.downloader, this.options);
        decoder.setLoggingEnabled(this.loggingEnabled);
        for (int attempt = 1; attempt <= 3; ++attempt) {
            try {
                ViewScaleType viewScaleType = ViewScaleType.fromImageView(this.imageView);
                result = decoder.decode(this.targetSize, this.options.getImageScaleType(), viewScaleType);
                break;
            }
            catch (OutOfMemoryError e) {
                L.e(e);
                switch (attempt) {
                    case 1: {
                        System.gc();
                        break;
                    }
                    case 2: {
                        this.configuration.memoryCache.clear();
                        System.gc();
                        break;
                    }
                    case 3: {
                        throw e;
                    }
                }
                SystemClock.sleep((long)(attempt * 1000));
                continue;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveImageOnDisc(File targetFile) throws IOException, URISyntaxException {
        int width = this.configuration.maxImageWidthForDiscCache;
        int height = this.configuration.maxImageHeightForDiscCache;
        if (width > 0 || height > 0) {
            ImageSize targetImageSize = new ImageSize(width, height);
            ImageDecoder decoder = new ImageDecoder(new URI(this.uri), this.downloader, this.options);
            decoder.setLoggingEnabled(this.loggingEnabled);
            Bitmap bmp = decoder.decode(targetImageSize, ImageScaleType.IN_SAMPLE_INT, ViewScaleType.FIT_INSIDE);
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(targetFile), 8192);
            boolean compressedSuccessfully = bmp.compress(this.configuration.imageCompressFormatForDiscCache, this.configuration.imageQualityForDiscCache, (OutputStream)os);
            if (compressedSuccessfully) {
                bmp.recycle();
                return;
            }
        }
        InputStream is = this.downloader.getStream(new URI(this.uri));
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(targetFile), 8192);
            try {
                FileUtils.copyStream(is, os);
            }
            finally {
                ((OutputStream)os).close();
            }
        }
        finally {
            is.close();
        }
    }

    private void fireImageLoadingFailedEvent(final FailReason failReason) {
        if (!Thread.interrupted()) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    LoadAndDisplayImageTask.this.listener.onLoadingFailed(failReason);
                }
            });
        }
    }
}

