/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core.download;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;

public abstract class ImageDownloader {
    protected static final String PROTOCOL_FILE = "file";
    protected static final String PROTOCOL_HTTP = "http";
    protected static final String PROTOCOL_HTTPS = "https";
    protected static final String PROTOCOL_FTP = "ftp";
    protected static final int BUFFER_SIZE = 8192;

    public InputStream getStream(URI imageUri) throws IOException {
        String scheme = imageUri.getScheme();
        if (PROTOCOL_HTTP.equals(scheme) || PROTOCOL_HTTPS.equals(scheme) || PROTOCOL_FTP.equals(scheme)) {
            return this.getStreamFromNetwork(imageUri);
        }
        if (PROTOCOL_FILE.equals(scheme)) {
            return this.getStreamFromFile(imageUri);
        }
        return this.getStreamFromOtherSource(imageUri);
    }

    protected InputStream getStreamFromOtherSource(URI imageUri) throws IOException {
        return null;
    }

    protected abstract InputStream getStreamFromNetwork(URI var1) throws IOException;

    protected InputStream getStreamFromFile(URI imageUri) throws IOException {
        return new BufferedInputStream(imageUri.toURL().openStream(), 8192);
    }
}

