/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.utils;

import android.content.Context;
import android.os.Environment;
import com.nostra13.universalimageloader.utils.L;
import java.io.File;
import java.io.IOException;

public final class StorageUtils {
    private static final String INDIVIDUAL_DIR_NAME = "uil-images";

    private StorageUtils() {
    }

    public static File getCacheDirectory(Context context) {
        File appCacheDir = null;
        if (Environment.getExternalStorageState().equals("mounted")) {
            appCacheDir = StorageUtils.getExternalCacheDir(context);
        }
        if (appCacheDir == null) {
            appCacheDir = context.getCacheDir();
        }
        return appCacheDir;
    }

    public static File getIndividualCacheDirectory(Context context) {
        File cacheDir = StorageUtils.getCacheDirectory(context);
        File individualCacheDir = new File(cacheDir, INDIVIDUAL_DIR_NAME);
        if (!individualCacheDir.exists() && !individualCacheDir.mkdir()) {
            individualCacheDir = cacheDir;
        }
        return individualCacheDir;
    }

    public static File getOwnCacheDirectory(Context context, String cacheDir) {
        File appCacheDir = null;
        if (Environment.getExternalStorageState().equals("mounted")) {
            appCacheDir = new File(Environment.getExternalStorageDirectory(), cacheDir);
        }
        if (appCacheDir == null || !appCacheDir.exists() && !appCacheDir.mkdirs()) {
            appCacheDir = context.getCacheDir();
        }
        return appCacheDir;
    }

    private static File getExternalCacheDir(Context context) {
        File dataDir = new File(new File(Environment.getExternalStorageDirectory(), "Android"), "data");
        File appCacheDir = new File(new File(dataDir, context.getPackageName()), "cache");
        if (!appCacheDir.exists()) {
            try {
                new File(dataDir, ".nomedia").createNewFile();
            }
            catch (IOException e) {
                L.e(e, "Can't create \".nomedia\" file in application external cache directory", new Object[0]);
            }
            if (!appCacheDir.mkdirs()) {
                L.w("Unable to create external cache directory", new Object[0]);
                return null;
            }
        }
        return appCacheDir;
    }
}

