/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.nostra13.universalimageloader.cache.disc.DiscCacheAware;
import com.nostra13.universalimageloader.cache.memory.MemoryCacheAware;
import com.nostra13.universalimageloader.core.DisplayImageOptions;
import com.nostra13.universalimageloader.core.ImageLoaderConfiguration;
import com.nostra13.universalimageloader.core.ImageLoadingInfo;
import com.nostra13.universalimageloader.core.LoadAndDisplayImageTask;
import com.nostra13.universalimageloader.core.assist.ImageLoadingListener;
import com.nostra13.universalimageloader.core.assist.ImageSize;
import com.nostra13.universalimageloader.core.assist.MemoryCacheUtil;
import com.nostra13.universalimageloader.core.assist.QueueProcessingType;
import com.nostra13.universalimageloader.core.assist.SimpleImageLoadingListener;
import com.nostra13.universalimageloader.core.assist.deque.LIFOLinkedBlockingDeque;
import com.nostra13.universalimageloader.core.display.BitmapDisplayer;
import com.nostra13.universalimageloader.core.display.FakeBitmapDisplayer;
import com.nostra13.universalimageloader.utils.L;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

public class ImageLoader {
    public static final String TAG = ImageLoader.class.getSimpleName();
    private static final String ERROR_WRONG_ARGUMENTS = "Wrong arguments were passed to displayImage() method (ImageView reference are required)";
    private static final String ERROR_NOT_INIT = "ImageLoader must be init with configuration before using";
    private static final String ERROR_INIT_CONFIG_WITH_NULL = "ImageLoader configuration can not be initialized with null";
    private static final String LOG_LOAD_IMAGE_FROM_MEMORY_CACHE = "Load image from memory cache [%s]";
    private ImageLoaderConfiguration configuration;
    private ExecutorService imageLoadingExecutor;
    private ExecutorService cachedImageLoadingExecutor;
    private ExecutorService taskDistributor;
    private final ImageLoadingListener emptyListener = new SimpleImageLoadingListener();
    private final BitmapDisplayer fakeBitmapDisplayer = new FakeBitmapDisplayer();
    private final Map<Integer, String> cacheKeysForImageViews = Collections.synchronizedMap(new HashMap());
    private final Map<String, ReentrantLock> uriLocks = new WeakHashMap<String, ReentrantLock>();
    private final AtomicBoolean paused = new AtomicBoolean(false);
    private static volatile ImageLoader instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImageLoader getInstance() {
        if (instance != null) return instance;
        Class<ImageLoader> clazz = ImageLoader.class;
        synchronized (ImageLoader.class) {
            if (instance != null) return instance;
            instance = new ImageLoader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected ImageLoader() {
    }

    public synchronized void init(ImageLoaderConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(ERROR_INIT_CONFIG_WITH_NULL);
        }
        if (this.configuration == null) {
            this.configuration = configuration;
        }
    }

    public boolean isInited() {
        return this.configuration != null;
    }

    public void displayImage(String uri, ImageView imageView) {
        this.displayImage(uri, imageView, null, null);
    }

    public void displayImage(String uri, ImageView imageView, DisplayImageOptions options) {
        this.displayImage(uri, imageView, options, null);
    }

    public void displayImage(String uri, ImageView imageView, ImageLoadingListener listener) {
        this.displayImage(uri, imageView, null, listener);
    }

    public void displayImage(final String uri, ImageView imageView, DisplayImageOptions options, ImageLoadingListener listener) {
        this.checkConfiguration();
        if (imageView == null) {
            throw new IllegalArgumentException(ERROR_WRONG_ARGUMENTS);
        }
        if (listener == null) {
            listener = this.emptyListener;
        }
        if (options == null) {
            options = this.configuration.defaultDisplayImageOptions;
        }
        if (uri == null || uri.length() == 0) {
            this.cacheKeysForImageViews.remove(imageView.hashCode());
            listener.onLoadingStarted();
            if (options.isShowImageForEmptyUri()) {
                imageView.setImageResource(options.getImageForEmptyUri().intValue());
            } else {
                imageView.setImageBitmap(null);
            }
            listener.onLoadingComplete(null);
            return;
        }
        ImageSize targetSize = this.getImageSizeScaleTo(imageView);
        String memoryCacheKey = MemoryCacheUtil.generateKey(uri, targetSize);
        this.cacheKeysForImageViews.put(imageView.hashCode(), memoryCacheKey);
        Bitmap bmp = this.configuration.memoryCache.get(memoryCacheKey);
        if (bmp != null && !bmp.isRecycled()) {
            if (this.configuration.loggingEnabled) {
                L.i(LOG_LOAD_IMAGE_FROM_MEMORY_CACHE, memoryCacheKey);
            }
            listener.onLoadingStarted();
            options.getDisplayer().display(bmp, imageView);
            listener.onLoadingComplete(bmp);
        } else {
            listener.onLoadingStarted();
            if (options.isShowStubImage()) {
                imageView.setImageResource(options.getStubImage().intValue());
            } else if (options.isResetViewBeforeLoading()) {
                imageView.setImageBitmap(null);
            }
            this.initExecutorsIfNeed();
            ImageLoadingInfo imageLoadingInfo = new ImageLoadingInfo(uri, imageView, targetSize, options, listener, this.getLockForUri(uri));
            final LoadAndDisplayImageTask displayImageTask = new LoadAndDisplayImageTask(this.configuration, imageLoadingInfo, new Handler());
            this.taskDistributor.submit(new Runnable(){

                @Override
                public void run() {
                    boolean isImageCachedOnDisc = ((ImageLoader)ImageLoader.this).configuration.discCache.get(uri).exists();
                    if (isImageCachedOnDisc) {
                        ImageLoader.this.cachedImageLoadingExecutor.submit(displayImageTask);
                    } else {
                        ImageLoader.this.imageLoadingExecutor.submit(displayImageTask);
                    }
                }
            });
        }
    }

    public void loadImage(Context context, String uri, ImageLoadingListener listener) {
        this.loadImage(context, uri, null, null, listener);
    }

    public void loadImage(Context context, String uri, ImageSize minImageSize, ImageLoadingListener listener) {
        this.loadImage(context, uri, minImageSize, null, listener);
    }

    public void loadImage(Context context, String uri, DisplayImageOptions options, ImageLoadingListener listener) {
        this.loadImage(context, uri, null, options, listener);
    }

    public void loadImage(Context context, String uri, ImageSize minImageSize, DisplayImageOptions options, ImageLoadingListener listener) {
        this.checkConfiguration();
        if (minImageSize == null) {
            minImageSize = new ImageSize(this.configuration.maxImageWidthForMemoryCache, this.configuration.maxImageHeightForMemoryCache);
        }
        if (options == null) {
            options = this.configuration.defaultDisplayImageOptions;
        }
        DisplayImageOptions optionsWithFakeDisplayer = options.getDisplayer() instanceof FakeBitmapDisplayer ? options : new DisplayImageOptions.Builder().cloneFrom(options).displayer(this.fakeBitmapDisplayer).build();
        ImageView fakeImage = new ImageView(context);
        fakeImage.setLayoutParams(new ViewGroup.LayoutParams(minImageSize.getWidth(), minImageSize.getHeight()));
        fakeImage.setScaleType(ImageView.ScaleType.CENTER_CROP);
        this.displayImage(uri, fakeImage, optionsWithFakeDisplayer, listener);
    }

    private void checkConfiguration() {
        if (this.configuration == null) {
            throw new IllegalStateException(ERROR_NOT_INIT);
        }
    }

    private void initExecutorsIfNeed() {
        if (this.imageLoadingExecutor == null || this.imageLoadingExecutor.isShutdown()) {
            this.imageLoadingExecutor = this.createTaskExecutor();
        }
        if (this.cachedImageLoadingExecutor == null || this.cachedImageLoadingExecutor.isShutdown()) {
            this.cachedImageLoadingExecutor = this.createTaskExecutor();
        }
        if (this.taskDistributor == null || this.taskDistributor.isShutdown()) {
            this.taskDistributor = Executors.newCachedThreadPool();
        }
    }

    private ExecutorService createTaskExecutor() {
        boolean lifo = this.configuration.tasksProcessingType == QueueProcessingType.LIFO;
        BlockingQueue taskQueue = (BlockingQueue)((Object)(lifo ? new LIFOLinkedBlockingDeque() : new LinkedBlockingQueue()));
        return new ThreadPoolExecutor(this.configuration.threadPoolSize, this.configuration.threadPoolSize, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)taskQueue, this.configuration.displayImageThreadFactory);
    }

    public MemoryCacheAware<String, Bitmap> getMemoryCache() {
        this.checkConfiguration();
        return this.configuration.memoryCache;
    }

    public void clearMemoryCache() {
        this.checkConfiguration();
        this.configuration.memoryCache.clear();
    }

    public DiscCacheAware getDiscCache() {
        this.checkConfiguration();
        return this.configuration.discCache;
    }

    public void clearDiscCache() {
        this.checkConfiguration();
        this.configuration.discCache.clear();
    }

    public String getLoadingUriForView(ImageView imageView) {
        return this.cacheKeysForImageViews.get(imageView.hashCode());
    }

    public void cancelDisplayTask(ImageView imageView) {
        this.cacheKeysForImageViews.remove(imageView.hashCode());
    }

    public void pause() {
        this.paused.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        AtomicBoolean atomicBoolean = this.paused;
        synchronized (atomicBoolean) {
            this.paused.set(false);
            this.paused.notifyAll();
        }
    }

    public void stop() {
        if (this.imageLoadingExecutor != null) {
            this.imageLoadingExecutor.shutdownNow();
        }
        if (this.cachedImageLoadingExecutor != null) {
            this.cachedImageLoadingExecutor.shutdownNow();
        }
        if (this.taskDistributor != null) {
            this.taskDistributor.shutdownNow();
        }
    }

    private ImageSize getImageSizeScaleTo(ImageView imageView) {
        int height;
        DisplayMetrics displayMetrics = imageView.getContext().getResources().getDisplayMetrics();
        ViewGroup.LayoutParams params = imageView.getLayoutParams();
        int width = params.width;
        if (width <= 0) {
            width = this.getFieldValue(imageView, "mMaxWidth");
        }
        if (width <= 0) {
            width = this.configuration.maxImageWidthForMemoryCache;
        }
        if (width <= 0) {
            width = displayMetrics.widthPixels;
        }
        if ((height = params.height) <= 0) {
            height = this.getFieldValue(imageView, "mMaxHeight");
        }
        if (height <= 0) {
            height = this.configuration.maxImageHeightForMemoryCache;
        }
        if (height <= 0) {
            height = displayMetrics.heightPixels;
        }
        return new ImageSize(width, height);
    }

    private int getFieldValue(Object object, String fieldName) {
        int value = 0;
        try {
            Field field = ImageView.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            int fieldValue = (Integer)field.get(object);
            if (fieldValue > 0 && fieldValue < Integer.MAX_VALUE) {
                value = fieldValue;
            }
        }
        catch (Exception e) {
            L.e(e);
        }
        return value;
    }

    private ReentrantLock getLockForUri(String uri) {
        ReentrantLock lock = this.uriLocks.get(uri);
        if (lock == null) {
            lock = new ReentrantLock();
            this.uriLocks.put(uri, lock);
        }
        return lock;
    }

    AtomicBoolean getPause() {
        return this.paused;
    }
}

