/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core.display;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.widget.ImageView;
import com.nostra13.universalimageloader.core.display.BitmapDisplayer;
import com.nostra13.universalimageloader.utils.L;

public class RoundedBitmapDisplayer
implements BitmapDisplayer {
    private int roundPixels;

    public RoundedBitmapDisplayer(int roundPixels) {
        this.roundPixels = roundPixels;
    }

    @Override
    public Bitmap display(Bitmap bitmap, ImageView imageView) {
        Bitmap roundBitmap;
        int height;
        int width;
        Rect destRect;
        Rect srcRect;
        int bw = bitmap.getWidth();
        int bh = bitmap.getHeight();
        int vw = imageView.getWidth();
        int vh = imageView.getHeight();
        if (vw <= 0) {
            vw = bw;
        }
        if (vh <= 0) {
            vh = bh;
        }
        switch (imageView.getScaleType()) {
            case CENTER_INSIDE: {
                int destWidth;
                int destHeight;
                float vRation = (float)vw / (float)vh;
                float bRation = (float)bw / (float)bh;
                if (vRation > bRation) {
                    destHeight = Math.min(vh, bh);
                    destWidth = (int)((float)bw / ((float)bh / (float)destHeight));
                } else {
                    destWidth = Math.min(vw, bw);
                    destHeight = (int)((float)bh / ((float)bw / (float)destWidth));
                }
                int x = (vw - destWidth) / 2;
                int y = (vh - destHeight) / 2;
                srcRect = new Rect(0, 0, bw, bh);
                destRect = new Rect(x, y, x + destWidth, y + destHeight);
                width = vw;
                height = vh;
                break;
            }
            default: {
                float vRation = (float)vw / (float)vh;
                float bRation = (float)bw / (float)bh;
                if (vRation > bRation) {
                    width = (int)((float)bw / ((float)bh / (float)vh));
                    height = vh;
                } else {
                    width = vw;
                    height = (int)((float)bh / ((float)bw / (float)vw));
                }
                srcRect = new Rect(0, 0, bw, bh);
                destRect = new Rect(0, 0, width, height);
                break;
            }
            case CENTER_CROP: {
                int y;
                int x;
                int srcHeight;
                int srcWidth;
                float vRation = (float)vw / (float)vh;
                float bRation = (float)bw / (float)bh;
                if (vRation > bRation) {
                    srcWidth = bw;
                    srcHeight = (int)((float)vh * ((float)bw / (float)vw));
                    x = 0;
                    y = (bh - srcHeight) / 2;
                } else {
                    srcWidth = (int)((float)vw * ((float)bh / (float)vh));
                    srcHeight = bh;
                    x = (bw - srcWidth) / 2;
                    y = 0;
                }
                width = Math.min(vw, bw);
                height = Math.min(vh, bh);
                srcRect = new Rect(x, y, x + srcWidth, y + srcHeight);
                destRect = new Rect(0, 0, width, height);
                break;
            }
            case FIT_XY: {
                width = vw;
                height = vh;
                srcRect = new Rect(0, 0, bw, bh);
                destRect = new Rect(0, 0, width, height);
                break;
            }
            case CENTER: 
            case MATRIX: {
                width = Math.min(vw, bw);
                height = Math.min(vh, bh);
                int x = (bw - width) / 2;
                int y = (bh - height) / 2;
                srcRect = new Rect(x, y, x + width, y + height);
                destRect = new Rect(0, 0, width, height);
            }
        }
        try {
            roundBitmap = this.getRoundedCornerBitmap(bitmap, srcRect, destRect, width, height);
        }
        catch (OutOfMemoryError e) {
            L.e(e, "Can't create bitmap with rounded corners. Not enough memory.", new Object[0]);
            roundBitmap = bitmap;
        }
        imageView.setImageBitmap(roundBitmap);
        return roundBitmap;
    }

    private Bitmap getRoundedCornerBitmap(Bitmap bitmap, Rect srcRect, Rect destRect, int width, int height) {
        Bitmap output = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        Paint paint = new Paint();
        RectF destRectF = new RectF(destRect);
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-16777216);
        canvas.drawRoundRect(destRectF, (float)this.roundPixels, (float)this.roundPixels, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, srcRect, destRectF, paint);
        return output;
    }
}

