/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core.download;

import com.nostra13.universalimageloader.core.assist.FlushedInputStream;
import com.nostra13.universalimageloader.core.download.ImageDownloader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLConnection;

public class URLConnectionImageDownloader
extends ImageDownloader {
    public static final int DEFAULT_HTTP_CONNECT_TIMEOUT = 5000;
    public static final int DEFAULT_HTTP_READ_TIMEOUT = 20000;
    private int connectTimeout;
    private int readTimeout;

    public URLConnectionImageDownloader() {
        this(5000, 20000);
    }

    public URLConnectionImageDownloader(int connectTimeout, int readTimeout) {
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    @Override
    public InputStream getStreamFromNetwork(URI imageUri) throws IOException {
        URLConnection conn = imageUri.toURL().openConnection();
        conn.setConnectTimeout(this.connectTimeout);
        conn.setReadTimeout(this.readTimeout);
        return new FlushedInputStream(new BufferedInputStream(conn.getInputStream(), 8192));
    }
}

