/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.cache.disc;

import com.nostra13.universalimageloader.cache.disc.BaseDiscCache;
import com.nostra13.universalimageloader.cache.disc.naming.FileNameGenerator;
import com.nostra13.universalimageloader.core.DefaultConfigurationFactory;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class LimitedDiscCache
extends BaseDiscCache {
    private int cacheSize = 0;
    private int sizeLimit;
    private final Map<File, Long> lastUsageDates = Collections.synchronizedMap(new HashMap());

    public LimitedDiscCache(File cacheDir, int sizeLimit) {
        this(cacheDir, DefaultConfigurationFactory.createFileNameGenerator(), sizeLimit);
    }

    public LimitedDiscCache(File cacheDir, FileNameGenerator fileNameGenerator, int sizeLimit) {
        super(cacheDir, fileNameGenerator);
        this.sizeLimit = sizeLimit;
        this.calculateCacheSizeAndFillUsageMap();
    }

    private void calculateCacheSizeAndFillUsageMap() {
        File[] cachedFiles;
        int size = 0;
        for (File cachedFile : cachedFiles = this.cacheDir.listFiles()) {
            size += this.getSize(cachedFile);
            this.lastUsageDates.put(cachedFile, cachedFile.lastModified());
        }
        this.cacheSize = size;
    }

    @Override
    public void put(String key, File file) {
        int freedSize;
        int valueSize = this.getSize(file);
        while (this.cacheSize + valueSize > this.sizeLimit && (freedSize = this.removeNext()) != 0) {
            this.cacheSize -= freedSize;
        }
        this.cacheSize += valueSize;
        Long currentTime = System.currentTimeMillis();
        file.setLastModified(currentTime);
        this.lastUsageDates.put(file, currentTime);
    }

    @Override
    public File get(String key) {
        File file = super.get(key);
        Long currentTime = System.currentTimeMillis();
        file.setLastModified(currentTime);
        this.lastUsageDates.put(file, currentTime);
        return file;
    }

    @Override
    public void clear() {
        this.lastUsageDates.clear();
        this.cacheSize = 0;
        super.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeNext() {
        if (this.lastUsageDates.isEmpty()) {
            return 0;
        }
        Long oldestUsage = null;
        File mostLongUsedFile = null;
        Set<Map.Entry<File, Long>> entries = this.lastUsageDates.entrySet();
        Map<File, Long> map = this.lastUsageDates;
        synchronized (map) {
            for (Map.Entry<File, Long> entry : entries) {
                if (mostLongUsedFile == null) {
                    mostLongUsedFile = entry.getKey();
                    oldestUsage = entry.getValue();
                    continue;
                }
                Long lastValueUsage = entry.getValue();
                if (lastValueUsage >= oldestUsage) continue;
                oldestUsage = lastValueUsage;
                mostLongUsedFile = entry.getKey();
            }
        }
        int fileSize = this.getSize(mostLongUsedFile);
        if (mostLongUsedFile.delete()) {
            this.lastUsageDates.remove(mostLongUsedFile);
        }
        return fileSize;
    }

    protected abstract int getSize(File var1);
}

