/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.cache.memory.impl;

import com.nostra13.universalimageloader.cache.memory.MemoryCacheAware;
import java.util.Collection;
import java.util.Comparator;

public class FuzzyKeyMemoryCache<K, V>
implements MemoryCacheAware<K, V> {
    private final MemoryCacheAware<K, V> cache;
    private final Comparator<K> keyComparator;

    public FuzzyKeyMemoryCache(MemoryCacheAware<K, V> cache, Comparator<K> keyComparator) {
        this.cache = cache;
        this.keyComparator = keyComparator;
    }

    @Override
    public synchronized boolean put(K key, V value) {
        Object keyToRemove = null;
        for (K cacheKey : this.cache.keys()) {
            if (this.keyComparator.compare(key, cacheKey) != 0) continue;
            keyToRemove = cacheKey;
        }
        this.cache.remove(keyToRemove);
        return this.cache.put(key, value);
    }

    @Override
    public synchronized V get(K key) {
        return this.cache.get(key);
    }

    @Override
    public synchronized void remove(K key) {
        this.cache.remove(key);
    }

    @Override
    public synchronized void clear() {
        this.cache.clear();
    }

    @Override
    public synchronized Collection<K> keys() {
        return this.cache.keys();
    }
}

