/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core.download;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.net.Uri;
import com.nostra13.universalimageloader.core.assist.FlushedInputStream;
import com.nostra13.universalimageloader.core.download.ImageDownloader;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;

public class BaseImageDownloader
implements ImageDownloader {
    public static final int DEFAULT_HTTP_CONNECT_TIMEOUT = 5000;
    public static final int DEFAULT_HTTP_READ_TIMEOUT = 20000;
    protected static final int BUFFER_SIZE = 8192;
    private static final String ERROR_UNSUPPORTED_SCHEME = "UIL doesn't support scheme [%s] by default. You should implement this support byself";
    protected static final String SCHEME_ASSETS_PREFIX = "assets://";
    protected static final String SCHEME_DRAWABLE_PREFIX = "drawable://";
    protected final Context context;
    protected final int connectTimeout;
    protected final int readTimeout;

    public BaseImageDownloader(Context context) {
        this.context = context.getApplicationContext();
        this.connectTimeout = 5000;
        this.readTimeout = 20000;
    }

    public BaseImageDownloader(Context context, int connectTimeout, int readTimeout) {
        this.context = context.getApplicationContext();
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    @Override
    public InputStream getStream(URI imageUri, Object extra) throws IOException {
        String scheme = imageUri.getScheme();
        if ("http".equals(scheme) || "https".equals(scheme)) {
            return this.getStreamFromNetwork(imageUri, extra);
        }
        if ("file".equals(scheme)) {
            return this.getStreamFromFile(imageUri, extra);
        }
        if ("content".equals(scheme)) {
            return this.getStreamFromContent(imageUri, extra);
        }
        if ("assets".equals(scheme)) {
            return this.getStreamFromAssets(imageUri, extra);
        }
        if ("drawable".equals(scheme)) {
            return this.getStreamFromDrawable(imageUri, extra);
        }
        return this.getStreamFromOtherSource(imageUri, extra);
    }

    protected InputStream getStreamFromNetwork(URI imageUri, Object extra) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)imageUri.toURL().openConnection();
        conn.setConnectTimeout(this.connectTimeout);
        conn.setReadTimeout(this.readTimeout);
        return new FlushedInputStream(conn.getInputStream(), 8192);
    }

    protected InputStream getStreamFromFile(URI imageUri, Object extra) throws IOException {
        return new BufferedInputStream(imageUri.toURL().openStream(), 8192);
    }

    protected InputStream getStreamFromContent(URI imageUri, Object extra) throws FileNotFoundException {
        ContentResolver res = this.context.getContentResolver();
        Uri uri = Uri.parse((String)imageUri.toString());
        return res.openInputStream(uri);
    }

    protected InputStream getStreamFromAssets(URI imageUri, Object extra) throws IOException {
        String filePath = imageUri.toString().substring(SCHEME_ASSETS_PREFIX.length());
        return this.context.getAssets().open(filePath);
    }

    protected InputStream getStreamFromDrawable(URI imageUri, Object extra) {
        String drawableIdString = imageUri.toString().substring(SCHEME_DRAWABLE_PREFIX.length());
        int drawableId = Integer.parseInt(drawableIdString);
        BitmapDrawable drawable = (BitmapDrawable)this.context.getResources().getDrawable(drawableId);
        Bitmap bitmap = drawable.getBitmap();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)os);
        return new ByteArrayInputStream(os.toByteArray());
    }

    protected InputStream getStreamFromOtherSource(URI imageUri, Object extra) throws IOException {
        throw new UnsupportedOperationException(String.format(ERROR_UNSUPPORTED_SCHEME, imageUri.getScheme()));
    }
}

