/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core;

import android.graphics.Bitmap;
import com.nostra13.universalimageloader.core.DefaultConfigurationFactory;
import com.nostra13.universalimageloader.core.assist.ImageScaleType;
import com.nostra13.universalimageloader.core.display.BitmapDisplayer;
import com.nostra13.universalimageloader.core.process.BitmapProcessor;

public final class DisplayImageOptions {
    private final int stubImage;
    private final int imageForEmptyUri;
    private final int imageOnFail;
    private final boolean resetViewBeforeLoading;
    private final boolean cacheInMemory;
    private final boolean cacheOnDisc;
    private final ImageScaleType imageScaleType;
    private final Bitmap.Config bitmapConfig;
    private final int delayBeforeLoading;
    private final Object extraForDownloader;
    private final BitmapProcessor preProcessor;
    private final BitmapProcessor postProcessor;
    private final BitmapDisplayer displayer;

    private DisplayImageOptions(Builder builder) {
        this.stubImage = builder.stubImage;
        this.imageForEmptyUri = builder.imageForEmptyUri;
        this.imageOnFail = builder.imageOnFail;
        this.resetViewBeforeLoading = builder.resetViewBeforeLoading;
        this.cacheInMemory = builder.cacheInMemory;
        this.cacheOnDisc = builder.cacheOnDisc;
        this.imageScaleType = builder.imageScaleType;
        this.bitmapConfig = builder.bitmapConfig;
        this.delayBeforeLoading = builder.delayBeforeLoading;
        this.extraForDownloader = builder.extraForDownloader;
        this.preProcessor = builder.preProcessor;
        this.postProcessor = builder.postProcessor;
        this.displayer = builder.displayer;
    }

    boolean shouldShowStubImage() {
        return this.stubImage != 0;
    }

    boolean shouldShowImageForEmptyUri() {
        return this.imageForEmptyUri != 0;
    }

    boolean shouldShowImageOnFail() {
        return this.imageOnFail != 0;
    }

    boolean shouldPreProcess() {
        return this.preProcessor != null;
    }

    boolean shouldPostProcess() {
        return this.postProcessor != null;
    }

    boolean shouldDelayBeforeLoading() {
        return this.delayBeforeLoading > 0;
    }

    int getStubImage() {
        return this.stubImage;
    }

    int getImageForEmptyUri() {
        return this.imageForEmptyUri;
    }

    int getImageOnFail() {
        return this.imageOnFail;
    }

    boolean isResetViewBeforeLoading() {
        return this.resetViewBeforeLoading;
    }

    boolean isCacheInMemory() {
        return this.cacheInMemory;
    }

    boolean isCacheOnDisc() {
        return this.cacheOnDisc;
    }

    ImageScaleType getImageScaleType() {
        return this.imageScaleType;
    }

    Bitmap.Config getBitmapConfig() {
        return this.bitmapConfig;
    }

    int getDelayBeforeLoading() {
        return this.delayBeforeLoading;
    }

    Object getExtraForDownloader() {
        return this.extraForDownloader;
    }

    BitmapProcessor getPreProcessor() {
        return this.preProcessor;
    }

    BitmapProcessor getPostProcessor() {
        return this.postProcessor;
    }

    BitmapDisplayer getDisplayer() {
        return this.displayer;
    }

    public static DisplayImageOptions createSimple() {
        return new Builder().build();
    }

    public static class Builder {
        private int stubImage = 0;
        private int imageForEmptyUri = 0;
        private int imageOnFail = 0;
        private boolean resetViewBeforeLoading = false;
        private boolean cacheInMemory = false;
        private boolean cacheOnDisc = false;
        private ImageScaleType imageScaleType = ImageScaleType.IN_SAMPLE_POWER_OF_2;
        private Bitmap.Config bitmapConfig = Bitmap.Config.ARGB_8888;
        private int delayBeforeLoading = 0;
        private Object extraForDownloader = null;
        private BitmapProcessor preProcessor = null;
        private BitmapProcessor postProcessor = null;
        private BitmapDisplayer displayer = DefaultConfigurationFactory.createBitmapDisplayer();

        public Builder showStubImage(int stubImageRes) {
            this.stubImage = stubImageRes;
            return this;
        }

        public Builder showImageForEmptyUri(int imageRes) {
            this.imageForEmptyUri = imageRes;
            return this;
        }

        public Builder showImageOnFail(int imageRes) {
            this.imageOnFail = imageRes;
            return this;
        }

        public Builder resetViewBeforeLoading() {
            this.resetViewBeforeLoading = true;
            return this;
        }

        public Builder cacheInMemory() {
            this.cacheInMemory = true;
            return this;
        }

        public Builder cacheOnDisc() {
            this.cacheOnDisc = true;
            return this;
        }

        public Builder imageScaleType(ImageScaleType imageScaleType) {
            this.imageScaleType = imageScaleType;
            return this;
        }

        public Builder bitmapConfig(Bitmap.Config bitmapConfig) {
            this.bitmapConfig = bitmapConfig;
            return this;
        }

        public Builder delayBeforeLoading(int delayInMillis) {
            this.delayBeforeLoading = delayInMillis;
            return this;
        }

        public Builder extraForDownloader(Object extra) {
            this.extraForDownloader = extra;
            return this;
        }

        public Builder preProcessor(BitmapProcessor preProcessor) {
            this.preProcessor = preProcessor;
            return this;
        }

        public Builder postProcessor(BitmapProcessor postProcessor) {
            this.postProcessor = postProcessor;
            return this;
        }

        public Builder displayer(BitmapDisplayer displayer) {
            this.displayer = displayer;
            return this;
        }

        public Builder cloneFrom(DisplayImageOptions options) {
            this.stubImage = options.stubImage;
            this.imageForEmptyUri = options.imageForEmptyUri;
            this.imageOnFail = options.imageOnFail;
            this.resetViewBeforeLoading = options.resetViewBeforeLoading;
            this.cacheInMemory = options.cacheInMemory;
            this.cacheOnDisc = options.cacheOnDisc;
            this.imageScaleType = options.imageScaleType;
            this.bitmapConfig = options.bitmapConfig;
            this.delayBeforeLoading = options.delayBeforeLoading;
            this.extraForDownloader = options.extraForDownloader;
            this.preProcessor = options.preProcessor;
            this.postProcessor = options.postProcessor;
            this.displayer = options.displayer;
            return this;
        }

        public DisplayImageOptions build() {
            return new DisplayImageOptions(this);
        }
    }
}

