/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core;

import android.widget.ImageView;
import com.nostra13.universalimageloader.core.ImageLoaderConfiguration;
import com.nostra13.universalimageloader.core.LoadAndDisplayImageTask;
import com.nostra13.universalimageloader.core.ProcessAndDisplayImageTask;
import com.nostra13.universalimageloader.core.assist.QueueProcessingType;
import com.nostra13.universalimageloader.core.assist.deque.LIFOLinkedBlockingDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

class ImageLoaderEngine {
    final ImageLoaderConfiguration configuration;
    private ExecutorService imageLoadingExecutor;
    private ExecutorService cachedImageLoadingExecutor;
    private ExecutorService taskDistributor;
    private final Map<Integer, String> cacheKeysForImageViews = Collections.synchronizedMap(new HashMap());
    private final Map<String, ReentrantLock> uriLocks = new WeakHashMap<String, ReentrantLock>();
    private final AtomicBoolean paused = new AtomicBoolean(false);
    private final AtomicBoolean networkDenied = new AtomicBoolean(false);
    private final AtomicBoolean slowNetwork = new AtomicBoolean(false);

    ImageLoaderEngine(ImageLoaderConfiguration configuration) {
        this.configuration = configuration;
    }

    void submit(final LoadAndDisplayImageTask task) {
        this.initExecutorsIfNeed();
        this.taskDistributor.submit(new Runnable(){

            @Override
            public void run() {
                boolean isImageCachedOnDisc = ImageLoaderEngine.this.configuration.discCache.get(task.getLoadingUri()).exists();
                if (isImageCachedOnDisc) {
                    ImageLoaderEngine.this.cachedImageLoadingExecutor.submit(task);
                } else {
                    ImageLoaderEngine.this.imageLoadingExecutor.submit(task);
                }
            }
        });
    }

    void submit(ProcessAndDisplayImageTask task) {
        this.initExecutorsIfNeed();
        this.cachedImageLoadingExecutor.submit(task);
    }

    private void initExecutorsIfNeed() {
        if (this.imageLoadingExecutor == null || this.imageLoadingExecutor.isShutdown()) {
            this.imageLoadingExecutor = this.createTaskExecutor();
        }
        if (this.cachedImageLoadingExecutor == null || this.cachedImageLoadingExecutor.isShutdown()) {
            this.cachedImageLoadingExecutor = this.createTaskExecutor();
        }
        if (this.taskDistributor == null || this.taskDistributor.isShutdown()) {
            this.taskDistributor = Executors.newCachedThreadPool();
        }
    }

    private ExecutorService createTaskExecutor() {
        boolean lifo = this.configuration.tasksProcessingType == QueueProcessingType.LIFO;
        BlockingQueue taskQueue = (BlockingQueue)((Object)(lifo ? new LIFOLinkedBlockingDeque() : new LinkedBlockingQueue()));
        return new ThreadPoolExecutor(this.configuration.threadPoolSize, this.configuration.threadPoolSize, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)taskQueue, this.configuration.displayImageThreadFactory);
    }

    String getLoadingUriForView(ImageView imageView) {
        return this.cacheKeysForImageViews.get(imageView.hashCode());
    }

    void prepareDisplayTaskFor(ImageView imageView, String memoryCacheKey) {
        this.cacheKeysForImageViews.put(imageView.hashCode(), memoryCacheKey);
    }

    void cancelDisplayTaskFor(ImageView imageView) {
        this.cacheKeysForImageViews.remove(imageView.hashCode());
    }

    void denyNetworkDownloads(boolean denyNetworkDownloads) {
        this.networkDenied.set(denyNetworkDownloads);
    }

    void handleSlowNetwork(boolean handleSlowNetwork) {
        this.slowNetwork.set(handleSlowNetwork);
    }

    void pause() {
        this.paused.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resume() {
        AtomicBoolean atomicBoolean = this.paused;
        synchronized (atomicBoolean) {
            this.paused.set(false);
            this.paused.notifyAll();
        }
    }

    void stop() {
        if (this.imageLoadingExecutor != null) {
            this.imageLoadingExecutor.shutdownNow();
        }
        if (this.cachedImageLoadingExecutor != null) {
            this.cachedImageLoadingExecutor.shutdownNow();
        }
        if (this.taskDistributor != null) {
            this.taskDistributor.shutdownNow();
        }
    }

    ReentrantLock getLockForUri(String uri) {
        ReentrantLock lock = this.uriLocks.get(uri);
        if (lock == null) {
            lock = new ReentrantLock();
            this.uriLocks.put(uri, lock);
        }
        return lock;
    }

    AtomicBoolean getPause() {
        return this.paused;
    }

    boolean isNetworkDenied() {
        return this.networkDenied.get();
    }

    boolean isSlowNetwork() {
        return this.slowNetwork.get();
    }
}

