/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.nostra13.universalimageloader.core.DisplayImageOptions;
import com.nostra13.universalimageloader.core.assist.ImageScaleType;
import com.nostra13.universalimageloader.core.assist.ImageSize;
import com.nostra13.universalimageloader.core.assist.ViewScaleType;
import com.nostra13.universalimageloader.core.download.ImageDownloader;
import com.nostra13.universalimageloader.utils.IoUtils;
import com.nostra13.universalimageloader.utils.L;
import java.io.IOException;
import java.io.InputStream;

class ImageDecoder {
    private final String imageUri;
    private final ImageDownloader imageDownloader;
    private final DisplayImageOptions displayOptions;
    private boolean loggingEnabled;

    ImageDecoder(String imageUri, ImageDownloader imageDownloader, DisplayImageOptions options) {
        this.imageUri = imageUri;
        this.imageDownloader = imageDownloader;
        this.displayOptions = options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap decode(ImageSize targetSize, ImageScaleType scaleType, ViewScaleType viewScaleType) throws IOException {
        Bitmap subsampledBitmap;
        BitmapFactory.Options decodeOptions = this.getBitmapOptionsForImageDecoding(targetSize, scaleType, viewScaleType);
        InputStream imageStream = this.imageDownloader.getStream(this.imageUri, this.displayOptions.getExtraForDownloader());
        try {
            subsampledBitmap = BitmapFactory.decodeStream((InputStream)imageStream, null, (BitmapFactory.Options)decodeOptions);
        }
        finally {
            IoUtils.closeSilently(imageStream);
        }
        if (subsampledBitmap == null) {
            this.log("Image can't be decoded [%s]", this.imageUri);
            return null;
        }
        if (scaleType == ImageScaleType.EXACTLY || scaleType == ImageScaleType.EXACTLY_STRETCHED) {
            subsampledBitmap = this.scaleImageExactly(subsampledBitmap, targetSize, scaleType, viewScaleType);
        }
        return subsampledBitmap;
    }

    private BitmapFactory.Options getBitmapOptionsForImageDecoding(ImageSize targetSize, ImageScaleType scaleType, ViewScaleType viewScaleType) throws IOException {
        BitmapFactory.Options decodeOptions = new BitmapFactory.Options();
        decodeOptions.inSampleSize = scaleType == ImageScaleType.NONE ? 1 : this.computeImageScale(targetSize, scaleType, viewScaleType);
        decodeOptions.inPreferredConfig = this.displayOptions.getBitmapConfig();
        return decodeOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int computeImageScale(ImageSize targetSize, ImageScaleType scaleType, ViewScaleType viewScaleType) throws IOException {
        int targetWidth = targetSize.getWidth();
        int targetHeight = targetSize.getHeight();
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        InputStream imageStream = this.imageDownloader.getStream(this.imageUri, this.displayOptions.getExtraForDownloader());
        try {
            BitmapFactory.decodeStream((InputStream)imageStream, null, (BitmapFactory.Options)options);
        }
        finally {
            IoUtils.closeSilently(imageStream);
        }
        int scale = 1;
        int imageWidth = options.outWidth;
        int imageHeight = options.outHeight;
        int widthScale = imageWidth / targetWidth;
        int heightScale = imageHeight / targetHeight;
        if (viewScaleType == ViewScaleType.FIT_INSIDE) {
            if (scaleType == ImageScaleType.IN_SAMPLE_POWER_OF_2) {
                while (imageWidth / 2 >= targetWidth || imageHeight / 2 >= targetHeight) {
                    imageWidth /= 2;
                    imageHeight /= 2;
                    scale *= 2;
                }
            } else {
                scale = Math.max(widthScale, heightScale);
            }
        } else if (scaleType == ImageScaleType.IN_SAMPLE_POWER_OF_2) {
            while (imageWidth / 2 >= targetWidth && imageHeight / 2 >= targetHeight) {
                imageWidth /= 2;
                imageHeight /= 2;
                scale *= 2;
            }
        } else {
            scale = Math.min(widthScale, heightScale);
        }
        if (scale < 1) {
            scale = 1;
        }
        this.log("Original image (%1$dx%2$d) is going to be subsampled to %3$dx%4$d view. Computed scale size - %5$d", imageWidth, imageHeight, targetWidth, targetHeight, scale);
        return scale;
    }

    private Bitmap scaleImageExactly(Bitmap subsampledBitmap, ImageSize targetSize, ImageScaleType scaleType, ViewScaleType viewScaleType) {
        Bitmap scaledBitmap;
        int destHeight;
        int destWidth;
        float srcWidth = subsampledBitmap.getWidth();
        float srcHeight = subsampledBitmap.getHeight();
        float widthScale = srcWidth / (float)targetSize.getWidth();
        float heightScale = srcHeight / (float)targetSize.getHeight();
        if (viewScaleType == ViewScaleType.FIT_INSIDE && widthScale >= heightScale || viewScaleType == ViewScaleType.CROP && widthScale < heightScale) {
            destWidth = targetSize.getWidth();
            destHeight = (int)(srcHeight / widthScale);
        } else {
            destWidth = (int)(srcWidth / heightScale);
            destHeight = targetSize.getHeight();
        }
        if (scaleType == ImageScaleType.EXACTLY && (float)destWidth < srcWidth && (float)destHeight < srcHeight || scaleType == ImageScaleType.EXACTLY_STRETCHED && (float)destWidth != srcWidth && (float)destHeight != srcHeight) {
            scaledBitmap = Bitmap.createScaledBitmap((Bitmap)subsampledBitmap, (int)destWidth, (int)destHeight, (boolean)true);
            if (scaledBitmap != subsampledBitmap) {
                subsampledBitmap.recycle();
            }
            this.log("Subsampled image (%1$dx%2$d) was scaled to %3$dx%4$d", (int)srcWidth, (int)srcHeight, destWidth, destHeight);
        } else {
            scaledBitmap = subsampledBitmap;
        }
        return scaledBitmap;
    }

    void setLoggingEnabled(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
    }

    private void log(String message, Object ... args) {
        if (this.loggingEnabled) {
            L.i(message, args);
        }
    }
}

