/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core;

import android.graphics.Bitmap;
import android.os.Handler;
import android.view.View;
import android.widget.ImageView;
import com.nostra13.universalimageloader.cache.disc.DiscCacheAware;
import com.nostra13.universalimageloader.core.DisplayBitmapTask;
import com.nostra13.universalimageloader.core.DisplayImageOptions;
import com.nostra13.universalimageloader.core.ImageDecoder;
import com.nostra13.universalimageloader.core.ImageLoaderConfiguration;
import com.nostra13.universalimageloader.core.ImageLoaderEngine;
import com.nostra13.universalimageloader.core.ImageLoadingInfo;
import com.nostra13.universalimageloader.core.assist.FailReason;
import com.nostra13.universalimageloader.core.assist.ImageLoadingListener;
import com.nostra13.universalimageloader.core.assist.ImageScaleType;
import com.nostra13.universalimageloader.core.assist.ImageSize;
import com.nostra13.universalimageloader.core.assist.ViewScaleType;
import com.nostra13.universalimageloader.core.download.ImageDownloader;
import com.nostra13.universalimageloader.utils.IoUtils;
import com.nostra13.universalimageloader.utils.L;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

final class LoadAndDisplayImageTask
implements Runnable {
    private static final int BUFFER_SIZE = 8192;
    private final ImageLoaderEngine engine;
    private final ImageLoadingInfo imageLoadingInfo;
    private final Handler handler;
    private final ImageLoaderConfiguration configuration;
    private final ImageDownloader downloader;
    private final ImageDownloader networkDeniedDownloader;
    private final ImageDownloader slowNetworkDownloader;
    private final boolean loggingEnabled;
    final String uri;
    private final String memoryCacheKey;
    final ImageView imageView;
    private final ImageSize targetSize;
    final DisplayImageOptions options;
    final ImageLoadingListener listener;

    public LoadAndDisplayImageTask(ImageLoaderEngine engine, ImageLoadingInfo imageLoadingInfo, Handler handler) {
        this.engine = engine;
        this.imageLoadingInfo = imageLoadingInfo;
        this.handler = handler;
        this.configuration = engine.configuration;
        this.downloader = this.configuration.downloader;
        this.networkDeniedDownloader = this.configuration.networkDeniedDownloader;
        this.slowNetworkDownloader = this.configuration.slowNetworkDownloader;
        this.loggingEnabled = this.configuration.loggingEnabled;
        this.uri = imageLoadingInfo.uri;
        this.memoryCacheKey = imageLoadingInfo.memoryCacheKey;
        this.imageView = imageLoadingInfo.imageView;
        this.targetSize = imageLoadingInfo.targetSize;
        this.options = imageLoadingInfo.options;
        this.listener = imageLoadingInfo.listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Bitmap bmp;
        AtomicBoolean pause = this.engine.getPause();
        if (pause.get()) {
            AtomicBoolean atomicBoolean = pause;
            synchronized (atomicBoolean) {
                this.log("ImageLoader is paused. Waiting...  [%s]", this.memoryCacheKey);
                try {
                    pause.wait();
                }
                catch (InterruptedException e) {
                    L.e("Task was interrupted [%s]", this.memoryCacheKey);
                    return;
                }
                this.log(".. Resume loading [%s]", this.memoryCacheKey);
            }
        }
        if (this.checkTaskIsNotActual()) {
            return;
        }
        if (this.options.shouldDelayBeforeLoading()) {
            this.log("Delay %d ms before loading...  [%s]", this.options.getDelayBeforeLoading(), this.memoryCacheKey);
            try {
                Thread.sleep(this.options.getDelayBeforeLoading());
            }
            catch (InterruptedException e) {
                L.e("Task was interrupted [%s]", this.memoryCacheKey);
                return;
            }
            if (this.checkTaskIsNotActual()) {
                return;
            }
        }
        ReentrantLock loadFromUriLock = this.imageLoadingInfo.loadFromUriLock;
        this.log("Start display image task [%s]", this.memoryCacheKey);
        if (loadFromUriLock.isLocked()) {
            this.log("Image already is loading. Waiting... [%s]", this.memoryCacheKey);
        }
        loadFromUriLock.lock();
        try {
            if (this.checkTaskIsNotActual()) {
                return;
            }
            bmp = this.configuration.memoryCache.get(this.memoryCacheKey);
            if (bmp == null) {
                bmp = this.tryLoadBitmap();
                if (bmp == null) {
                    return;
                }
                if (this.checkTaskIsNotActual() || this.checkTaskIsInterrupted()) {
                    return;
                }
                if (this.options.shouldPreProcess()) {
                    this.log("PreProcess image before caching in memory [%s]", this.memoryCacheKey);
                    bmp = this.options.getPreProcessor().process(bmp);
                }
                if (this.options.isCacheInMemory()) {
                    this.log("Cache image in memory [%s]", this.memoryCacheKey);
                    this.configuration.memoryCache.put(this.memoryCacheKey, bmp);
                }
            } else {
                this.log("...Get cached bitmap from memory after waiting. [%s]", this.memoryCacheKey);
            }
            if (this.options.shouldPostProcess()) {
                this.log("PostProcess image before displaying [%s]", this.memoryCacheKey);
                bmp = this.options.getPostProcessor().process(bmp);
            }
        }
        finally {
            loadFromUriLock.unlock();
        }
        if (this.checkTaskIsNotActual() || this.checkTaskIsInterrupted()) {
            return;
        }
        DisplayBitmapTask displayBitmapTask = new DisplayBitmapTask(bmp, this.imageLoadingInfo, this.engine);
        displayBitmapTask.setLoggingEnabled(this.loggingEnabled);
        this.handler.post((Runnable)displayBitmapTask);
    }

    private boolean checkTaskIsNotActual() {
        boolean imageViewWasReused;
        String currentCacheKey = this.engine.getLoadingUriForView(this.imageView);
        boolean bl = imageViewWasReused = !this.memoryCacheKey.equals(currentCacheKey);
        if (imageViewWasReused) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    LoadAndDisplayImageTask.this.listener.onLoadingCancelled(LoadAndDisplayImageTask.this.uri, (View)LoadAndDisplayImageTask.this.imageView);
                }
            });
        }
        if (imageViewWasReused) {
            this.log("ImageView is reused for another image. Task is cancelled. [%s]", this.memoryCacheKey);
        }
        return imageViewWasReused;
    }

    private boolean checkTaskIsInterrupted() {
        boolean interrupted = Thread.interrupted();
        if (interrupted) {
            this.log("Task was interrupted [%s]", this.memoryCacheKey);
        }
        return interrupted;
    }

    private Bitmap tryLoadBitmap() {
        DiscCacheAware discCache = this.configuration.discCache;
        File imageFile = discCache.get(this.uri);
        File cacheDir = imageFile.getParentFile();
        if (cacheDir == null || !cacheDir.exists() && !cacheDir.mkdirs()) {
            imageFile = this.configuration.reserveDiscCache.get(this.uri);
        }
        Bitmap bitmap = null;
        try {
            String imageUriForDecoding;
            if (imageFile.exists()) {
                this.log("Load image from disc cache [%s]", this.memoryCacheKey);
                Bitmap b = this.decodeImage(ImageDownloader.Scheme.FILE.wrap(imageFile.getAbsolutePath()));
                if (b != null) {
                    return b;
                }
            }
            this.log("Load image from Internet [%s]", this.memoryCacheKey);
            if (this.options.isCacheOnDisc()) {
                this.log("Cache image on disc [%s]", this.memoryCacheKey);
                this.saveImageOnDisc(imageFile);
                discCache.put(this.uri, imageFile);
                imageUriForDecoding = ImageDownloader.Scheme.FILE.wrap(imageFile.getAbsolutePath());
            } else {
                imageUriForDecoding = this.uri;
            }
            bitmap = this.decodeImage(imageUriForDecoding);
            if (bitmap == null) {
                this.fireImageLoadingFailedEvent(FailReason.FailType.DECODING_ERROR, null);
            }
        }
        catch (IllegalStateException e) {
            this.fireImageLoadingFailedEvent(FailReason.FailType.NETWORK_DENIED, null);
        }
        catch (IOException e) {
            L.e(e);
            this.fireImageLoadingFailedEvent(FailReason.FailType.IO_ERROR, e);
            if (imageFile.exists()) {
                imageFile.delete();
            }
        }
        catch (OutOfMemoryError e) {
            L.e(e);
            this.fireImageLoadingFailedEvent(FailReason.FailType.OUT_OF_MEMORY, e);
        }
        catch (Throwable e) {
            L.e(e);
            this.fireImageLoadingFailedEvent(FailReason.FailType.UNKNOWN, e);
        }
        return bitmap;
    }

    private Bitmap decodeImage(String imageUri) throws IOException {
        ImageDecoder decoder = new ImageDecoder(imageUri, this.getDownloader(), this.options);
        decoder.setLoggingEnabled(this.loggingEnabled);
        ViewScaleType viewScaleType = ViewScaleType.fromImageView(this.imageView);
        return decoder.decode(this.targetSize, this.options.getImageScaleType(), viewScaleType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveImageOnDisc(File targetFile) throws IOException, URISyntaxException {
        int width = this.configuration.maxImageWidthForDiscCache;
        int height = this.configuration.maxImageHeightForDiscCache;
        if (width > 0 || height > 0) {
            ImageSize targetImageSize = new ImageSize(width, height);
            ImageDecoder decoder = new ImageDecoder(this.uri, this.getDownloader(), this.options);
            decoder.setLoggingEnabled(this.loggingEnabled);
            Bitmap bmp = decoder.decode(targetImageSize, ImageScaleType.IN_SAMPLE_INT, ViewScaleType.FIT_INSIDE);
            if (bmp != null) {
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(targetFile), 8192);
                boolean compressedSuccessfully = false;
                try {
                    compressedSuccessfully = bmp.compress(this.configuration.imageCompressFormatForDiscCache, this.configuration.imageQualityForDiscCache, (OutputStream)os);
                }
                finally {
                    IoUtils.closeSilently(os);
                }
                if (compressedSuccessfully) {
                    bmp.recycle();
                    return;
                }
            }
        }
        InputStream is = this.getDownloader().getStream(this.uri, this.options.getExtraForDownloader());
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(targetFile), 8192);
            try {
                IoUtils.copyStream(is, os);
            }
            finally {
                IoUtils.closeSilently(os);
            }
        }
        finally {
            IoUtils.closeSilently(is);
        }
    }

    private void fireImageLoadingFailedEvent(final FailReason.FailType failType, final Throwable failCause) {
        if (!Thread.interrupted()) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    if (LoadAndDisplayImageTask.this.options.shouldShowImageOnFail()) {
                        LoadAndDisplayImageTask.this.imageView.setImageResource(LoadAndDisplayImageTask.this.options.getImageOnFail());
                    }
                    LoadAndDisplayImageTask.this.listener.onLoadingFailed(LoadAndDisplayImageTask.this.uri, (View)LoadAndDisplayImageTask.this.imageView, new FailReason(failType, failCause));
                }
            });
        }
    }

    private ImageDownloader getDownloader() {
        ImageDownloader d = this.engine.isNetworkDenied() ? this.networkDeniedDownloader : (this.engine.isSlowNetwork() ? this.slowNetworkDownloader : this.downloader);
        return d;
    }

    String getLoadingUri() {
        return this.uri;
    }

    private void log(String message, Object ... args) {
        if (this.loggingEnabled) {
            L.i(message, args);
        }
    }
}

