/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.cache.disc;

import com.nostra13.universalimageloader.cache.disc.BaseDiscCache;
import com.nostra13.universalimageloader.cache.disc.naming.FileNameGenerator;
import com.nostra13.universalimageloader.core.DefaultConfigurationFactory;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class LimitedDiscCache
extends BaseDiscCache {
    private final AtomicInteger cacheSize;
    private final int sizeLimit;
    private final Map<File, Long> lastUsageDates = Collections.synchronizedMap(new HashMap());

    public LimitedDiscCache(File cacheDir, int sizeLimit) {
        this(cacheDir, DefaultConfigurationFactory.createFileNameGenerator(), sizeLimit);
    }

    public LimitedDiscCache(File cacheDir, FileNameGenerator fileNameGenerator, int sizeLimit) {
        super(cacheDir, fileNameGenerator);
        this.sizeLimit = sizeLimit;
        this.cacheSize = new AtomicInteger();
        this.calculateCacheSizeAndFillUsageMap();
    }

    private void calculateCacheSizeAndFillUsageMap() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                File[] cachedFiles;
                int size = 0;
                for (File cachedFile : cachedFiles = LimitedDiscCache.this.cacheDir.listFiles()) {
                    size += LimitedDiscCache.this.getSize(cachedFile);
                    LimitedDiscCache.this.lastUsageDates.put(cachedFile, cachedFile.lastModified());
                }
                LimitedDiscCache.this.cacheSize.set(size);
            }
        }).start();
    }

    @Override
    public void put(String key, File file) {
        int freedSize;
        int valueSize = this.getSize(file);
        int curCacheSize = this.cacheSize.get();
        while (curCacheSize + valueSize > this.sizeLimit && (freedSize = this.removeNext()) != 0) {
            curCacheSize = this.cacheSize.addAndGet(-freedSize);
        }
        this.cacheSize.addAndGet(valueSize);
        Long currentTime = System.currentTimeMillis();
        file.setLastModified(currentTime);
        this.lastUsageDates.put(file, currentTime);
    }

    @Override
    public File get(String key) {
        File file = super.get(key);
        Long currentTime = System.currentTimeMillis();
        file.setLastModified(currentTime);
        this.lastUsageDates.put(file, currentTime);
        return file;
    }

    @Override
    public void clear() {
        this.lastUsageDates.clear();
        this.cacheSize.set(0);
        super.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeNext() {
        if (this.lastUsageDates.isEmpty()) {
            return 0;
        }
        Long oldestUsage = null;
        File mostLongUsedFile = null;
        Set<Map.Entry<File, Long>> entries = this.lastUsageDates.entrySet();
        Map<File, Long> map = this.lastUsageDates;
        synchronized (map) {
            for (Map.Entry<File, Long> entry : entries) {
                if (mostLongUsedFile == null) {
                    mostLongUsedFile = entry.getKey();
                    oldestUsage = entry.getValue();
                    continue;
                }
                Long lastValueUsage = entry.getValue();
                if (lastValueUsage >= oldestUsage) continue;
                oldestUsage = lastValueUsage;
                mostLongUsedFile = entry.getKey();
            }
        }
        int fileSize = this.getSize(mostLongUsedFile);
        if (mostLongUsedFile.delete()) {
            this.lastUsageDates.remove(mostLongUsedFile);
        }
        return fileSize;
    }

    protected abstract int getSize(File var1);
}

