/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core;

import android.graphics.Bitmap;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.nostra13.universalimageloader.cache.disc.DiscCacheAware;
import com.nostra13.universalimageloader.cache.memory.MemoryCacheAware;
import com.nostra13.universalimageloader.core.DisplayImageOptions;
import com.nostra13.universalimageloader.core.ImageLoaderConfiguration;
import com.nostra13.universalimageloader.core.ImageLoaderEngine;
import com.nostra13.universalimageloader.core.ImageLoadingInfo;
import com.nostra13.universalimageloader.core.LoadAndDisplayImageTask;
import com.nostra13.universalimageloader.core.ProcessAndDisplayImageTask;
import com.nostra13.universalimageloader.core.assist.ImageLoadingListener;
import com.nostra13.universalimageloader.core.assist.ImageSize;
import com.nostra13.universalimageloader.core.assist.MemoryCacheUtil;
import com.nostra13.universalimageloader.core.assist.SimpleImageLoadingListener;
import com.nostra13.universalimageloader.core.display.BitmapDisplayer;
import com.nostra13.universalimageloader.core.display.FakeBitmapDisplayer;
import com.nostra13.universalimageloader.utils.ImageSizeUtils;
import com.nostra13.universalimageloader.utils.L;

public class ImageLoader {
    public static final String TAG = ImageLoader.class.getSimpleName();
    static final String LOG_INIT_CONFIG = "Initialize ImageLoader with configuration";
    static final String LOG_DESTROY = "Destroy ImageLoader";
    static final String LOG_WAITING_FOR_RESUME = "ImageLoader is paused. Waiting...  [%s]";
    static final String LOG_RESUME_AFTER_PAUSE = ".. Resume loading [%s]";
    static final String LOG_DELAY_BEFORE_LOADING = "Delay %d ms before loading...  [%s]";
    static final String LOG_START_DISPLAY_IMAGE_TASK = "Start display image task [%s]";
    static final String LOG_WAITING_FOR_IMAGE_LOADED = "Image already is loading. Waiting... [%s]";
    static final String LOG_GET_IMAGE_FROM_MEMORY_CACHE_AFTER_WAITING = "...Get cached bitmap from memory after waiting. [%s]";
    static final String LOG_LOAD_IMAGE_FROM_MEMORY_CACHE = "Load image from memory cache [%s]";
    static final String LOG_LOAD_IMAGE_FROM_NETWORK = "Load image from network [%s]";
    static final String LOG_LOAD_IMAGE_FROM_DISC_CACHE = "Load image from disc cache [%s]";
    static final String LOG_PREPROCESS_IMAGE = "PreProcess image before caching in memory [%s]";
    static final String LOG_POSTPROCESS_IMAGE = "PostProcess image before displaying [%s]";
    static final String LOG_CACHE_IMAGE_IN_MEMORY = "Cache image in memory [%s]";
    static final String LOG_CACHE_IMAGE_ON_DISC = "Cache image on disc [%s]";
    static final String LOG_DISPLAY_IMAGE_IN_IMAGEVIEW = "Display image in ImageView [%s]";
    static final String LOG_TASK_CANCELLED = "ImageView is reused for another image. Task is cancelled. [%s]";
    static final String LOG_TASK_INTERRUPTED = "Task was interrupted [%s]";
    private static final String WARNING_RE_INIT_CONFIG = "Try to initialize ImageLoader which had already been initialized before. To re-init ImageLoader with new configuration call ImageLoader.destroy() at first.";
    private static final String ERROR_WRONG_ARGUMENTS = "Wrong arguments were passed to displayImage() method (ImageView reference must not be null)";
    private static final String ERROR_NOT_INIT = "ImageLoader must be init with configuration before using";
    private static final String ERROR_INIT_CONFIG_WITH_NULL = "ImageLoader configuration can not be initialized with null";
    private ImageLoaderConfiguration configuration;
    private ImageLoaderEngine engine;
    private final ImageLoadingListener emptyListener = new SimpleImageLoadingListener();
    private final BitmapDisplayer fakeBitmapDisplayer = new FakeBitmapDisplayer();
    private static volatile ImageLoader instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImageLoader getInstance() {
        if (instance != null) return instance;
        Class<ImageLoader> clazz = ImageLoader.class;
        synchronized (ImageLoader.class) {
            if (instance != null) return instance;
            instance = new ImageLoader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected ImageLoader() {
    }

    public synchronized void init(ImageLoaderConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(ERROR_INIT_CONFIG_WITH_NULL);
        }
        if (this.configuration == null) {
            if (configuration.loggingEnabled) {
                L.d(LOG_INIT_CONFIG, new Object[0]);
            }
            this.engine = new ImageLoaderEngine(configuration);
            this.configuration = configuration;
        } else {
            L.w(WARNING_RE_INIT_CONFIG, new Object[0]);
        }
    }

    public boolean isInited() {
        return this.configuration != null;
    }

    public void displayImage(String uri, ImageView imageView) {
        this.displayImage(uri, imageView, null, null);
    }

    public void displayImage(String uri, ImageView imageView, DisplayImageOptions options) {
        this.displayImage(uri, imageView, options, null);
    }

    public void displayImage(String uri, ImageView imageView, ImageLoadingListener listener) {
        this.displayImage(uri, imageView, null, listener);
    }

    public void displayImage(String uri, ImageView imageView, DisplayImageOptions options, ImageLoadingListener listener) {
        this.checkConfiguration();
        if (imageView == null) {
            throw new IllegalArgumentException(ERROR_WRONG_ARGUMENTS);
        }
        if (listener == null) {
            listener = this.emptyListener;
        }
        if (options == null) {
            options = this.configuration.defaultDisplayImageOptions;
        }
        if (uri == null || uri.length() == 0) {
            this.engine.cancelDisplayTaskFor(imageView);
            listener.onLoadingStarted(uri, (View)imageView);
            if (options.shouldShowImageForEmptyUri()) {
                imageView.setImageResource(options.getImageForEmptyUri());
            } else {
                imageView.setImageBitmap(null);
            }
            listener.onLoadingComplete(uri, (View)imageView, null);
            return;
        }
        ImageSize targetSize = ImageSizeUtils.defineTargetSizeForView(imageView, this.configuration.maxImageWidthForMemoryCache, this.configuration.maxImageHeightForMemoryCache);
        String memoryCacheKey = MemoryCacheUtil.generateKey(uri, targetSize);
        this.engine.prepareDisplayTaskFor(imageView, memoryCacheKey);
        listener.onLoadingStarted(uri, (View)imageView);
        Bitmap bmp = this.configuration.memoryCache.get(memoryCacheKey);
        if (bmp != null && !bmp.isRecycled()) {
            if (this.configuration.loggingEnabled) {
                L.i(LOG_LOAD_IMAGE_FROM_MEMORY_CACHE, memoryCacheKey);
            }
            if (options.shouldPostProcess()) {
                ImageLoadingInfo imageLoadingInfo = new ImageLoadingInfo(uri, imageView, targetSize, options, listener, this.engine.getLockForUri(uri));
                ProcessAndDisplayImageTask displayTask = new ProcessAndDisplayImageTask(this.engine, bmp, imageLoadingInfo, new Handler());
                this.engine.submit(displayTask);
            } else {
                options.getDisplayer().display(bmp, imageView);
                listener.onLoadingComplete(uri, (View)imageView, bmp);
            }
        } else {
            if (options.shouldShowStubImage()) {
                imageView.setImageResource(options.getStubImage());
            } else if (options.isResetViewBeforeLoading()) {
                imageView.setImageBitmap(null);
            }
            ImageLoadingInfo imageLoadingInfo = new ImageLoadingInfo(uri, imageView, targetSize, options, listener, this.engine.getLockForUri(uri));
            LoadAndDisplayImageTask displayTask = new LoadAndDisplayImageTask(this.engine, imageLoadingInfo, new Handler());
            this.engine.submit(displayTask);
        }
    }

    public void loadImage(String uri, ImageLoadingListener listener) {
        this.loadImage(uri, null, null, listener);
    }

    public void loadImage(String uri, ImageSize minImageSize, ImageLoadingListener listener) {
        this.loadImage(uri, minImageSize, null, listener);
    }

    public void loadImage(String uri, DisplayImageOptions options, ImageLoadingListener listener) {
        this.loadImage(uri, null, options, listener);
    }

    public void loadImage(String uri, ImageSize targetImageSize, DisplayImageOptions options, ImageLoadingListener listener) {
        this.checkConfiguration();
        if (targetImageSize == null) {
            targetImageSize = new ImageSize(this.configuration.maxImageWidthForMemoryCache, this.configuration.maxImageHeightForMemoryCache);
        }
        if (options == null) {
            options = this.configuration.defaultDisplayImageOptions;
        }
        DisplayImageOptions optionsWithFakeDisplayer = options.getDisplayer() instanceof FakeBitmapDisplayer ? options : new DisplayImageOptions.Builder().cloneFrom(options).displayer(this.fakeBitmapDisplayer).build();
        ImageView fakeImage = new ImageView(this.configuration.context);
        fakeImage.setLayoutParams(new ViewGroup.LayoutParams(targetImageSize.getWidth(), targetImageSize.getHeight()));
        fakeImage.setScaleType(ImageView.ScaleType.CENTER_CROP);
        this.displayImage(uri, fakeImage, optionsWithFakeDisplayer, listener);
    }

    private void checkConfiguration() {
        if (this.configuration == null) {
            throw new IllegalStateException(ERROR_NOT_INIT);
        }
    }

    public MemoryCacheAware<String, Bitmap> getMemoryCache() {
        this.checkConfiguration();
        return this.configuration.memoryCache;
    }

    public void clearMemoryCache() {
        this.checkConfiguration();
        this.configuration.memoryCache.clear();
    }

    public DiscCacheAware getDiscCache() {
        this.checkConfiguration();
        return this.configuration.discCache;
    }

    public void clearDiscCache() {
        this.checkConfiguration();
        this.configuration.discCache.clear();
    }

    public String getLoadingUriForView(ImageView imageView) {
        return this.engine.getLoadingUriForView(imageView);
    }

    public void cancelDisplayTask(ImageView imageView) {
        this.engine.cancelDisplayTaskFor(imageView);
    }

    public void denyNetworkDownloads(boolean denyNetworkDownloads) {
        this.engine.denyNetworkDownloads(denyNetworkDownloads);
    }

    public void handleSlowNetwork(boolean handleSlowNetwork) {
        this.engine.handleSlowNetwork(handleSlowNetwork);
    }

    public void pause() {
        this.engine.pause();
    }

    public void resume() {
        this.engine.resume();
    }

    public void stop() {
        this.engine.stop();
    }

    public void destroy() {
        if (this.configuration != null && this.configuration.loggingEnabled) {
            L.d(LOG_DESTROY, new Object[0]);
        }
        this.stop();
        this.engine = null;
        this.configuration = null;
    }
}

