/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core;

import android.graphics.Bitmap;
import android.os.Handler;
import com.nostra13.universalimageloader.core.DisplayBitmapTask;
import com.nostra13.universalimageloader.core.ImageLoaderEngine;
import com.nostra13.universalimageloader.core.ImageLoadingInfo;
import com.nostra13.universalimageloader.core.process.BitmapProcessor;
import com.nostra13.universalimageloader.utils.L;

class ProcessAndDisplayImageTask
implements Runnable {
    private final ImageLoaderEngine engine;
    private final Bitmap bitmap;
    private final ImageLoadingInfo imageLoadingInfo;
    private final Handler handler;

    public ProcessAndDisplayImageTask(ImageLoaderEngine engine, Bitmap bitmap, ImageLoadingInfo imageLoadingInfo, Handler handler) {
        this.engine = engine;
        this.bitmap = bitmap;
        this.imageLoadingInfo = imageLoadingInfo;
        this.handler = handler;
    }

    @Override
    public void run() {
        BitmapProcessor processor;
        Bitmap processedBitmap;
        if (this.engine.configuration.loggingEnabled) {
            L.i("PostProcess image before displaying [%s]", this.imageLoadingInfo.memoryCacheKey);
        }
        if ((processedBitmap = (processor = this.imageLoadingInfo.options.getPostProcessor()).process(this.bitmap)) != this.bitmap) {
            this.bitmap.recycle();
        }
        this.handler.post((Runnable)new DisplayBitmapTask(processedBitmap, this.imageLoadingInfo, this.engine));
    }
}

