/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core.assist;

import android.graphics.Bitmap;
import com.nostra13.universalimageloader.cache.memory.MemoryCacheAware;
import com.nostra13.universalimageloader.core.assist.ImageSize;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public final class MemoryCacheUtil {
    private static final String URI_AND_SIZE_SEPARATOR = "_";
    private static final String MEMORY_CACHE_KEY_FORMAT = "%1$s_%2$s";

    private MemoryCacheUtil() {
    }

    public static String generateKey(String imageUri, ImageSize targetSize) {
        return String.format(MEMORY_CACHE_KEY_FORMAT, imageUri, targetSize);
    }

    public static Comparator<String> createFuzzyKeyComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String key1, String key2) {
                String imageUri1 = key1.substring(0, key1.lastIndexOf(MemoryCacheUtil.URI_AND_SIZE_SEPARATOR));
                String imageUri2 = key2.substring(0, key2.lastIndexOf(MemoryCacheUtil.URI_AND_SIZE_SEPARATOR));
                return imageUri1.compareTo(imageUri2);
            }
        };
    }

    public static List<Bitmap> findCachedBitmapsForImageUri(String imageUri, MemoryCacheAware<String, Bitmap> memoryCache) {
        ArrayList<Bitmap> values = new ArrayList<Bitmap>();
        for (String key : memoryCache.keys()) {
            if (!key.startsWith(imageUri)) continue;
            values.add(memoryCache.get(key));
        }
        return values;
    }

    public static List<String> findCacheKeysForImageUri(String imageUri, MemoryCacheAware<String, Bitmap> memoryCache) {
        ArrayList<String> values = new ArrayList<String>();
        for (String key : memoryCache.keys()) {
            if (!key.startsWith(imageUri)) continue;
            values.add(key);
        }
        return values;
    }

    public static void removeFromCache(String imageUri, MemoryCacheAware<String, Bitmap> memoryCache) {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (String key : memoryCache.keys()) {
            if (!key.startsWith(imageUri)) continue;
            keysToRemove.add(key);
        }
        for (String keyToRemove : keysToRemove) {
            memoryCache.remove(keyToRemove);
        }
    }
}

