/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core.display;

import android.graphics.Bitmap;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import com.nostra13.universalimageloader.core.display.BitmapDisplayer;

public class FadeInBitmapDisplayer
implements BitmapDisplayer {
    private final int durationMillis;

    public FadeInBitmapDisplayer(int durationMillis) {
        this.durationMillis = durationMillis;
    }

    @Override
    public Bitmap display(Bitmap bitmap, ImageView imageView) {
        imageView.setImageBitmap(bitmap);
        FadeInBitmapDisplayer.animate(imageView, this.durationMillis);
        return bitmap;
    }

    public static void animate(ImageView imageView, int durationMillis) {
        AlphaAnimation fadeImage = new AlphaAnimation(0.0f, 1.0f);
        fadeImage.setDuration((long)durationMillis);
        fadeImage.setInterpolator((Interpolator)new DecelerateInterpolator());
        imageView.startAnimation((Animation)fadeImage);
    }
}

