/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.utils;

import android.util.DisplayMetrics;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.nostra13.universalimageloader.core.assist.ImageSize;
import com.nostra13.universalimageloader.core.assist.ViewScaleType;
import com.nostra13.universalimageloader.utils.L;
import java.lang.reflect.Field;

public final class ImageSizeUtils {
    private ImageSizeUtils() {
    }

    public static ImageSize defineTargetSizeForView(ImageView imageView, int maxImageWidth, int maxImageHeight) {
        int height;
        int width;
        DisplayMetrics displayMetrics = imageView.getContext().getResources().getDisplayMetrics();
        ViewGroup.LayoutParams params = imageView.getLayoutParams();
        int n = width = params.width == -2 ? 0 : imageView.getWidth();
        if (width <= 0) {
            width = params.width;
        }
        if (width <= 0) {
            width = ImageSizeUtils.getImageViewFieldValue(imageView, "mMaxWidth");
        }
        if (width <= 0) {
            width = maxImageWidth;
        }
        if (width <= 0) {
            width = displayMetrics.widthPixels;
        }
        int n2 = height = params.height == -2 ? 0 : imageView.getHeight();
        if (height <= 0) {
            height = params.height;
        }
        if (height <= 0) {
            height = ImageSizeUtils.getImageViewFieldValue(imageView, "mMaxHeight");
        }
        if (height <= 0) {
            height = maxImageHeight;
        }
        if (height <= 0) {
            height = displayMetrics.heightPixels;
        }
        return new ImageSize(width, height);
    }

    private static int getImageViewFieldValue(Object object, String fieldName) {
        int value = 0;
        try {
            Field field = ImageView.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            int fieldValue = (Integer)field.get(object);
            if (fieldValue > 0 && fieldValue < Integer.MAX_VALUE) {
                value = fieldValue;
            }
        }
        catch (Exception e) {
            L.e(e);
        }
        return value;
    }

    public static int computeImageSampleSize(ImageSize srcSize, ImageSize targetSize, ViewScaleType viewScaleType, boolean powerOf2Scale) {
        int srcWidth = srcSize.getWidth();
        int srcHeight = srcSize.getHeight();
        int targetWidth = targetSize.getWidth();
        int targetHeight = targetSize.getHeight();
        int scale = 1;
        int widthScale = srcWidth / targetWidth;
        int heightScale = srcHeight / targetHeight;
        switch (viewScaleType) {
            case FIT_INSIDE: {
                if (powerOf2Scale) {
                    while (srcWidth / 2 >= targetWidth || srcHeight / 2 >= targetHeight) {
                        srcWidth /= 2;
                        srcHeight /= 2;
                        scale *= 2;
                    }
                    break;
                }
                scale = Math.max(widthScale, heightScale);
                break;
            }
            case CROP: {
                if (powerOf2Scale) {
                    while (srcWidth / 2 >= targetWidth && srcHeight / 2 >= targetHeight) {
                        srcWidth /= 2;
                        srcHeight /= 2;
                        scale *= 2;
                    }
                    break;
                }
                scale = Math.min(widthScale, heightScale);
            }
        }
        if (scale < 1) {
            scale = 1;
        }
        return scale;
    }

    public static float computeImageScale(ImageSize srcSize, ImageSize targetSize, ViewScaleType viewScaleType, boolean stretch) {
        int destHeight;
        int destWidth;
        int srcWidth = srcSize.getWidth();
        int srcHeight = srcSize.getHeight();
        int targetWidth = targetSize.getWidth();
        int targetHeight = targetSize.getHeight();
        float widthScale = (float)srcWidth / (float)targetWidth;
        float heightScale = (float)srcHeight / (float)targetHeight;
        if (viewScaleType == ViewScaleType.FIT_INSIDE && widthScale >= heightScale || viewScaleType == ViewScaleType.CROP && widthScale < heightScale) {
            destWidth = targetWidth;
            destHeight = (int)((float)srcHeight / widthScale);
        } else {
            destWidth = (int)((float)srcWidth / heightScale);
            destHeight = targetHeight;
        }
        float scale = 1.0f;
        if (!stretch && destWidth < srcWidth && destHeight < srcHeight || stretch && destWidth != srcWidth && destHeight != srcHeight) {
            scale = (float)destWidth / (float)srcWidth;
        }
        return scale;
    }
}

