/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core;

import android.graphics.Bitmap;
import android.view.View;
import android.widget.ImageView;
import com.nostra13.universalimageloader.core.ImageLoaderEngine;
import com.nostra13.universalimageloader.core.ImageLoadingInfo;
import com.nostra13.universalimageloader.core.assist.ImageLoadingListener;
import com.nostra13.universalimageloader.core.assist.LoadedFrom;
import com.nostra13.universalimageloader.core.display.BitmapDisplayer;
import com.nostra13.universalimageloader.utils.L;

final class DisplayBitmapTask
implements Runnable {
    private static final String LOG_DISPLAY_IMAGE_IN_IMAGEVIEW = "Display image in ImageView (loaded from %1$s) [%2$s]";
    private static final String LOG_TASK_CANCELLED = "ImageView is reused for another image. Task is cancelled. [%s]";
    private final Bitmap bitmap;
    private final String imageUri;
    private final ImageView imageView;
    private final String memoryCacheKey;
    private final BitmapDisplayer displayer;
    private final ImageLoadingListener listener;
    private final ImageLoaderEngine engine;
    private final LoadedFrom loadedFrom;
    private boolean loggingEnabled;

    public DisplayBitmapTask(Bitmap bitmap, ImageLoadingInfo imageLoadingInfo, ImageLoaderEngine engine, LoadedFrom loadedFrom) {
        this.bitmap = bitmap;
        this.imageUri = imageLoadingInfo.uri;
        this.imageView = imageLoadingInfo.imageView;
        this.memoryCacheKey = imageLoadingInfo.memoryCacheKey;
        this.displayer = imageLoadingInfo.options.getDisplayer();
        this.listener = imageLoadingInfo.listener;
        this.engine = engine;
        this.loadedFrom = loadedFrom;
    }

    @Override
    public void run() {
        if (this.isViewWasReused()) {
            if (this.loggingEnabled) {
                L.i(LOG_TASK_CANCELLED, this.memoryCacheKey);
            }
            this.listener.onLoadingCancelled(this.imageUri, (View)this.imageView);
        } else {
            if (this.loggingEnabled) {
                L.i(LOG_DISPLAY_IMAGE_IN_IMAGEVIEW, new Object[]{this.loadedFrom, this.memoryCacheKey});
            }
            Bitmap displayedBitmap = this.displayer.display(this.bitmap, this.imageView, this.loadedFrom);
            this.listener.onLoadingComplete(this.imageUri, (View)this.imageView, displayedBitmap);
            this.engine.cancelDisplayTaskFor(this.imageView);
        }
    }

    private boolean isViewWasReused() {
        String currentCacheKey = this.engine.getLoadingUriForView(this.imageView);
        return !this.memoryCacheKey.equals(currentCacheKey);
    }

    void setLoggingEnabled(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
    }
}

