/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPSchema;
import com.novell.ldap.LDAPSchemaElement;
import com.novell.ldap.client.AttributeQualifier;
import com.novell.ldap.client.SchemaParser;
import com.novell.ldap.util.LDAPXMLHandler;
import com.novell.ldap.util.SAXEventMultiplexer;
import com.novell.ldap.util.ValueXMLhandler;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LDAPAttributeSchema
extends LDAPSchemaElement {
    private String syntaxString;
    private boolean single = false;
    private String superior;
    private String equality;
    private String ordering;
    private String substring;
    private boolean collective = false;
    private boolean userMod = true;
    private int usage = 0;
    public static final int USER_APPLICATIONS = 0;
    public static final int DIRECTORY_OPERATION = 1;
    public static final int DISTRIBUTED_OPERATION = 2;
    public static final int DSA_OPERATION = 3;

    public LDAPAttributeSchema() {
        super(LDAPSchema.schemaTypeNames[0]);
    }

    public LDAPAttributeSchema(String[] names, String oid, String description, String syntaxString, boolean single, String superior, boolean obsolete, String equality, String ordering, String substring, boolean collective, boolean isUserModifiable, int usage) {
        super(LDAPSchema.schemaTypeNames[0]);
        this.names = names;
        this.oid = oid;
        this.description = description;
        this.obsolete = obsolete;
        this.syntaxString = syntaxString;
        this.single = single;
        this.equality = equality;
        this.ordering = ordering;
        this.substring = substring;
        this.collective = collective;
        this.userMod = isUserModifiable;
        this.usage = usage;
        this.superior = superior;
        super.setValue(this.formatString());
    }

    public LDAPAttributeSchema(String raw) {
        super(LDAPSchema.schemaTypeNames[0]);
        try {
            SchemaParser parser = new SchemaParser(raw);
            if (parser.getNames() != null) {
                this.names = parser.getNames();
            }
            if (parser.getID() != null) {
                this.oid = parser.getID();
            }
            if (parser.getDescription() != null) {
                this.description = parser.getDescription();
            }
            if (parser.getSyntax() != null) {
                this.syntaxString = parser.getSyntax();
            }
            if (parser.getSuperior() != null) {
                this.superior = parser.getSuperior();
            }
            this.userMod = parser.getUserMod();
            this.single = parser.getSingle();
            this.obsolete = parser.getObsolete();
            Enumeration qualifiers = parser.getQualifiers();
            while (qualifiers.hasMoreElements()) {
                AttributeQualifier attrQualifier = (AttributeQualifier)qualifiers.nextElement();
                this.setQualifier(attrQualifier.getName(), attrQualifier.getValues());
            }
            if (parser.getEquality() != null) {
                this.equality = parser.getEquality();
            }
            if (parser.getOrdering() != null) {
                this.ordering = parser.getOrdering();
            }
            if (parser.getSubstring() != null) {
                this.substring = parser.getSubstring();
            }
            super.setValue(this.formatString());
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public String getSyntaxString() {
        return this.syntaxString;
    }

    public String getSuperior() {
        return this.superior;
    }

    public boolean isSingleValued() {
        return this.single;
    }

    public String getEqualityMatchingRule() {
        return this.equality;
    }

    public String getOrderingMatchingRule() {
        return this.ordering;
    }

    public String getSubstringMatchingRule() {
        return this.substring;
    }

    public boolean isCollective() {
        return this.collective;
    }

    public boolean isUserModifiable() {
        return this.userMod;
    }

    public int getUsage() {
        return this.usage;
    }

    protected String formatString() {
        int useType;
        String[] strArray;
        StringBuffer valueBuffer = new StringBuffer("( ");
        String token = this.getID();
        if (token != null) {
            valueBuffer.append(token);
        }
        if ((strArray = this.getNames()) != null) {
            valueBuffer.append(" NAME ");
            if (strArray.length == 1) {
                valueBuffer.append("'" + strArray[0] + "'");
            } else {
                valueBuffer.append("( ");
                for (int i = 0; i < strArray.length; ++i) {
                    valueBuffer.append(" '" + strArray[i] + "'");
                }
                valueBuffer.append(" )");
            }
        }
        if ((token = this.getDescription()) != null) {
            valueBuffer.append(" DESC ");
            valueBuffer.append("'" + token + "'");
        }
        if (this.isObsolete()) {
            valueBuffer.append(" OBSOLETE");
        }
        if ((token = this.getSuperior()) != null) {
            valueBuffer.append(" SUP ");
            valueBuffer.append("'" + token + "'");
        }
        if ((token = this.getEqualityMatchingRule()) != null) {
            valueBuffer.append(" EQUALITY ");
            valueBuffer.append("'" + token + "'");
        }
        if ((token = this.getOrderingMatchingRule()) != null) {
            valueBuffer.append(" ORDERING ");
            valueBuffer.append("'" + token + "'");
        }
        if ((token = this.getSubstringMatchingRule()) != null) {
            valueBuffer.append(" SUBSTR ");
            valueBuffer.append("'" + token + "'");
        }
        if ((token = this.getSyntaxString()) != null) {
            valueBuffer.append(" SYNTAX ");
            valueBuffer.append(token);
        }
        if (this.isSingleValued()) {
            valueBuffer.append(" SINGLE-VALUE");
        }
        if (this.isCollective()) {
            valueBuffer.append(" COLLECTIVE");
        }
        if (!this.isUserModifiable()) {
            valueBuffer.append(" NO-USER-MODIFICATION");
        }
        if ((useType = this.getUsage()) != 0) {
            switch (useType) {
                case 1: {
                    valueBuffer.append(" USAGE directoryOperation");
                    break;
                }
                case 2: {
                    valueBuffer.append(" USAGE distributedOperation");
                    break;
                }
                case 3: {
                    valueBuffer.append(" USAGE dSAOperation");
                    break;
                }
            }
        }
        Enumeration en = this.getQualifierNames();
        while (en.hasMoreElements()) {
            token = (String)en.nextElement();
            if (token == null) continue;
            valueBuffer.append(" " + token);
            strArray = this.getQualifier(token);
            if (strArray == null) continue;
            if (strArray.length > 1) {
                valueBuffer.append("(");
            }
            for (int i = 0; i < strArray.length; ++i) {
                valueBuffer.append(" '" + strArray[i] + "'");
            }
            if (strArray.length <= 1) continue;
            valueBuffer.append(" )");
        }
        valueBuffer.append(" )");
        return valueBuffer.toString();
    }

    protected void setDeserializedValues(BufferedInputStream istream) throws IOException {
        LDAPAttributeSchema readObject = (LDAPAttributeSchema)LDAPAttributeSchema.readDSML(istream);
        this.oid = readObject.getID();
        this.names = readObject.getNames();
        this.description = readObject.getDescription();
        this.obsolete = readObject.isObsolete();
        Enumeration enumer = readObject.getQualifierNames();
        while (enumer.hasMoreElements()) {
            String xname = (String)enumer.nextElement();
            String[] qualifierVals = readObject.getQualifier(xname);
            this.setQualifier(xname, qualifierVals);
        }
        this.collective = readObject.isCollective();
        this.equality = readObject.getEqualityMatchingRule();
        this.ordering = readObject.getOrderingMatchingRule();
        this.single = readObject.isSingleValued();
        this.substring = readObject.getSubstringMatchingRule();
        this.superior = readObject.getSuperior();
        this.syntaxString = readObject.getSyntaxString();
        this.usage = readObject.getUsage();
        this.userMod = readObject.isUserModifiable();
        super.setValue(this.formatString());
        readObject = null;
    }

    protected void writeValue(Writer out) throws IOException {
        String value = this.formatString();
        out.write(ValueXMLhandler.newLine(2));
        out.write("<value>");
        out.write(value);
        out.write("</value>");
    }

    protected void writeValue(StringBuffer buff) {
        String value = this.formatString();
        buff.append(ValueXMLhandler.newLine(2));
        buff.append("<value>");
        buff.append(value);
        buff.append("</value>");
    }

    public static Object readDSML(InputStream input) throws IOException {
        SAXEventMultiplexer xmlreader = new SAXEventMultiplexer();
        xmlreader.setLDAPXMLHandler(LDAPAttributeSchema.getTopXMLHandler("LDAPAttribute", null));
        return (LDAPAttributeSchema)xmlreader.parseXML(input);
    }

    private static LDAPXMLHandler getTopXMLHandler(String tagname, LDAPXMLHandler parenthandler) {
        return new LDAPXMLHandler(tagname, parenthandler){
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(LDAPAttributeSchema.getXMLHandler("attr", this));
            }

            protected void endElement() {
                this.setObject((LDAPAttributeSchema)this.valuelist.get(0));
            }

            protected void addValue(String tag, Object value) {
                if (tag.equals("attr")) {
                    this.valuelist.add(value);
                }
            }
        };
    }

    static LDAPXMLHandler getXMLHandler(String tagname, LDAPXMLHandler parenthandler) {
        return new LDAPXMLHandler(tagname, parenthandler){
            String attrName;
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(new ValueXMLhandler(this));
            }

            protected void endElement() {
                Iterator valueiterator = this.valuelist.iterator();
                LDAPAttributeSchema attr = new LDAPAttributeSchema(this.attrName);
                byte[] temp = (byte[])valueiterator.next();
                StringBuffer bf = new StringBuffer(temp.length);
                for (int i = 0; i < temp.length; ++i) {
                    bf.append((char)temp[i]);
                }
                try {
                    SchemaParser parser = new SchemaParser(bf.toString());
                    if (parser.getNames() != null) {
                        attr.names = parser.getNames();
                    }
                    if (parser.getID() != null) {
                        attr.oid = parser.getID();
                    }
                    if (parser.getDescription() != null) {
                        attr.description = parser.getDescription();
                    }
                    if (parser.getSyntax() != null) {
                        attr.syntaxString = parser.getSyntax();
                    }
                    if (parser.getSuperior() != null) {
                        attr.superior = parser.getSuperior();
                    }
                    attr.single = parser.getSingle();
                    attr.obsolete = parser.getObsolete();
                    Enumeration qualifiers = parser.getQualifiers();
                    while (qualifiers.hasMoreElements()) {
                        AttributeQualifier attrQualifier = (AttributeQualifier)qualifiers.nextElement();
                        attr.setQualifier(attrQualifier.getName(), attrQualifier.getValues());
                    }
                    if (parser.getEquality() != null) {
                        attr.equality = parser.getEquality();
                    }
                    if (parser.getOrdering() != null) {
                        attr.ordering = parser.getOrdering();
                    }
                    if (parser.getSubstring() != null) {
                        attr.substring = parser.getSubstring();
                    }
                    attr.setValue(attr.formatString());
                }
                catch (IOException e) {
                    throw new RuntimeException(e.toString());
                }
                this.setObject(attr);
                this.valuelist.clear();
            }

            protected void addValue(String tag, Object value) {
                if (tag.equals("value")) {
                    this.valuelist.add(value);
                }
            }

            protected void handleAttributes(Attributes attributes) throws SAXException {
                this.attrName = attributes.getValue("name");
                if (this.attrName == null) {
                    throw new SAXException("invalid attr Tag, name is mandatory element: ");
                }
            }
        };
    }
}

