/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.Connection;
import com.novell.ldap.LDAPConstraints;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPMessageQueue;
import com.novell.ldap.Message;
import com.novell.ldap.MessageVector;
import com.novell.ldap.client.BindProperties;
import com.novell.ldap.client.Debug;

class MessageAgent {
    private MessageVector messages = new MessageVector(5, 5);
    private int indexLastRead = 0;
    private static Object nameLock = new Object();
    private static int agentNum = 0;
    private String name;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MessageAgent() {
        Object object = nameLock;
        synchronized (object) {
            this.name = "MessageAgent(" + ++agentNum + "): ";
        }
        Debug.trace("Messages", this.name + "Created");
    }

    Object[] getMessageArray() {
        return this.messages.getObjectArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void merge(MessageAgent fromAgent) {
        Object[] msgs = fromAgent.getMessageArray();
        for (int i = 0; i < msgs.length; ++i) {
            this.messages.addElement(msgs[i]);
            ((Message)msgs[i]).setAgent(this);
            Message info = (Message)msgs[i];
            Debug.trace("Messages", this.name + "Merging Message(" + info.getMessageID() + "), total " + this.messages.size());
        }
        MessageVector messageVector = this.messages;
        synchronized (messageVector) {
            Debug.trace("Messages", this.name + "Messages in queue");
            this.debugDisplayMessages();
            if (msgs.length > 1) {
                this.messages.notifyAll();
            } else if (msgs.length == 1) {
                this.messages.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void sleepersAwake(boolean all) {
        MessageVector messageVector = this.messages;
        synchronized (messageVector) {
            if (all) {
                this.messages.notifyAll();
            } else {
                this.messages.notify();
            }
        }
    }

    final boolean isResponseReceived() {
        int size = this.messages.size();
        int next = this.indexLastRead + 1;
        for (int i = 0; i < size; ++i) {
            Message info;
            if (next == size) {
                next = 0;
            }
            if (!(info = (Message)this.messages.elementAt(next)).hasReplies()) continue;
            return true;
        }
        return false;
    }

    final boolean isResponseReceived(int msgId) {
        try {
            Message info = this.messages.findMessageById(msgId);
            return info.hasReplies();
        }
        catch (NoSuchFieldException ex) {
            return false;
        }
    }

    final void abandon(int msgId, LDAPConstraints cons) {
        Message info = null;
        try {
            info = this.messages.findMessageById(msgId);
            this.messages.removeElement(info);
            info.abandon(cons, null);
            Debug.trace("Messages", this.name + "abandon: Removed abandoned Message(" + info.getMessageID() + ")" + " Messages in queue");
            this.debugDisplayMessages();
            return;
        }
        catch (NoSuchFieldException ex) {
            Debug.trace("Messages", this.name + "Abandon of Message(" + msgId + ") failed");
            return;
        }
    }

    final void abandonAll() {
        int size = this.messages.size();
        for (int i = 0; i < size; ++i) {
            Message info = (Message)this.messages.elementAt(i);
            Debug.trace("Messages", this.name + "abandonAll: Removing abandoned Message(" + info.getMessageID() + ")");
            this.messages.removeElement(info);
            info.abandon(null, null);
        }
        Debug.trace("Messages", this.name + "Messages in queue");
        this.debugDisplayMessages();
    }

    final int[] getMessageIDs() {
        int size = this.messages.size();
        int[] ids = new int[size];
        for (int i = 0; i < size; ++i) {
            Message info = (Message)this.messages.elementAt(i);
            ids[i] = info.getMessageID();
        }
        return ids;
    }

    final boolean isComplete(int msgid) {
        try {
            Message info = this.messages.findMessageById(msgid);
            if (!info.isComplete()) {
                return false;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return true;
    }

    final Message getMessage(int msgid) throws NoSuchFieldException {
        return this.messages.findMessageById(msgid);
    }

    final void sendMessage(Connection conn, LDAPMessage msg, int timeOut, LDAPMessageQueue queue, BindProperties bindProps) throws LDAPException {
        Message message = new Message(msg, timeOut, conn, this, queue, bindProps);
        this.messages.addElement(message);
        Debug.trace("Messages", this.name + "sendMessage: Added new Message(" + message.getMessageID() + ")");
        this.debugDisplayMessages();
        message.sendMessage();
    }

    final Object getLDAPMessage(Integer msgId) {
        Debug.trace("Messages", this.name + "getLDAPMessage(" + msgId + "), " + this.messages.size() + " messages active");
        if (this.messages.size() == 0) {
            return null;
        }
        if (msgId != null) {
            try {
                Message info = this.messages.findMessageById(msgId);
                Object rfcMsg = info.waitForReply();
                if (!info.acceptsReplies() && !info.hasReplies()) {
                    this.messages.removeElement(info);
                    Debug.trace("Messages", this.name + "getLDAPMessage: By ID Return Last Message(" + info.getMessageID() + ")");
                    this.debugDisplayMessages();
                    info.abandon(null, null);
                } else {
                    Debug.trace("Messages", this.name + "getLDAPMessage: By ID Return Message(" + info.getMessageID() + ")");
                    this.debugDisplayMessages();
                }
                return rfcMsg;
            }
            catch (NoSuchFieldException ex) {
                return null;
            }
        }
        MessageVector messageVector = this.messages;
        synchronized (messageVector) {
            block7: while (true) {
                while (true) {
                    Debug.trace("Messages", this.name + "getLDAPMessage: Look for any reply, " + this.messages.size() + " messages active");
                    int next = this.indexLastRead + 1;
                    for (int i = 0; i < this.messages.size(); ++i) {
                        if (next >= this.messages.size()) {
                            next = 0;
                        }
                        Message info = (Message)this.messages.elementAt(next);
                        this.indexLastRead = next++;
                        Object rfcMsg = info.getReply();
                        if (!info.acceptsReplies() && !info.hasReplies()) {
                            Debug.trace("Messages", this.name + "getLDAPMessage: cleanup Message(" + info.getMessageID() + ")");
                            this.messages.removeElement(info);
                            info.abandon(null, null);
                            --i;
                        }
                        if (rfcMsg != null) {
                            Debug.trace("Messages", this.name + "getLDAPMessage: Return response to Message(" + info.getMessageID() + ")");
                            this.debugDisplayMessages();
                            return rfcMsg;
                        }
                        Debug.trace("Messages", this.name + "getLDAPMessage: no messages queued for Message(" + info.getMessageID() + ")");
                    }
                    if (this.messages.size() == 0) {
                        return null;
                    }
                    try {
                        Debug.trace("Messages", this.name + "getLDAPMessage: waiting for incoming messages");
                        this.messages.wait();
                        Debug.trace("Messages", this.name + "getLDAPMessage: wake up from wait");
                        continue block7;
                    }
                    catch (InterruptedException ex) {
                        Debug.trace("Messages", this.name + "getLDAPMessage: interrupted up from wait");
                        continue;
                    }
                    break;
                }
            }
        }
    }

    String getAgentName() {
        return this.name;
    }

    int getCount() {
        int count = 0;
        Object[] msgs = this.messages.toArray();
        for (int i = 0; i < msgs.length; ++i) {
            Message m = (Message)msgs[i];
            count += m.getCount();
        }
        return count;
    }

    private void debugDisplayMessages() {
        Object[] dbgmsgs = this.messages.toArray();
        Debug.trace("Messages", this.name + "Queue Status");
        if (dbgmsgs.length == 0) {
            Debug.trace("Messages", this.name + "\t" + "No messages queued");
        }
        for (int i = 0; i < dbgmsgs.length; ++i) {
            Message m = (Message)dbgmsgs[i];
            Debug.trace("Messages", this.name + "\t" + i + ".: Message(" + m.getMessageID() + ")");
        }
    }
}

