/*
 * Decompiled with CFR 0.152.
 */
package com.novocode.junit;

import com.novocode.junit.Ansi;
import com.novocode.junit.RunSettings;
import java.util.Stack;
import org.scalatools.testing.Logger;

final class RichLogger {
    private final Logger[] loggers;
    private final RunSettings settings;
    private final Stack<String> currentTestClassName = new Stack();

    RichLogger(Logger[] loggers, RunSettings settings, String testClassName) {
        this.loggers = loggers;
        this.settings = settings;
        this.currentTestClassName.push(testClassName);
    }

    void pushCurrentTestClassName(String s) {
        this.currentTestClassName.push(s);
    }

    void popCurrentTestClassName() {
        if (this.currentTestClassName.size() > 1) {
            this.currentTestClassName.pop();
        }
    }

    void debug(String s) {
        Logger[] loggerArray = this.loggers;
        int n = this.loggers.length;
        int n2 = 0;
        while (n2 < n) {
            Logger l = loggerArray[n2];
            if (this.settings.color && l.ansiCodesSupported()) {
                l.debug(s);
            } else {
                l.debug(Ansi.filterAnsi(s));
            }
            ++n2;
        }
    }

    void error(String s) {
        Logger[] loggerArray = this.loggers;
        int n = this.loggers.length;
        int n2 = 0;
        while (n2 < n) {
            Logger l = loggerArray[n2];
            if (this.settings.color && l.ansiCodesSupported()) {
                l.error(s);
            } else {
                l.error(Ansi.filterAnsi(s));
            }
            ++n2;
        }
    }

    void error(String s, Throwable t) {
        this.error(s);
        if (t != null && (this.settings.logAssert || !(t instanceof AssertionError))) {
            this.logStackTrace(t);
        }
    }

    void info(String s) {
        Logger[] loggerArray = this.loggers;
        int n = this.loggers.length;
        int n2 = 0;
        while (n2 < n) {
            Logger l = loggerArray[n2];
            if (this.settings.color && l.ansiCodesSupported()) {
                l.info(s);
            } else {
                l.info(Ansi.filterAnsi(s));
            }
            ++n2;
        }
    }

    void warn(String s) {
        Logger[] loggerArray = this.loggers;
        int n = this.loggers.length;
        int n2 = 0;
        while (n2 < n) {
            Logger l = loggerArray[n2];
            if (this.settings.color && l.ansiCodesSupported()) {
                l.warn(s);
            } else {
                l.warn(Ansi.filterAnsi(s));
            }
            ++n2;
        }
    }

    private void logStackTrace(Throwable t) {
        StackTraceElement[] trace = t.getStackTrace();
        String testClassName = this.currentTestClassName.peek();
        String testFileName = this.settings.color ? this.findTestFileName(trace, testClassName) : null;
        this.logStackTracePart(trace, trace.length - 1, 0, t, testClassName, testFileName);
    }

    private void logStackTracePart(StackTraceElement[] trace, int m, int framesInCommon, Throwable t, String testClassName, String testFileName) {
        int top;
        int m0 = m;
        int i = top = 0;
        block0: while (i <= m) {
            if (trace[i].toString().startsWith("org.junit.")) {
                if (i != top) {
                    m = i - 1;
                    while (m > top) {
                        String s = trace[m].toString();
                        if (!s.startsWith("java.lang.reflect.") && !s.startsWith("sun.reflect.")) break block0;
                        --m;
                    }
                    break;
                }
                ++top;
            }
            ++i;
        }
        i = top;
        while (i <= m) {
            this.error("    at " + this.stackTraceElementToString(trace[i], testClassName, testFileName));
            ++i;
        }
        if (m0 != m) {
            this.error("    ...");
        } else if (framesInCommon != 0) {
            this.error("    ... " + framesInCommon + " more");
        }
        this.logStackTraceAsCause(trace, t.getCause(), testClassName, testFileName);
    }

    private void logStackTraceAsCause(StackTraceElement[] causedTrace, Throwable t, String testClassName, String testFileName) {
        if (t == null) {
            return;
        }
        StackTraceElement[] trace = t.getStackTrace();
        int m = trace.length - 1;
        int n = causedTrace.length - 1;
        while (m >= 0 && n >= 0 && trace[m].equals(causedTrace[n])) {
            --m;
            --n;
        }
        this.error("Caused by: " + t);
        this.logStackTracePart(trace, m, trace.length - 1 - m, t, testClassName, testFileName);
    }

    private String findTestFileName(StackTraceElement[] trace, String testClassName) {
        StackTraceElement[] stackTraceElementArray = trace;
        int n = trace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement e = stackTraceElementArray[n2];
            String cln = e.getClassName();
            if (testClassName.equals(cln)) {
                return e.getFileName();
            }
            ++n2;
        }
        return null;
    }

    private String stackTraceElementToString(StackTraceElement e, String testClassName, String testFileName) {
        boolean highlight = this.settings.color && (testClassName.equals(e.getClassName()) || testFileName != null && testFileName.equals(e.getFileName()));
        StringBuilder b = new StringBuilder();
        b.append(this.settings.decodeName(String.valueOf(e.getClassName()) + '.' + e.getMethodName()));
        b.append('(');
        if (e.isNativeMethod()) {
            b.append(Ansi.c("Native Method", highlight ? "\u001b[33m" : null));
        } else if (e.getFileName() == null) {
            b.append(Ansi.c("Unknown Source", highlight ? "\u001b[33m" : null));
        } else {
            b.append(Ansi.c(e.getFileName(), highlight ? "\u001b[35m" : null));
            if (e.getLineNumber() >= 0) {
                b.append(':').append(Ansi.c(String.valueOf(e.getLineNumber()), highlight ? "\u001b[33m" : null));
            }
        }
        return b.append(')').toString();
    }
}

