/*
 * Decompiled with CFR 0.152.
 */
package com.nrinaudo.fetch;

import com.nrinaudo.fetch.Conneg;
import com.nrinaudo.fetch.Conneg$Charsets$;
import com.nrinaudo.fetch.Conneg$Encodings$;
import com.nrinaudo.fetch.Conneg$Languages$;
import com.nrinaudo.fetch.Conneg$MediaTypes$;
import com.nrinaudo.fetch.ETag;
import com.nrinaudo.fetch.Encoding;
import com.nrinaudo.fetch.Encoding$;
import com.nrinaudo.fetch.Headers;
import com.nrinaudo.fetch.Headers$;
import com.nrinaudo.fetch.Headers$ByteRangesFormat$;
import com.nrinaudo.fetch.Headers$DateFormat$;
import com.nrinaudo.fetch.Headers$ETagFormat$;
import com.nrinaudo.fetch.Method;
import com.nrinaudo.fetch.Method$;
import com.nrinaudo.fetch.QueryString;
import com.nrinaudo.fetch.Request;
import com.nrinaudo.fetch.RequestEntity;
import com.nrinaudo.fetch.Url;
import com.nrinaudo.fetch.ValueReader;
import com.nrinaudo.fetch.ValueWriter;
import com.nrinaudo.fetch.package$;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public abstract class Request$class {
    public static Object apply(Request $this) {
        return $this.apply((Option<RequestEntity>)None$.MODULE$);
    }

    public static Object apply(Request $this, RequestEntity body) {
        return $this.apply((Option<RequestEntity>)new Some((Object)body));
    }

    public static Request url(Request $this, Url value) {
        return $this.copy(value, $this.method(), $this.headers());
    }

    public static Request method(Request $this, Method value) {
        return $this.copy($this.url(), value, $this.headers());
    }

    public static Request headers(Request $this, Headers value) {
        return $this.copy($this.url(), $this.method(), value);
    }

    public static Request $div(Request $this, String segment) {
        return $this.url($this.url().$div(segment));
    }

    public static Request $qmark(Request $this, QueryString value) {
        return $this.url($this.url().$qmark(value));
    }

    public static Request $amp(Request $this, Tuple2 param, ValueWriter evidence$1) {
        return $this.url($this.url().$amp(param, evidence$1));
    }

    public static Request GET(Request $this) {
        return $this.method(Method$.MODULE$.GET());
    }

    public static Request POST(Request $this) {
        return $this.method(Method$.MODULE$.POST());
    }

    public static Request PUT(Request $this) {
        return $this.method(Method$.MODULE$.PUT());
    }

    public static Request DELETE(Request $this) {
        return $this.method(Method$.MODULE$.DELETE());
    }

    public static Request HEAD(Request $this) {
        return $this.method(Method$.MODULE$.HEAD());
    }

    public static Request OPTIONS(Request $this) {
        return $this.method(Method$.MODULE$.OPTIONS());
    }

    public static Request TRACE(Request $this) {
        return $this.method(Method$.MODULE$.TRACE());
    }

    public static Request CONNECT(Request $this) {
        return $this.method(Method$.MODULE$.CONNECT());
    }

    public static Request PATCH(Request $this) {
        return $this.method(Method$.MODULE$.PATCH());
    }

    public static Request LINK(Request $this) {
        return $this.method(Method$.MODULE$.LINK());
    }

    public static Request UNLINK(Request $this) {
        return $this.method(Method$.MODULE$.UNLINK());
    }

    public static Request acceptEncoding(Request $this, Seq encodings) {
        return $this.header("Accept-Encoding", encodings, Conneg$Encodings$.MODULE$);
    }

    public static Option acceptEncoding(Request $this) {
        return $this.header("Accept-Encoding", Conneg$Encodings$.MODULE$);
    }

    public static Request acceptGzip(Request $this) {
        return $this.acceptEncoding((Seq<Conneg<Encoding>>)Predef$.MODULE$.wrapRefArray((Object[])new Conneg[]{package$.MODULE$.encodingToConneg(Encoding$.MODULE$.Gzip())}));
    }

    public static Request acceptDeflate(Request $this) {
        return $this.acceptEncoding((Seq<Conneg<Encoding>>)Predef$.MODULE$.wrapRefArray((Object[])new Conneg[]{package$.MODULE$.encodingToConneg(Encoding$.MODULE$.Deflate())}));
    }

    public static Request accept(Request $this, Seq types) {
        return $this.header("Accept", types, Conneg$MediaTypes$.MODULE$);
    }

    public static Option accept(Request $this) {
        return $this.header("Accept", Conneg$MediaTypes$.MODULE$);
    }

    public static Request acceptCharset(Request $this, Seq charsets) {
        return $this.header("Accept-Charset", charsets, Conneg$Charsets$.MODULE$);
    }

    public static Option acceptCharset(Request $this) {
        return $this.header("Accept-Charset", Conneg$Charsets$.MODULE$);
    }

    public static Request acceptLanguage(Request $this, Seq languages) {
        return $this.header("Accept-Language", languages, Conneg$Languages$.MODULE$);
    }

    public static Option acceptLanguage(Request $this) {
        return $this.header("Accept-Language", Conneg$Languages$.MODULE$);
    }

    public static Request header(Request $this, String name, Object value, ValueWriter evidence$2) {
        return $this.headers((Headers)$this.headers().set(name, value, evidence$2));
    }

    public static Option header(Request $this, String name, ValueReader evidence$3) {
        return $this.headers().getOpt(name, evidence$3);
    }

    public static Request ifModifiedSince(Request $this, Date date) {
        return $this.header("If-Modified-Since", date, Headers$DateFormat$.MODULE$);
    }

    public static Option ifModifiedSince(Request $this) {
        return $this.header("If-Modified-Since", Headers$DateFormat$.MODULE$);
    }

    public static Request ifUnmodifiedSince(Request $this, Date date) {
        return $this.header("If-Unmodified-Since", date, Headers$DateFormat$.MODULE$);
    }

    public static Option ifUnmodifiedSince(Request $this) {
        return $this.header("If-Unmodified-Since", Headers$DateFormat$.MODULE$);
    }

    public static Request ifNoneMatch(Request $this, Seq tags) {
        return $this.header("If-None-Match", tags, Headers$.MODULE$.compositeWriter(Headers$ETagFormat$.MODULE$));
    }

    public static Option ifNoneMatch(Request $this) {
        return $this.header("If-None-Match", Headers$.MODULE$.compositeReader(Headers$ETagFormat$.MODULE$));
    }

    public static Request ifMatch(Request $this, Seq tags) {
        return $this.header("If-Match", tags, Headers$.MODULE$.compositeWriter(Headers$ETagFormat$.MODULE$));
    }

    public static Option ifMatch(Request $this) {
        return $this.header("If-Match", Headers$.MODULE$.compositeReader(Headers$ETagFormat$.MODULE$));
    }

    public static Request ifRange(Request $this, ETag tag) {
        return $this.header("If-Range", tag, Headers$ETagFormat$.MODULE$);
    }

    public static Request ifRange(Request $this, Date date) {
        return $this.header("If-Range", date, Headers$DateFormat$.MODULE$);
    }

    public static Request range(Request $this, Seq ranges) {
        return ranges.isEmpty() ? $this : $this.header("Range", ranges, Headers$ByteRangesFormat$.MODULE$);
    }

    public static Option range(Request $this) {
        return $this.header("Range", Headers$ByteRangesFormat$.MODULE$);
    }

    public static Request date(Request $this, Date date) {
        return $this.header("Date", date, Headers$DateFormat$.MODULE$);
    }

    public static Option date(Request $this) {
        return $this.header("Date", Headers$DateFormat$.MODULE$);
    }

    public static Date date$default$1(Request $this) {
        return new Date();
    }

    public static Request userAgent(Request $this, String name) {
        return $this.header("User-Agent", name, Headers$.MODULE$.StringFormat());
    }

    public static Option userAgent(Request $this) {
        return $this.header("User-Agent", Headers$.MODULE$.StringFormat());
    }

    public static Request maxForwards(Request $this, int value) {
        return $this.header("Max-Forwards", BoxesRunTime.boxToInteger((int)value), Headers$.MODULE$.IntFormat());
    }

    public static Option maxForwards(Request $this) {
        return $this.header("Max-Forwards", Headers$.MODULE$.IntFormat());
    }

    public static Request auth(Request $this, String user, String pwd) {
        return $this.header("Authorization", new StringBuilder().append((Object)"Basic ").append((Object)Base64.encodeBase64String((byte[])new StringBuilder().append((Object)user).append((Object)BoxesRunTime.boxToCharacter((char)':')).append((Object)pwd).toString().getBytes())).toString(), Headers$.MODULE$.StringFormat());
    }

    public static void $init$(Request $this) {
    }
}

