/*
 * Decompiled with CFR 0.152.
 */
package com.nrinaudo.fetch;

public class UrlEncoder {
    private static final String[] hex = new String[]{"%00", "%01", "%02", "%03", "%04", "%05", "%06", "%07", "%08", "%09", "%0a", "%0b", "%0c", "%0d", "%0e", "%0f", "%10", "%11", "%12", "%13", "%14", "%15", "%16", "%17", "%18", "%19", "%1a", "%1b", "%1c", "%1d", "%1e", "%1f", "%20", "%21", "%22", "%23", "%24", "%25", "%26", "%27", "%28", "%29", "%2a", "%2b", "%2c", "%2d", "%2e", "%2f", "%30", "%31", "%32", "%33", "%34", "%35", "%36", "%37", "%38", "%39", "%3a", "%3b", "%3c", "%3d", "%3e", "%3f", "%40", "%41", "%42", "%43", "%44", "%45", "%46", "%47", "%48", "%49", "%4a", "%4b", "%4c", "%4d", "%4e", "%4f", "%50", "%51", "%52", "%53", "%54", "%55", "%56", "%57", "%58", "%59", "%5a", "%5b", "%5c", "%5d", "%5e", "%5f", "%60", "%61", "%62", "%63", "%64", "%65", "%66", "%67", "%68", "%69", "%6a", "%6b", "%6c", "%6d", "%6e", "%6f", "%70", "%71", "%72", "%73", "%74", "%75", "%76", "%77", "%78", "%79", "%7a", "%7b", "%7c", "%7d", "%7e", "%7f", "%80", "%81", "%82", "%83", "%84", "%85", "%86", "%87", "%88", "%89", "%8a", "%8b", "%8c", "%8d", "%8e", "%8f", "%90", "%91", "%92", "%93", "%94", "%95", "%96", "%97", "%98", "%99", "%9a", "%9b", "%9c", "%9d", "%9e", "%9f", "%a0", "%a1", "%a2", "%a3", "%a4", "%a5", "%a6", "%a7", "%a8", "%a9", "%aa", "%ab", "%ac", "%ad", "%ae", "%af", "%b0", "%b1", "%b2", "%b3", "%b4", "%b5", "%b6", "%b7", "%b8", "%b9", "%ba", "%bb", "%bc", "%bd", "%be", "%bf", "%c0", "%c1", "%c2", "%c3", "%c4", "%c5", "%c6", "%c7", "%c8", "%c9", "%ca", "%cb", "%cc", "%cd", "%ce", "%cf", "%d0", "%d1", "%d2", "%d3", "%d4", "%d5", "%d6", "%d7", "%d8", "%d9", "%da", "%db", "%dc", "%dd", "%de", "%df", "%e0", "%e1", "%e2", "%e3", "%e4", "%e5", "%e6", "%e7", "%e8", "%e9", "%ea", "%eb", "%ec", "%ed", "%ee", "%ef", "%f0", "%f1", "%f2", "%f3", "%f4", "%f5", "%f6", "%f7", "%f8", "%f9", "%fa", "%fb", "%fc", "%fd", "%fe", "%ff"};

    public static StringBuilder encodeInto(String string, StringBuilder stringBuilder) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if ('A' <= c && c <= 'Z') {
                stringBuilder.append(c);
                continue;
            }
            if ('a' <= c && c <= 'z') {
                stringBuilder.append(c);
                continue;
            }
            if ('0' <= c && c <= '9') {
                stringBuilder.append(c);
                continue;
            }
            if (c == '-' || c == '_' || c == '.' || c == '!' || c == '~' || c == '*' || c == '\'' || c == '(' || c == ')') {
                stringBuilder.append(c);
                continue;
            }
            if (c <= '\u007f') {
                stringBuilder.append(hex[c]);
                continue;
            }
            if (c <= '\u07ff') {
                stringBuilder.append(hex[0xC0 | c >> 6]);
                stringBuilder.append(hex[0x80 | c & 0x3F]);
                continue;
            }
            stringBuilder.append(hex[0xE0 | c >> 12]);
            stringBuilder.append(hex[0x80 | c >> 6 & 0x3F]);
            stringBuilder.append(hex[0x80 | c & 0x3F]);
        }
        return stringBuilder;
    }

    public static String encode(String string) {
        return UrlEncoder.encodeInto(string, new StringBuilder()).toString();
    }

    public static StringBuilder decodeInto(String string, StringBuilder stringBuilder) {
        int n = string.length();
        int n2 = 0;
        int n3 = -1;
        for (int i = 0; i < n; ++i) {
            int n4;
            char c = string.charAt(i);
            switch (c) {
                case '%': {
                    c = string.charAt(++i);
                    int n5 = (Character.isDigit(c) ? c - 48 : 10 + Character.toLowerCase(c) - 97) & 0xF;
                    c = string.charAt(++i);
                    int n6 = (Character.isDigit(c) ? c - 48 : 10 + Character.toLowerCase(c) - 97) & 0xF;
                    n4 = n5 << 4 | n6;
                    break;
                }
                case '+': {
                    n4 = 32;
                    break;
                }
                default: {
                    n4 = c;
                }
            }
            if ((n4 & 0xC0) == 128) {
                n2 = n2 << 6 | n4 & 0x3F;
                if (--n3 != 0) continue;
                stringBuilder.append((char)n2);
                continue;
            }
            if ((n4 & 0x80) == 0) {
                stringBuilder.append((char)n4);
                continue;
            }
            if ((n4 & 0xE0) == 192) {
                n2 = n4 & 0x1F;
                n3 = 1;
                continue;
            }
            if ((n4 & 0xF0) == 224) {
                n2 = n4 & 0xF;
                n3 = 2;
                continue;
            }
            if ((n4 & 0xF8) == 240) {
                n2 = n4 & 7;
                n3 = 3;
                continue;
            }
            if ((n4 & 0xFC) == 248) {
                n2 = n4 & 3;
                n3 = 4;
                continue;
            }
            n2 = n4 & 1;
            n3 = 5;
        }
        return stringBuilder;
    }

    public static String decode(String string) {
        return UrlEncoder.decodeInto(string, new StringBuilder()).toString();
    }
}

