// auto-generated by sbt-boilerplate
/*
 * Copyright 2015 Nicolas Rinaudo
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package kantan.csv

/** Provides [[RowDecoder]] instance construction methods. */
trait GeneratedRowDecoders {
  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int)
    *
    * scala> RowDecoder.decoder(0)(Ints.apply _).decode(Seq("1"))
    * res0: DecodeResult[Ints] = Success(Ints(1))
    * }}}
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    */
  def decoder[A1: CellDecoder, R](i1: Int)(f: (A1) ⇒ R): RowDecoder[R] =
    RowDecoder.from(ss ⇒ for {
      f1 ← RowDecoder.decodeCell[A1](ss, i1)
    } yield f(f1))

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int)
    *
    * scala> RowDecoder.decoder(0, 1)(Ints.apply _).decode(Seq("1", "2"))
    * res1: DecodeResult[Ints] = Success(Ints(1,2))
    * }}}
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    */
  def decoder[A1: CellDecoder, A2: CellDecoder, R](i1: Int, i2: Int)(f: (A1, A2) ⇒ R): RowDecoder[R] =
    RowDecoder.from(ss ⇒ for {
      f1 ← RowDecoder.decodeCell[A1](ss, i1)
      f2 ← RowDecoder.decodeCell[A2](ss, i2)
    } yield f(f1, f2))

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int)
    *
    * scala> RowDecoder.decoder(0, 1, 2)(Ints.apply _).decode(Seq("1", "2", "3"))
    * res2: DecodeResult[Ints] = Success(Ints(1,2,3))
    * }}}
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, R](i1: Int, i2: Int, i3: Int)(f: (A1, A2, A3) ⇒ R): RowDecoder[R] =
    RowDecoder.from(ss ⇒ for {
      f1 ← RowDecoder.decodeCell[A1](ss, i1)
      f2 ← RowDecoder.decodeCell[A2](ss, i2)
      f3 ← RowDecoder.decodeCell[A3](ss, i3)
    } yield f(f1, f2, f3))

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int)
    *
    * scala> RowDecoder.decoder(0, 1, 2, 3)(Ints.apply _).decode(Seq("1", "2", "3", "4"))
    * res3: DecodeResult[Ints] = Success(Ints(1,2,3,4))
    * }}}
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, R](i1: Int, i2: Int, i3: Int, i4: Int)(f: (A1, A2, A3, A4) ⇒ R): RowDecoder[R] =
    RowDecoder.from(ss ⇒ for {
      f1 ← RowDecoder.decodeCell[A1](ss, i1)
      f2 ← RowDecoder.decodeCell[A2](ss, i2)
      f3 ← RowDecoder.decodeCell[A3](ss, i3)
      f4 ← RowDecoder.decodeCell[A4](ss, i4)
    } yield f(f1, f2, f3, f4))

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int)
    *
    * scala> RowDecoder.decoder(0, 1, 2, 3, 4)(Ints.apply _).decode(Seq("1", "2", "3", "4", "5"))
    * res4: DecodeResult[Ints] = Success(Ints(1,2,3,4,5))
    * }}}
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, R](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int)(f: (A1, A2, A3, A4, A5) ⇒ R): RowDecoder[R] =
    RowDecoder.from(ss ⇒ for {
      f1 ← RowDecoder.decodeCell[A1](ss, i1)
      f2 ← RowDecoder.decodeCell[A2](ss, i2)
      f3 ← RowDecoder.decodeCell[A3](ss, i3)
      f4 ← RowDecoder.decodeCell[A4](ss, i4)
      f5 ← RowDecoder.decodeCell[A5](ss, i5)
    } yield f(f1, f2, f3, f4, f5))

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int)
    *
    * scala> RowDecoder.decoder(0, 1, 2, 3, 4, 5)(Ints.apply _).decode(Seq("1", "2", "3", "4", "5", "6"))
    * res5: DecodeResult[Ints] = Success(Ints(1,2,3,4,5,6))
    * }}}
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, R](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int)(f: (A1, A2, A3, A4, A5, A6) ⇒ R): RowDecoder[R] =
    RowDecoder.from(ss ⇒ for {
      f1 ← RowDecoder.decodeCell[A1](ss, i1)
      f2 ← RowDecoder.decodeCell[A2](ss, i2)
      f3 ← RowDecoder.decodeCell[A3](ss, i3)
      f4 ← RowDecoder.decodeCell[A4](ss, i4)
      f5 ← RowDecoder.decodeCell[A5](ss, i5)
      f6 ← RowDecoder.decodeCell[A6](ss, i6)
    } yield f(f1, f2, f3, f4, f5, f6))

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int)
    *
    * scala> RowDecoder.decoder(0, 1, 2, 3, 4, 5, 6)(Ints.apply _).decode(Seq("1", "2", "3", "4", "5", "6", "7"))
    * res6: DecodeResult[Ints] = Success(Ints(1,2,3,4,5,6,7))
    * }}}
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, R](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int)(f: (A1, A2, A3, A4, A5, A6, A7) ⇒ R): RowDecoder[R] =
    RowDecoder.from(ss ⇒ for {
      f1 ← RowDecoder.decodeCell[A1](ss, i1)
      f2 ← RowDecoder.decodeCell[A2](ss, i2)
      f3 ← RowDecoder.decodeCell[A3](ss, i3)
      f4 ← RowDecoder.decodeCell[A4](ss, i4)
      f5 ← RowDecoder.decodeCell[A5](ss, i5)
      f6 ← RowDecoder.decodeCell[A6](ss, i6)
      f7 ← RowDecoder.decodeCell[A7](ss, i7)
    } yield f(f1, f2, f3, f4, f5, f6, f7))

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int)
    *
    * scala> RowDecoder.decoder(0, 1, 2, 3, 4, 5, 6, 7)(Ints.apply _).decode(Seq("1", "2", "3", "4", "5", "6", "7", "8"))
    * res7: DecodeResult[Ints] = Success(Ints(1,2,3,4,5,6,7,8))
    * }}}
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, R](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8) ⇒ R): RowDecoder[R] =
    RowDecoder.from(ss ⇒ for {
      f1 ← RowDecoder.decodeCell[A1](ss, i1)
      f2 ← RowDecoder.decodeCell[A2](ss, i2)
      f3 ← RowDecoder.decodeCell[A3](ss, i3)
      f4 ← RowDecoder.decodeCell[A4](ss, i4)
      f5 ← RowDecoder.decodeCell[A5](ss, i5)
      f6 ← RowDecoder.decodeCell[A6](ss, i6)
      f7 ← RowDecoder.decodeCell[A7](ss, i7)
      f8 ← RowDecoder.decodeCell[A8](ss, i8)
    } yield f(f1, f2, f3, f4, f5, f6, f7, f8))

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int)
    *
    * scala> RowDecoder.decoder(0, 1, 2, 3, 4, 5, 6, 7, 8)(Ints.apply _).decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9"))
    * res8: DecodeResult[Ints] = Success(Ints(1,2,3,4,5,6,7,8,9))
    * }}}
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, R](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9) ⇒ R): RowDecoder[R] =
    RowDecoder.from(ss ⇒ for {
      f1 ← RowDecoder.decodeCell[A1](ss, i1)
      f2 ← RowDecoder.decodeCell[A2](ss, i2)
      f3 ← RowDecoder.decodeCell[A3](ss, i3)
      f4 ← RowDecoder.decodeCell[A4](ss, i4)
      f5 ← RowDecoder.decodeCell[A5](ss, i5)
      f6 ← RowDecoder.decodeCell[A6](ss, i6)
      f7 ← RowDecoder.decodeCell[A7](ss, i7)
      f8 ← RowDecoder.decodeCell[A8](ss, i8)
      f9 ← RowDecoder.decodeCell[A9](ss, i9)
    } yield f(f1, f2, f3, f4, f5, f6, f7, f8, f9))

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int)
    *
    * scala> RowDecoder.decoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9)(Ints.apply _).decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10"))
    * res9: DecodeResult[Ints] = Success(Ints(1,2,3,4,5,6,7,8,9,10))
    * }}}
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f`
    */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, R](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10) ⇒ R): RowDecoder[R] =
    RowDecoder.from(ss ⇒ for {
      f1 ← RowDecoder.decodeCell[A1](ss, i1)
      f2 ← RowDecoder.decodeCell[A2](ss, i2)
      f3 ← RowDecoder.decodeCell[A3](ss, i3)
      f4 ← RowDecoder.decodeCell[A4](ss, i4)
      f5 ← RowDecoder.decodeCell[A5](ss, i5)
      f6 ← RowDecoder.decodeCell[A6](ss, i6)
      f7 ← RowDecoder.decodeCell[A7](ss, i7)
      f8 ← RowDecoder.decodeCell[A8](ss, i8)
      f9 ← RowDecoder.decodeCell[A9](ss, i9)
      f10 ← RowDecoder.decodeCell[A10](ss, i10)
    } yield f(f1, f2, f3, f4, f5, f6, f7, f8, f9, f10))

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int)
    *
    * scala> RowDecoder.decoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10)(Ints.apply _).decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11"))
    * res10: DecodeResult[Ints] = Success(Ints(1,2,3,4,5,6,7,8,9,10,11))
    * }}}
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f`
    */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, R](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11) ⇒ R): RowDecoder[R] =
    RowDecoder.from(ss ⇒ for {
      f1 ← RowDecoder.decodeCell[A1](ss, i1)
      f2 ← RowDecoder.decodeCell[A2](ss, i2)
      f3 ← RowDecoder.decodeCell[A3](ss, i3)
      f4 ← RowDecoder.decodeCell[A4](ss, i4)
      f5 ← RowDecoder.decodeCell[A5](ss, i5)
      f6 ← RowDecoder.decodeCell[A6](ss, i6)
      f7 ← RowDecoder.decodeCell[A7](ss, i7)
      f8 ← RowDecoder.decodeCell[A8](ss, i8)
      f9 ← RowDecoder.decodeCell[A9](ss, i9)
      f10 ← RowDecoder.decodeCell[A10](ss, i10)
      f11 ← RowDecoder.decodeCell[A11](ss, i11)
    } yield f(f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11))

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int)
    *
    * scala> RowDecoder.decoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11)(Ints.apply _).decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"))
    * res11: DecodeResult[Ints] = Success(Ints(1,2,3,4,5,6,7,8,9,10,11,12))
    * }}}
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f`
    */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, R](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12) ⇒ R): RowDecoder[R] =
    RowDecoder.from(ss ⇒ for {
      f1 ← RowDecoder.decodeCell[A1](ss, i1)
      f2 ← RowDecoder.decodeCell[A2](ss, i2)
      f3 ← RowDecoder.decodeCell[A3](ss, i3)
      f4 ← RowDecoder.decodeCell[A4](ss, i4)
      f5 ← RowDecoder.decodeCell[A5](ss, i5)
      f6 ← RowDecoder.decodeCell[A6](ss, i6)
      f7 ← RowDecoder.decodeCell[A7](ss, i7)
      f8 ← RowDecoder.decodeCell[A8](ss, i8)
      f9 ← RowDecoder.decodeCell[A9](ss, i9)
      f10 ← RowDecoder.decodeCell[A10](ss, i10)
      f11 ← RowDecoder.decodeCell[A11](ss, i11)
      f12 ← RowDecoder.decodeCell[A12](ss, i12)
    } yield f(f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12))

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int)
    *
    * scala> RowDecoder.decoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12)(Ints.apply _).decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13"))
    * res12: DecodeResult[Ints] = Success(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13))
    * }}}
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f`
    */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder, R](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13) ⇒ R): RowDecoder[R] =
    RowDecoder.from(ss ⇒ for {
      f1 ← RowDecoder.decodeCell[A1](ss, i1)
      f2 ← RowDecoder.decodeCell[A2](ss, i2)
      f3 ← RowDecoder.decodeCell[A3](ss, i3)
      f4 ← RowDecoder.decodeCell[A4](ss, i4)
      f5 ← RowDecoder.decodeCell[A5](ss, i5)
      f6 ← RowDecoder.decodeCell[A6](ss, i6)
      f7 ← RowDecoder.decodeCell[A7](ss, i7)
      f8 ← RowDecoder.decodeCell[A8](ss, i8)
      f9 ← RowDecoder.decodeCell[A9](ss, i9)
      f10 ← RowDecoder.decodeCell[A10](ss, i10)
      f11 ← RowDecoder.decodeCell[A11](ss, i11)
      f12 ← RowDecoder.decodeCell[A12](ss, i12)
      f13 ← RowDecoder.decodeCell[A13](ss, i13)
    } yield f(f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13))

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int)
    *
    * scala> RowDecoder.decoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13)(Ints.apply _).decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14"))
    * res13: DecodeResult[Ints] = Success(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14))
    * }}}
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f`
    * @param i14 index of the cell that should be passed as parameter number 14 of `f`
    */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder, A14: CellDecoder, R](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14) ⇒ R): RowDecoder[R] =
    RowDecoder.from(ss ⇒ for {
      f1 ← RowDecoder.decodeCell[A1](ss, i1)
      f2 ← RowDecoder.decodeCell[A2](ss, i2)
      f3 ← RowDecoder.decodeCell[A3](ss, i3)
      f4 ← RowDecoder.decodeCell[A4](ss, i4)
      f5 ← RowDecoder.decodeCell[A5](ss, i5)
      f6 ← RowDecoder.decodeCell[A6](ss, i6)
      f7 ← RowDecoder.decodeCell[A7](ss, i7)
      f8 ← RowDecoder.decodeCell[A8](ss, i8)
      f9 ← RowDecoder.decodeCell[A9](ss, i9)
      f10 ← RowDecoder.decodeCell[A10](ss, i10)
      f11 ← RowDecoder.decodeCell[A11](ss, i11)
      f12 ← RowDecoder.decodeCell[A12](ss, i12)
      f13 ← RowDecoder.decodeCell[A13](ss, i13)
      f14 ← RowDecoder.decodeCell[A14](ss, i14)
    } yield f(f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14))

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int)
    *
    * scala> RowDecoder.decoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14)(Ints.apply _).decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"))
    * res14: DecodeResult[Ints] = Success(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15))
    * }}}
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f`
    * @param i14 index of the cell that should be passed as parameter number 14 of `f`
    * @param i15 index of the cell that should be passed as parameter number 15 of `f`
    */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder, A14: CellDecoder, A15: CellDecoder, R](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15) ⇒ R): RowDecoder[R] =
    RowDecoder.from(ss ⇒ for {
      f1 ← RowDecoder.decodeCell[A1](ss, i1)
      f2 ← RowDecoder.decodeCell[A2](ss, i2)
      f3 ← RowDecoder.decodeCell[A3](ss, i3)
      f4 ← RowDecoder.decodeCell[A4](ss, i4)
      f5 ← RowDecoder.decodeCell[A5](ss, i5)
      f6 ← RowDecoder.decodeCell[A6](ss, i6)
      f7 ← RowDecoder.decodeCell[A7](ss, i7)
      f8 ← RowDecoder.decodeCell[A8](ss, i8)
      f9 ← RowDecoder.decodeCell[A9](ss, i9)
      f10 ← RowDecoder.decodeCell[A10](ss, i10)
      f11 ← RowDecoder.decodeCell[A11](ss, i11)
      f12 ← RowDecoder.decodeCell[A12](ss, i12)
      f13 ← RowDecoder.decodeCell[A13](ss, i13)
      f14 ← RowDecoder.decodeCell[A14](ss, i14)
      f15 ← RowDecoder.decodeCell[A15](ss, i15)
    } yield f(f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15))

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int)
    *
    * scala> RowDecoder.decoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)(Ints.apply _).decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16"))
    * res15: DecodeResult[Ints] = Success(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16))
    * }}}
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f`
    * @param i14 index of the cell that should be passed as parameter number 14 of `f`
    * @param i15 index of the cell that should be passed as parameter number 15 of `f`
    * @param i16 index of the cell that should be passed as parameter number 16 of `f`
    */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder, A14: CellDecoder, A15: CellDecoder, A16: CellDecoder, R](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16) ⇒ R): RowDecoder[R] =
    RowDecoder.from(ss ⇒ for {
      f1 ← RowDecoder.decodeCell[A1](ss, i1)
      f2 ← RowDecoder.decodeCell[A2](ss, i2)
      f3 ← RowDecoder.decodeCell[A3](ss, i3)
      f4 ← RowDecoder.decodeCell[A4](ss, i4)
      f5 ← RowDecoder.decodeCell[A5](ss, i5)
      f6 ← RowDecoder.decodeCell[A6](ss, i6)
      f7 ← RowDecoder.decodeCell[A7](ss, i7)
      f8 ← RowDecoder.decodeCell[A8](ss, i8)
      f9 ← RowDecoder.decodeCell[A9](ss, i9)
      f10 ← RowDecoder.decodeCell[A10](ss, i10)
      f11 ← RowDecoder.decodeCell[A11](ss, i11)
      f12 ← RowDecoder.decodeCell[A12](ss, i12)
      f13 ← RowDecoder.decodeCell[A13](ss, i13)
      f14 ← RowDecoder.decodeCell[A14](ss, i14)
      f15 ← RowDecoder.decodeCell[A15](ss, i15)
      f16 ← RowDecoder.decodeCell[A16](ss, i16)
    } yield f(f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16))

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int)
    *
    * scala> RowDecoder.decoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16)(Ints.apply _).decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17"))
    * res16: DecodeResult[Ints] = Success(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17))
    * }}}
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f`
    * @param i14 index of the cell that should be passed as parameter number 14 of `f`
    * @param i15 index of the cell that should be passed as parameter number 15 of `f`
    * @param i16 index of the cell that should be passed as parameter number 16 of `f`
    * @param i17 index of the cell that should be passed as parameter number 17 of `f`
    */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder, A14: CellDecoder, A15: CellDecoder, A16: CellDecoder, A17: CellDecoder, R](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17) ⇒ R): RowDecoder[R] =
    RowDecoder.from(ss ⇒ for {
      f1 ← RowDecoder.decodeCell[A1](ss, i1)
      f2 ← RowDecoder.decodeCell[A2](ss, i2)
      f3 ← RowDecoder.decodeCell[A3](ss, i3)
      f4 ← RowDecoder.decodeCell[A4](ss, i4)
      f5 ← RowDecoder.decodeCell[A5](ss, i5)
      f6 ← RowDecoder.decodeCell[A6](ss, i6)
      f7 ← RowDecoder.decodeCell[A7](ss, i7)
      f8 ← RowDecoder.decodeCell[A8](ss, i8)
      f9 ← RowDecoder.decodeCell[A9](ss, i9)
      f10 ← RowDecoder.decodeCell[A10](ss, i10)
      f11 ← RowDecoder.decodeCell[A11](ss, i11)
      f12 ← RowDecoder.decodeCell[A12](ss, i12)
      f13 ← RowDecoder.decodeCell[A13](ss, i13)
      f14 ← RowDecoder.decodeCell[A14](ss, i14)
      f15 ← RowDecoder.decodeCell[A15](ss, i15)
      f16 ← RowDecoder.decodeCell[A16](ss, i16)
      f17 ← RowDecoder.decodeCell[A17](ss, i17)
    } yield f(f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, f17))

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int)
    *
    * scala> RowDecoder.decoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17)(Ints.apply _).decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18"))
    * res17: DecodeResult[Ints] = Success(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18))
    * }}}
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f`
    * @param i14 index of the cell that should be passed as parameter number 14 of `f`
    * @param i15 index of the cell that should be passed as parameter number 15 of `f`
    * @param i16 index of the cell that should be passed as parameter number 16 of `f`
    * @param i17 index of the cell that should be passed as parameter number 17 of `f`
    * @param i18 index of the cell that should be passed as parameter number 18 of `f`
    */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder, A14: CellDecoder, A15: CellDecoder, A16: CellDecoder, A17: CellDecoder, A18: CellDecoder, R](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18) ⇒ R): RowDecoder[R] =
    RowDecoder.from(ss ⇒ for {
      f1 ← RowDecoder.decodeCell[A1](ss, i1)
      f2 ← RowDecoder.decodeCell[A2](ss, i2)
      f3 ← RowDecoder.decodeCell[A3](ss, i3)
      f4 ← RowDecoder.decodeCell[A4](ss, i4)
      f5 ← RowDecoder.decodeCell[A5](ss, i5)
      f6 ← RowDecoder.decodeCell[A6](ss, i6)
      f7 ← RowDecoder.decodeCell[A7](ss, i7)
      f8 ← RowDecoder.decodeCell[A8](ss, i8)
      f9 ← RowDecoder.decodeCell[A9](ss, i9)
      f10 ← RowDecoder.decodeCell[A10](ss, i10)
      f11 ← RowDecoder.decodeCell[A11](ss, i11)
      f12 ← RowDecoder.decodeCell[A12](ss, i12)
      f13 ← RowDecoder.decodeCell[A13](ss, i13)
      f14 ← RowDecoder.decodeCell[A14](ss, i14)
      f15 ← RowDecoder.decodeCell[A15](ss, i15)
      f16 ← RowDecoder.decodeCell[A16](ss, i16)
      f17 ← RowDecoder.decodeCell[A17](ss, i17)
      f18 ← RowDecoder.decodeCell[A18](ss, i18)
    } yield f(f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, f17, f18))

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int)
    *
    * scala> RowDecoder.decoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18)(Ints.apply _).decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19"))
    * res18: DecodeResult[Ints] = Success(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19))
    * }}}
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f`
    * @param i14 index of the cell that should be passed as parameter number 14 of `f`
    * @param i15 index of the cell that should be passed as parameter number 15 of `f`
    * @param i16 index of the cell that should be passed as parameter number 16 of `f`
    * @param i17 index of the cell that should be passed as parameter number 17 of `f`
    * @param i18 index of the cell that should be passed as parameter number 18 of `f`
    * @param i19 index of the cell that should be passed as parameter number 19 of `f`
    */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder, A14: CellDecoder, A15: CellDecoder, A16: CellDecoder, A17: CellDecoder, A18: CellDecoder, A19: CellDecoder, R](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19) ⇒ R): RowDecoder[R] =
    RowDecoder.from(ss ⇒ for {
      f1 ← RowDecoder.decodeCell[A1](ss, i1)
      f2 ← RowDecoder.decodeCell[A2](ss, i2)
      f3 ← RowDecoder.decodeCell[A3](ss, i3)
      f4 ← RowDecoder.decodeCell[A4](ss, i4)
      f5 ← RowDecoder.decodeCell[A5](ss, i5)
      f6 ← RowDecoder.decodeCell[A6](ss, i6)
      f7 ← RowDecoder.decodeCell[A7](ss, i7)
      f8 ← RowDecoder.decodeCell[A8](ss, i8)
      f9 ← RowDecoder.decodeCell[A9](ss, i9)
      f10 ← RowDecoder.decodeCell[A10](ss, i10)
      f11 ← RowDecoder.decodeCell[A11](ss, i11)
      f12 ← RowDecoder.decodeCell[A12](ss, i12)
      f13 ← RowDecoder.decodeCell[A13](ss, i13)
      f14 ← RowDecoder.decodeCell[A14](ss, i14)
      f15 ← RowDecoder.decodeCell[A15](ss, i15)
      f16 ← RowDecoder.decodeCell[A16](ss, i16)
      f17 ← RowDecoder.decodeCell[A17](ss, i17)
      f18 ← RowDecoder.decodeCell[A18](ss, i18)
      f19 ← RowDecoder.decodeCell[A19](ss, i19)
    } yield f(f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, f17, f18, f19))

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int)
    *
    * scala> RowDecoder.decoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19)(Ints.apply _).decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20"))
    * res19: DecodeResult[Ints] = Success(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20))
    * }}}
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f`
    * @param i14 index of the cell that should be passed as parameter number 14 of `f`
    * @param i15 index of the cell that should be passed as parameter number 15 of `f`
    * @param i16 index of the cell that should be passed as parameter number 16 of `f`
    * @param i17 index of the cell that should be passed as parameter number 17 of `f`
    * @param i18 index of the cell that should be passed as parameter number 18 of `f`
    * @param i19 index of the cell that should be passed as parameter number 19 of `f`
    * @param i20 index of the cell that should be passed as parameter number 20 of `f`
    */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder, A14: CellDecoder, A15: CellDecoder, A16: CellDecoder, A17: CellDecoder, A18: CellDecoder, A19: CellDecoder, A20: CellDecoder, R](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20) ⇒ R): RowDecoder[R] =
    RowDecoder.from(ss ⇒ for {
      f1 ← RowDecoder.decodeCell[A1](ss, i1)
      f2 ← RowDecoder.decodeCell[A2](ss, i2)
      f3 ← RowDecoder.decodeCell[A3](ss, i3)
      f4 ← RowDecoder.decodeCell[A4](ss, i4)
      f5 ← RowDecoder.decodeCell[A5](ss, i5)
      f6 ← RowDecoder.decodeCell[A6](ss, i6)
      f7 ← RowDecoder.decodeCell[A7](ss, i7)
      f8 ← RowDecoder.decodeCell[A8](ss, i8)
      f9 ← RowDecoder.decodeCell[A9](ss, i9)
      f10 ← RowDecoder.decodeCell[A10](ss, i10)
      f11 ← RowDecoder.decodeCell[A11](ss, i11)
      f12 ← RowDecoder.decodeCell[A12](ss, i12)
      f13 ← RowDecoder.decodeCell[A13](ss, i13)
      f14 ← RowDecoder.decodeCell[A14](ss, i14)
      f15 ← RowDecoder.decodeCell[A15](ss, i15)
      f16 ← RowDecoder.decodeCell[A16](ss, i16)
      f17 ← RowDecoder.decodeCell[A17](ss, i17)
      f18 ← RowDecoder.decodeCell[A18](ss, i18)
      f19 ← RowDecoder.decodeCell[A19](ss, i19)
      f20 ← RowDecoder.decodeCell[A20](ss, i20)
    } yield f(f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, f17, f18, f19, f20))

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int, i21: Int)
    *
    * scala> RowDecoder.decoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20)(Ints.apply _).decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21"))
    * res20: DecodeResult[Ints] = Success(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21))
    * }}}
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f`
    * @param i14 index of the cell that should be passed as parameter number 14 of `f`
    * @param i15 index of the cell that should be passed as parameter number 15 of `f`
    * @param i16 index of the cell that should be passed as parameter number 16 of `f`
    * @param i17 index of the cell that should be passed as parameter number 17 of `f`
    * @param i18 index of the cell that should be passed as parameter number 18 of `f`
    * @param i19 index of the cell that should be passed as parameter number 19 of `f`
    * @param i20 index of the cell that should be passed as parameter number 20 of `f`
    * @param i21 index of the cell that should be passed as parameter number 21 of `f`
    */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder, A14: CellDecoder, A15: CellDecoder, A16: CellDecoder, A17: CellDecoder, A18: CellDecoder, A19: CellDecoder, A20: CellDecoder, A21: CellDecoder, R](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int, i21: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21) ⇒ R): RowDecoder[R] =
    RowDecoder.from(ss ⇒ for {
      f1 ← RowDecoder.decodeCell[A1](ss, i1)
      f2 ← RowDecoder.decodeCell[A2](ss, i2)
      f3 ← RowDecoder.decodeCell[A3](ss, i3)
      f4 ← RowDecoder.decodeCell[A4](ss, i4)
      f5 ← RowDecoder.decodeCell[A5](ss, i5)
      f6 ← RowDecoder.decodeCell[A6](ss, i6)
      f7 ← RowDecoder.decodeCell[A7](ss, i7)
      f8 ← RowDecoder.decodeCell[A8](ss, i8)
      f9 ← RowDecoder.decodeCell[A9](ss, i9)
      f10 ← RowDecoder.decodeCell[A10](ss, i10)
      f11 ← RowDecoder.decodeCell[A11](ss, i11)
      f12 ← RowDecoder.decodeCell[A12](ss, i12)
      f13 ← RowDecoder.decodeCell[A13](ss, i13)
      f14 ← RowDecoder.decodeCell[A14](ss, i14)
      f15 ← RowDecoder.decodeCell[A15](ss, i15)
      f16 ← RowDecoder.decodeCell[A16](ss, i16)
      f17 ← RowDecoder.decodeCell[A17](ss, i17)
      f18 ← RowDecoder.decodeCell[A18](ss, i18)
      f19 ← RowDecoder.decodeCell[A19](ss, i19)
      f20 ← RowDecoder.decodeCell[A20](ss, i20)
      f21 ← RowDecoder.decodeCell[A21](ss, i21)
    } yield f(f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, f17, f18, f19, f20, f21))

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int, i21: Int, i22: Int)
    *
    * scala> RowDecoder.decoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21)(Ints.apply _).decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22"))
    * res21: DecodeResult[Ints] = Success(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22))
    * }}}
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f`
    * @param i14 index of the cell that should be passed as parameter number 14 of `f`
    * @param i15 index of the cell that should be passed as parameter number 15 of `f`
    * @param i16 index of the cell that should be passed as parameter number 16 of `f`
    * @param i17 index of the cell that should be passed as parameter number 17 of `f`
    * @param i18 index of the cell that should be passed as parameter number 18 of `f`
    * @param i19 index of the cell that should be passed as parameter number 19 of `f`
    * @param i20 index of the cell that should be passed as parameter number 20 of `f`
    * @param i21 index of the cell that should be passed as parameter number 21 of `f`
    * @param i22 index of the cell that should be passed as parameter number 22 of `f`
    */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder, A14: CellDecoder, A15: CellDecoder, A16: CellDecoder, A17: CellDecoder, A18: CellDecoder, A19: CellDecoder, A20: CellDecoder, A21: CellDecoder, A22: CellDecoder, R](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int, i21: Int, i22: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22) ⇒ R): RowDecoder[R] =
    RowDecoder.from(ss ⇒ for {
      f1 ← RowDecoder.decodeCell[A1](ss, i1)
      f2 ← RowDecoder.decodeCell[A2](ss, i2)
      f3 ← RowDecoder.decodeCell[A3](ss, i3)
      f4 ← RowDecoder.decodeCell[A4](ss, i4)
      f5 ← RowDecoder.decodeCell[A5](ss, i5)
      f6 ← RowDecoder.decodeCell[A6](ss, i6)
      f7 ← RowDecoder.decodeCell[A7](ss, i7)
      f8 ← RowDecoder.decodeCell[A8](ss, i8)
      f9 ← RowDecoder.decodeCell[A9](ss, i9)
      f10 ← RowDecoder.decodeCell[A10](ss, i10)
      f11 ← RowDecoder.decodeCell[A11](ss, i11)
      f12 ← RowDecoder.decodeCell[A12](ss, i12)
      f13 ← RowDecoder.decodeCell[A13](ss, i13)
      f14 ← RowDecoder.decodeCell[A14](ss, i14)
      f15 ← RowDecoder.decodeCell[A15](ss, i15)
      f16 ← RowDecoder.decodeCell[A16](ss, i16)
      f17 ← RowDecoder.decodeCell[A17](ss, i17)
      f18 ← RowDecoder.decodeCell[A18](ss, i18)
      f19 ← RowDecoder.decodeCell[A19](ss, i19)
      f20 ← RowDecoder.decodeCell[A20](ss, i20)
      f21 ← RowDecoder.decodeCell[A21](ss, i21)
      f22 ← RowDecoder.decodeCell[A22](ss, i22)
    } yield f(f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, f17, f18, f19, f20, f21, f22))

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * Cells are mapped to arguments of `f` in the order they are found. For example:
    * {{{
    * scala> case class Ints(i1: Int)
    *
    * scala> RowDecoder.ordered(Ints.apply _).decode(Seq("1"))
    * res0: DecodeResult[Ints] = Success(Ints(1))
    * }}}
    *
    */
  def ordered[A1: CellDecoder, R](f: (A1) ⇒ R): RowDecoder[R] =
      decoder(0)(f)

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * Cells are mapped to arguments of `f` in the order they are found. For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int)
    *
    * scala> RowDecoder.ordered(Ints.apply _).decode(Seq("1", "2"))
    * res1: DecodeResult[Ints] = Success(Ints(1,2))
    * }}}
    *
    */
  def ordered[A1: CellDecoder, A2: CellDecoder, R](f: (A1, A2) ⇒ R): RowDecoder[R] =
      decoder(0, 1)(f)

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * Cells are mapped to arguments of `f` in the order they are found. For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int)
    *
    * scala> RowDecoder.ordered(Ints.apply _).decode(Seq("1", "2", "3"))
    * res2: DecodeResult[Ints] = Success(Ints(1,2,3))
    * }}}
    *
    */
  def ordered[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, R](f: (A1, A2, A3) ⇒ R): RowDecoder[R] =
      decoder(0, 1, 2)(f)

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * Cells are mapped to arguments of `f` in the order they are found. For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int)
    *
    * scala> RowDecoder.ordered(Ints.apply _).decode(Seq("1", "2", "3", "4"))
    * res3: DecodeResult[Ints] = Success(Ints(1,2,3,4))
    * }}}
    *
    */
  def ordered[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, R](f: (A1, A2, A3, A4) ⇒ R): RowDecoder[R] =
      decoder(0, 1, 2, 3)(f)

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * Cells are mapped to arguments of `f` in the order they are found. For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int)
    *
    * scala> RowDecoder.ordered(Ints.apply _).decode(Seq("1", "2", "3", "4", "5"))
    * res4: DecodeResult[Ints] = Success(Ints(1,2,3,4,5))
    * }}}
    *
    */
  def ordered[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, R](f: (A1, A2, A3, A4, A5) ⇒ R): RowDecoder[R] =
      decoder(0, 1, 2, 3, 4)(f)

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * Cells are mapped to arguments of `f` in the order they are found. For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int)
    *
    * scala> RowDecoder.ordered(Ints.apply _).decode(Seq("1", "2", "3", "4", "5", "6"))
    * res5: DecodeResult[Ints] = Success(Ints(1,2,3,4,5,6))
    * }}}
    *
    */
  def ordered[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, R](f: (A1, A2, A3, A4, A5, A6) ⇒ R): RowDecoder[R] =
      decoder(0, 1, 2, 3, 4, 5)(f)

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * Cells are mapped to arguments of `f` in the order they are found. For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int)
    *
    * scala> RowDecoder.ordered(Ints.apply _).decode(Seq("1", "2", "3", "4", "5", "6", "7"))
    * res6: DecodeResult[Ints] = Success(Ints(1,2,3,4,5,6,7))
    * }}}
    *
    */
  def ordered[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, R](f: (A1, A2, A3, A4, A5, A6, A7) ⇒ R): RowDecoder[R] =
      decoder(0, 1, 2, 3, 4, 5, 6)(f)

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * Cells are mapped to arguments of `f` in the order they are found. For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int)
    *
    * scala> RowDecoder.ordered(Ints.apply _).decode(Seq("1", "2", "3", "4", "5", "6", "7", "8"))
    * res7: DecodeResult[Ints] = Success(Ints(1,2,3,4,5,6,7,8))
    * }}}
    *
    */
  def ordered[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, R](f: (A1, A2, A3, A4, A5, A6, A7, A8) ⇒ R): RowDecoder[R] =
      decoder(0, 1, 2, 3, 4, 5, 6, 7)(f)

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * Cells are mapped to arguments of `f` in the order they are found. For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int)
    *
    * scala> RowDecoder.ordered(Ints.apply _).decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9"))
    * res8: DecodeResult[Ints] = Success(Ints(1,2,3,4,5,6,7,8,9))
    * }}}
    *
    */
  def ordered[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, R](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9) ⇒ R): RowDecoder[R] =
      decoder(0, 1, 2, 3, 4, 5, 6, 7, 8)(f)

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * Cells are mapped to arguments of `f` in the order they are found. For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int)
    *
    * scala> RowDecoder.ordered(Ints.apply _).decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10"))
    * res9: DecodeResult[Ints] = Success(Ints(1,2,3,4,5,6,7,8,9,10))
    * }}}
    *
    */
  def ordered[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, R](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10) ⇒ R): RowDecoder[R] =
      decoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9)(f)

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * Cells are mapped to arguments of `f` in the order they are found. For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int)
    *
    * scala> RowDecoder.ordered(Ints.apply _).decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11"))
    * res10: DecodeResult[Ints] = Success(Ints(1,2,3,4,5,6,7,8,9,10,11))
    * }}}
    *
    */
  def ordered[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, R](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11) ⇒ R): RowDecoder[R] =
      decoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10)(f)

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * Cells are mapped to arguments of `f` in the order they are found. For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int)
    *
    * scala> RowDecoder.ordered(Ints.apply _).decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"))
    * res11: DecodeResult[Ints] = Success(Ints(1,2,3,4,5,6,7,8,9,10,11,12))
    * }}}
    *
    */
  def ordered[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, R](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12) ⇒ R): RowDecoder[R] =
      decoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11)(f)

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * Cells are mapped to arguments of `f` in the order they are found. For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int)
    *
    * scala> RowDecoder.ordered(Ints.apply _).decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13"))
    * res12: DecodeResult[Ints] = Success(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13))
    * }}}
    *
    */
  def ordered[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder, R](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13) ⇒ R): RowDecoder[R] =
      decoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12)(f)

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * Cells are mapped to arguments of `f` in the order they are found. For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int)
    *
    * scala> RowDecoder.ordered(Ints.apply _).decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14"))
    * res13: DecodeResult[Ints] = Success(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14))
    * }}}
    *
    */
  def ordered[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder, A14: CellDecoder, R](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14) ⇒ R): RowDecoder[R] =
      decoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13)(f)

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * Cells are mapped to arguments of `f` in the order they are found. For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int)
    *
    * scala> RowDecoder.ordered(Ints.apply _).decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"))
    * res14: DecodeResult[Ints] = Success(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15))
    * }}}
    *
    */
  def ordered[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder, A14: CellDecoder, A15: CellDecoder, R](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15) ⇒ R): RowDecoder[R] =
      decoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14)(f)

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * Cells are mapped to arguments of `f` in the order they are found. For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int)
    *
    * scala> RowDecoder.ordered(Ints.apply _).decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16"))
    * res15: DecodeResult[Ints] = Success(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16))
    * }}}
    *
    */
  def ordered[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder, A14: CellDecoder, A15: CellDecoder, A16: CellDecoder, R](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16) ⇒ R): RowDecoder[R] =
      decoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)(f)

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * Cells are mapped to arguments of `f` in the order they are found. For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int)
    *
    * scala> RowDecoder.ordered(Ints.apply _).decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17"))
    * res16: DecodeResult[Ints] = Success(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17))
    * }}}
    *
    */
  def ordered[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder, A14: CellDecoder, A15: CellDecoder, A16: CellDecoder, A17: CellDecoder, R](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17) ⇒ R): RowDecoder[R] =
      decoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16)(f)

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * Cells are mapped to arguments of `f` in the order they are found. For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int)
    *
    * scala> RowDecoder.ordered(Ints.apply _).decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18"))
    * res17: DecodeResult[Ints] = Success(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18))
    * }}}
    *
    */
  def ordered[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder, A14: CellDecoder, A15: CellDecoder, A16: CellDecoder, A17: CellDecoder, A18: CellDecoder, R](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18) ⇒ R): RowDecoder[R] =
      decoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17)(f)

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * Cells are mapped to arguments of `f` in the order they are found. For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int)
    *
    * scala> RowDecoder.ordered(Ints.apply _).decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19"))
    * res18: DecodeResult[Ints] = Success(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19))
    * }}}
    *
    */
  def ordered[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder, A14: CellDecoder, A15: CellDecoder, A16: CellDecoder, A17: CellDecoder, A18: CellDecoder, A19: CellDecoder, R](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19) ⇒ R): RowDecoder[R] =
      decoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18)(f)

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * Cells are mapped to arguments of `f` in the order they are found. For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int)
    *
    * scala> RowDecoder.ordered(Ints.apply _).decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20"))
    * res19: DecodeResult[Ints] = Success(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20))
    * }}}
    *
    */
  def ordered[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder, A14: CellDecoder, A15: CellDecoder, A16: CellDecoder, A17: CellDecoder, A18: CellDecoder, A19: CellDecoder, A20: CellDecoder, R](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20) ⇒ R): RowDecoder[R] =
      decoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19)(f)

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * Cells are mapped to arguments of `f` in the order they are found. For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int, i21: Int)
    *
    * scala> RowDecoder.ordered(Ints.apply _).decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21"))
    * res20: DecodeResult[Ints] = Success(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21))
    * }}}
    *
    */
  def ordered[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder, A14: CellDecoder, A15: CellDecoder, A16: CellDecoder, A17: CellDecoder, A18: CellDecoder, A19: CellDecoder, A20: CellDecoder, A21: CellDecoder, R](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21) ⇒ R): RowDecoder[R] =
      decoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20)(f)

  /** Creates a new [[RowDecoder]] from the specified function.
    *
    * Cells are mapped to arguments of `f` in the order they are found. For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int, i21: Int, i22: Int)
    *
    * scala> RowDecoder.ordered(Ints.apply _).decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22"))
    * res21: DecodeResult[Ints] = Success(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22))
    * }}}
    *
    */
  def ordered[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder, A14: CellDecoder, A15: CellDecoder, A16: CellDecoder, A17: CellDecoder, A18: CellDecoder, A19: CellDecoder, A20: CellDecoder, A21: CellDecoder, A22: CellDecoder, R](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22) ⇒ R): RowDecoder[R] =
      decoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21)(f)
}
