// auto-generated by sbt-boilerplate
/*
 * Copyright 2015 Nicolas Rinaudo
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package kantan.csv

/** Defines [[RowDecoder]] instances for types with various arities. */
trait GeneratedRowCodecs {
  private def combine[A](decoder: RowDecoder[A])(encoder: RowEncoder[A]): RowCodec[A] =
    RowCodec.from(decoder.decode _)(encoder.encode _)

  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
   *
   * @example
   * {{{
   * scala> case class Ints(i1: Int)
   *
   * scala> val codec = RowCodec.codec(Ints.apply _)((is: Ints) ⇒ (is.i1))
   *
   * scala> codec.encode(Ints(1))
   * res0: Seq[String] = List(1)
   *
   * scala> codec.decode(Seq("1"))
   * res1: DecodeResult[Ints] = Right(Ints(1))
   * }}}
   */
  def codec[C, A1: CellEncoder: CellDecoder](f: A1 ⇒ C)(g: C ⇒ A1): RowCodec[C] =
    combine(RowDecoder.decoder(0)(f))(RowEncoder.encoder(g))

  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int)
    *
    * scala> val codec = RowCodec.codec(0, 1)(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2))
    *
    * scala> codec.encode(Ints(1, 2))
    * res1: Seq[String] = WrappedArray(1, 2)
    *
    * scala> codec.decode(Seq("1", "2"))
    * res2: DecodeResult[Ints] = Right(Ints(1,2))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f` and will be at index 1 of
    *           the value returned by `g`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f` and will be at index 2 of
    *           the value returned by `g`
    */
  def codec[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder](i1: Int, i2: Int)(f: (A1, A2) ⇒ C)(g: C ⇒ (A1, A2)): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2)(f))(RowEncoder.encoder(i1, i2)(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int)
    *
    * scala> val codec = RowCodec.codec(0, 1, 2)(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3))
    *
    * scala> codec.encode(Ints(1, 2, 3))
    * res2: Seq[String] = WrappedArray(1, 2, 3)
    *
    * scala> codec.decode(Seq("1", "2", "3"))
    * res3: DecodeResult[Ints] = Right(Ints(1,2,3))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f` and will be at index 1 of
    *           the value returned by `g`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f` and will be at index 2 of
    *           the value returned by `g`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f` and will be at index 3 of
    *           the value returned by `g`
    */
  def codec[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder](i1: Int, i2: Int, i3: Int)(f: (A1, A2, A3) ⇒ C)(g: C ⇒ (A1, A2, A3)): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3)(f))(RowEncoder.encoder(i1, i2, i3)(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int)
    *
    * scala> val codec = RowCodec.codec(0, 1, 2, 3)(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3, is.i4))
    *
    * scala> codec.encode(Ints(1, 2, 3, 4))
    * res3: Seq[String] = WrappedArray(1, 2, 3, 4)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4"))
    * res4: DecodeResult[Ints] = Right(Ints(1,2,3,4))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f` and will be at index 1 of
    *           the value returned by `g`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f` and will be at index 2 of
    *           the value returned by `g`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f` and will be at index 3 of
    *           the value returned by `g`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f` and will be at index 4 of
    *           the value returned by `g`
    */
  def codec[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder, A4: CellEncoder: CellDecoder](i1: Int, i2: Int, i3: Int, i4: Int)(f: (A1, A2, A3, A4) ⇒ C)(g: C ⇒ (A1, A2, A3, A4)): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3, i4)(f))(RowEncoder.encoder(i1, i2, i3, i4)(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int)
    *
    * scala> val codec = RowCodec.codec(0, 1, 2, 3, 4)(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3, is.i4, is.i5))
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5))
    * res4: Seq[String] = WrappedArray(1, 2, 3, 4, 5)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5"))
    * res5: DecodeResult[Ints] = Right(Ints(1,2,3,4,5))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f` and will be at index 1 of
    *           the value returned by `g`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f` and will be at index 2 of
    *           the value returned by `g`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f` and will be at index 3 of
    *           the value returned by `g`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f` and will be at index 4 of
    *           the value returned by `g`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f` and will be at index 5 of
    *           the value returned by `g`
    */
  def codec[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder, A4: CellEncoder: CellDecoder, A5: CellEncoder: CellDecoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int)(f: (A1, A2, A3, A4, A5) ⇒ C)(g: C ⇒ (A1, A2, A3, A4, A5)): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3, i4, i5)(f))(RowEncoder.encoder(i1, i2, i3, i4, i5)(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int)
    *
    * scala> val codec = RowCodec.codec(0, 1, 2, 3, 4, 5)(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6))
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6))
    * res5: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6"))
    * res6: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f` and will be at index 1 of
    *           the value returned by `g`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f` and will be at index 2 of
    *           the value returned by `g`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f` and will be at index 3 of
    *           the value returned by `g`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f` and will be at index 4 of
    *           the value returned by `g`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f` and will be at index 5 of
    *           the value returned by `g`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f` and will be at index 6 of
    *           the value returned by `g`
    */
  def codec[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder, A4: CellEncoder: CellDecoder, A5: CellEncoder: CellDecoder, A6: CellEncoder: CellDecoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int)(f: (A1, A2, A3, A4, A5, A6) ⇒ C)(g: C ⇒ (A1, A2, A3, A4, A5, A6)): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3, i4, i5, i6)(f))(RowEncoder.encoder(i1, i2, i3, i4, i5, i6)(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int)
    *
    * scala> val codec = RowCodec.codec(0, 1, 2, 3, 4, 5, 6)(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7))
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7))
    * res6: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7"))
    * res7: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f` and will be at index 1 of
    *           the value returned by `g`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f` and will be at index 2 of
    *           the value returned by `g`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f` and will be at index 3 of
    *           the value returned by `g`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f` and will be at index 4 of
    *           the value returned by `g`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f` and will be at index 5 of
    *           the value returned by `g`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f` and will be at index 6 of
    *           the value returned by `g`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f` and will be at index 7 of
    *           the value returned by `g`
    */
  def codec[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder, A4: CellEncoder: CellDecoder, A5: CellEncoder: CellDecoder, A6: CellEncoder: CellDecoder, A7: CellEncoder: CellDecoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int)(f: (A1, A2, A3, A4, A5, A6, A7) ⇒ C)(g: C ⇒ (A1, A2, A3, A4, A5, A6, A7)): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3, i4, i5, i6, i7)(f))(RowEncoder.encoder(i1, i2, i3, i4, i5, i6, i7)(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int)
    *
    * scala> val codec = RowCodec.codec(0, 1, 2, 3, 4, 5, 6, 7)(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8))
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8))
    * res7: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8"))
    * res8: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f` and will be at index 1 of
    *           the value returned by `g`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f` and will be at index 2 of
    *           the value returned by `g`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f` and will be at index 3 of
    *           the value returned by `g`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f` and will be at index 4 of
    *           the value returned by `g`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f` and will be at index 5 of
    *           the value returned by `g`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f` and will be at index 6 of
    *           the value returned by `g`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f` and will be at index 7 of
    *           the value returned by `g`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f` and will be at index 8 of
    *           the value returned by `g`
    */
  def codec[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder, A4: CellEncoder: CellDecoder, A5: CellEncoder: CellDecoder, A6: CellEncoder: CellDecoder, A7: CellEncoder: CellDecoder, A8: CellEncoder: CellDecoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8) ⇒ C)(g: C ⇒ (A1, A2, A3, A4, A5, A6, A7, A8)): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3, i4, i5, i6, i7, i8)(f))(RowEncoder.encoder(i1, i2, i3, i4, i5, i6, i7, i8)(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int)
    *
    * scala> val codec = RowCodec.codec(0, 1, 2, 3, 4, 5, 6, 7, 8)(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9))
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9))
    * res8: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9"))
    * res9: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f` and will be at index 1 of
    *           the value returned by `g`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f` and will be at index 2 of
    *           the value returned by `g`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f` and will be at index 3 of
    *           the value returned by `g`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f` and will be at index 4 of
    *           the value returned by `g`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f` and will be at index 5 of
    *           the value returned by `g`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f` and will be at index 6 of
    *           the value returned by `g`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f` and will be at index 7 of
    *           the value returned by `g`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f` and will be at index 8 of
    *           the value returned by `g`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f` and will be at index 9 of
    *           the value returned by `g`
    */
  def codec[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder, A4: CellEncoder: CellDecoder, A5: CellEncoder: CellDecoder, A6: CellEncoder: CellDecoder, A7: CellEncoder: CellDecoder, A8: CellEncoder: CellDecoder, A9: CellEncoder: CellDecoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9) ⇒ C)(g: C ⇒ (A1, A2, A3, A4, A5, A6, A7, A8, A9)): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3, i4, i5, i6, i7, i8, i9)(f))(RowEncoder.encoder(i1, i2, i3, i4, i5, i6, i7, i8, i9)(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int)
    *
    * scala> val codec = RowCodec.codec(0, 1, 2, 3, 4, 5, 6, 7, 8, 9)(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10))
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10))
    * res9: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10"))
    * res10: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f` and will be at index 1 of
    *           the value returned by `g`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f` and will be at index 2 of
    *           the value returned by `g`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f` and will be at index 3 of
    *           the value returned by `g`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f` and will be at index 4 of
    *           the value returned by `g`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f` and will be at index 5 of
    *           the value returned by `g`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f` and will be at index 6 of
    *           the value returned by `g`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f` and will be at index 7 of
    *           the value returned by `g`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f` and will be at index 8 of
    *           the value returned by `g`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f` and will be at index 9 of
    *           the value returned by `g`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f` and will be at index 10 of
    *           the value returned by `g`
    */
  def codec[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder, A4: CellEncoder: CellDecoder, A5: CellEncoder: CellDecoder, A6: CellEncoder: CellDecoder, A7: CellEncoder: CellDecoder, A8: CellEncoder: CellDecoder, A9: CellEncoder: CellDecoder, A10: CellEncoder: CellDecoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10) ⇒ C)(g: C ⇒ (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10)): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10)(f))(RowEncoder.encoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10)(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int)
    *
    * scala> val codec = RowCodec.codec(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10)(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11))
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11))
    * res10: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11"))
    * res11: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f` and will be at index 1 of
    *           the value returned by `g`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f` and will be at index 2 of
    *           the value returned by `g`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f` and will be at index 3 of
    *           the value returned by `g`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f` and will be at index 4 of
    *           the value returned by `g`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f` and will be at index 5 of
    *           the value returned by `g`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f` and will be at index 6 of
    *           the value returned by `g`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f` and will be at index 7 of
    *           the value returned by `g`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f` and will be at index 8 of
    *           the value returned by `g`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f` and will be at index 9 of
    *           the value returned by `g`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f` and will be at index 10 of
    *           the value returned by `g`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f` and will be at index 11 of
    *           the value returned by `g`
    */
  def codec[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder, A4: CellEncoder: CellDecoder, A5: CellEncoder: CellDecoder, A6: CellEncoder: CellDecoder, A7: CellEncoder: CellDecoder, A8: CellEncoder: CellDecoder, A9: CellEncoder: CellDecoder, A10: CellEncoder: CellDecoder, A11: CellEncoder: CellDecoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11) ⇒ C)(g: C ⇒ (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11)): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11)(f))(RowEncoder.encoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11)(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int)
    *
    * scala> val codec = RowCodec.codec(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11)(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12))
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12))
    * res11: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"))
    * res12: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f` and will be at index 1 of
    *           the value returned by `g`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f` and will be at index 2 of
    *           the value returned by `g`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f` and will be at index 3 of
    *           the value returned by `g`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f` and will be at index 4 of
    *           the value returned by `g`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f` and will be at index 5 of
    *           the value returned by `g`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f` and will be at index 6 of
    *           the value returned by `g`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f` and will be at index 7 of
    *           the value returned by `g`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f` and will be at index 8 of
    *           the value returned by `g`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f` and will be at index 9 of
    *           the value returned by `g`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f` and will be at index 10 of
    *           the value returned by `g`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f` and will be at index 11 of
    *           the value returned by `g`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f` and will be at index 12 of
    *           the value returned by `g`
    */
  def codec[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder, A4: CellEncoder: CellDecoder, A5: CellEncoder: CellDecoder, A6: CellEncoder: CellDecoder, A7: CellEncoder: CellDecoder, A8: CellEncoder: CellDecoder, A9: CellEncoder: CellDecoder, A10: CellEncoder: CellDecoder, A11: CellEncoder: CellDecoder, A12: CellEncoder: CellDecoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12) ⇒ C)(g: C ⇒ (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12)): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12)(f))(RowEncoder.encoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12)(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int)
    *
    * scala> val codec = RowCodec.codec(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12)(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13))
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13))
    * res12: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13"))
    * res13: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f` and will be at index 1 of
    *           the value returned by `g`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f` and will be at index 2 of
    *           the value returned by `g`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f` and will be at index 3 of
    *           the value returned by `g`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f` and will be at index 4 of
    *           the value returned by `g`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f` and will be at index 5 of
    *           the value returned by `g`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f` and will be at index 6 of
    *           the value returned by `g`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f` and will be at index 7 of
    *           the value returned by `g`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f` and will be at index 8 of
    *           the value returned by `g`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f` and will be at index 9 of
    *           the value returned by `g`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f` and will be at index 10 of
    *           the value returned by `g`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f` and will be at index 11 of
    *           the value returned by `g`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f` and will be at index 12 of
    *           the value returned by `g`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f` and will be at index 13 of
    *           the value returned by `g`
    */
  def codec[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder, A4: CellEncoder: CellDecoder, A5: CellEncoder: CellDecoder, A6: CellEncoder: CellDecoder, A7: CellEncoder: CellDecoder, A8: CellEncoder: CellDecoder, A9: CellEncoder: CellDecoder, A10: CellEncoder: CellDecoder, A11: CellEncoder: CellDecoder, A12: CellEncoder: CellDecoder, A13: CellEncoder: CellDecoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13) ⇒ C)(g: C ⇒ (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13)): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13)(f))(RowEncoder.encoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13)(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int)
    *
    * scala> val codec = RowCodec.codec(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13)(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13, is.i14))
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14))
    * res13: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14"))
    * res14: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f` and will be at index 1 of
    *           the value returned by `g`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f` and will be at index 2 of
    *           the value returned by `g`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f` and will be at index 3 of
    *           the value returned by `g`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f` and will be at index 4 of
    *           the value returned by `g`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f` and will be at index 5 of
    *           the value returned by `g`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f` and will be at index 6 of
    *           the value returned by `g`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f` and will be at index 7 of
    *           the value returned by `g`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f` and will be at index 8 of
    *           the value returned by `g`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f` and will be at index 9 of
    *           the value returned by `g`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f` and will be at index 10 of
    *           the value returned by `g`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f` and will be at index 11 of
    *           the value returned by `g`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f` and will be at index 12 of
    *           the value returned by `g`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f` and will be at index 13 of
    *           the value returned by `g`
    * @param i14 index of the cell that should be passed as parameter number 14 of `f` and will be at index 14 of
    *           the value returned by `g`
    */
  def codec[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder, A4: CellEncoder: CellDecoder, A5: CellEncoder: CellDecoder, A6: CellEncoder: CellDecoder, A7: CellEncoder: CellDecoder, A8: CellEncoder: CellDecoder, A9: CellEncoder: CellDecoder, A10: CellEncoder: CellDecoder, A11: CellEncoder: CellDecoder, A12: CellEncoder: CellDecoder, A13: CellEncoder: CellDecoder, A14: CellEncoder: CellDecoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14) ⇒ C)(g: C ⇒ (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14)): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14)(f))(RowEncoder.encoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14)(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int)
    *
    * scala> val codec = RowCodec.codec(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14)(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13, is.i14, is.i15))
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15))
    * res14: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"))
    * res15: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f` and will be at index 1 of
    *           the value returned by `g`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f` and will be at index 2 of
    *           the value returned by `g`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f` and will be at index 3 of
    *           the value returned by `g`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f` and will be at index 4 of
    *           the value returned by `g`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f` and will be at index 5 of
    *           the value returned by `g`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f` and will be at index 6 of
    *           the value returned by `g`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f` and will be at index 7 of
    *           the value returned by `g`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f` and will be at index 8 of
    *           the value returned by `g`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f` and will be at index 9 of
    *           the value returned by `g`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f` and will be at index 10 of
    *           the value returned by `g`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f` and will be at index 11 of
    *           the value returned by `g`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f` and will be at index 12 of
    *           the value returned by `g`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f` and will be at index 13 of
    *           the value returned by `g`
    * @param i14 index of the cell that should be passed as parameter number 14 of `f` and will be at index 14 of
    *           the value returned by `g`
    * @param i15 index of the cell that should be passed as parameter number 15 of `f` and will be at index 15 of
    *           the value returned by `g`
    */
  def codec[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder, A4: CellEncoder: CellDecoder, A5: CellEncoder: CellDecoder, A6: CellEncoder: CellDecoder, A7: CellEncoder: CellDecoder, A8: CellEncoder: CellDecoder, A9: CellEncoder: CellDecoder, A10: CellEncoder: CellDecoder, A11: CellEncoder: CellDecoder, A12: CellEncoder: CellDecoder, A13: CellEncoder: CellDecoder, A14: CellEncoder: CellDecoder, A15: CellEncoder: CellDecoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15) ⇒ C)(g: C ⇒ (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15)): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15)(f))(RowEncoder.encoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15)(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int)
    *
    * scala> val codec = RowCodec.codec(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13, is.i14, is.i15, is.i16))
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16))
    * res15: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16"))
    * res16: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f` and will be at index 1 of
    *           the value returned by `g`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f` and will be at index 2 of
    *           the value returned by `g`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f` and will be at index 3 of
    *           the value returned by `g`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f` and will be at index 4 of
    *           the value returned by `g`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f` and will be at index 5 of
    *           the value returned by `g`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f` and will be at index 6 of
    *           the value returned by `g`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f` and will be at index 7 of
    *           the value returned by `g`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f` and will be at index 8 of
    *           the value returned by `g`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f` and will be at index 9 of
    *           the value returned by `g`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f` and will be at index 10 of
    *           the value returned by `g`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f` and will be at index 11 of
    *           the value returned by `g`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f` and will be at index 12 of
    *           the value returned by `g`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f` and will be at index 13 of
    *           the value returned by `g`
    * @param i14 index of the cell that should be passed as parameter number 14 of `f` and will be at index 14 of
    *           the value returned by `g`
    * @param i15 index of the cell that should be passed as parameter number 15 of `f` and will be at index 15 of
    *           the value returned by `g`
    * @param i16 index of the cell that should be passed as parameter number 16 of `f` and will be at index 16 of
    *           the value returned by `g`
    */
  def codec[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder, A4: CellEncoder: CellDecoder, A5: CellEncoder: CellDecoder, A6: CellEncoder: CellDecoder, A7: CellEncoder: CellDecoder, A8: CellEncoder: CellDecoder, A9: CellEncoder: CellDecoder, A10: CellEncoder: CellDecoder, A11: CellEncoder: CellDecoder, A12: CellEncoder: CellDecoder, A13: CellEncoder: CellDecoder, A14: CellEncoder: CellDecoder, A15: CellEncoder: CellDecoder, A16: CellEncoder: CellDecoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16) ⇒ C)(g: C ⇒ (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16)): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16)(f))(RowEncoder.encoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16)(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int)
    *
    * scala> val codec = RowCodec.codec(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16)(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13, is.i14, is.i15, is.i16, is.i17))
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17))
    * res16: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17"))
    * res17: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f` and will be at index 1 of
    *           the value returned by `g`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f` and will be at index 2 of
    *           the value returned by `g`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f` and will be at index 3 of
    *           the value returned by `g`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f` and will be at index 4 of
    *           the value returned by `g`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f` and will be at index 5 of
    *           the value returned by `g`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f` and will be at index 6 of
    *           the value returned by `g`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f` and will be at index 7 of
    *           the value returned by `g`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f` and will be at index 8 of
    *           the value returned by `g`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f` and will be at index 9 of
    *           the value returned by `g`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f` and will be at index 10 of
    *           the value returned by `g`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f` and will be at index 11 of
    *           the value returned by `g`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f` and will be at index 12 of
    *           the value returned by `g`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f` and will be at index 13 of
    *           the value returned by `g`
    * @param i14 index of the cell that should be passed as parameter number 14 of `f` and will be at index 14 of
    *           the value returned by `g`
    * @param i15 index of the cell that should be passed as parameter number 15 of `f` and will be at index 15 of
    *           the value returned by `g`
    * @param i16 index of the cell that should be passed as parameter number 16 of `f` and will be at index 16 of
    *           the value returned by `g`
    * @param i17 index of the cell that should be passed as parameter number 17 of `f` and will be at index 17 of
    *           the value returned by `g`
    */
  def codec[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder, A4: CellEncoder: CellDecoder, A5: CellEncoder: CellDecoder, A6: CellEncoder: CellDecoder, A7: CellEncoder: CellDecoder, A8: CellEncoder: CellDecoder, A9: CellEncoder: CellDecoder, A10: CellEncoder: CellDecoder, A11: CellEncoder: CellDecoder, A12: CellEncoder: CellDecoder, A13: CellEncoder: CellDecoder, A14: CellEncoder: CellDecoder, A15: CellEncoder: CellDecoder, A16: CellEncoder: CellDecoder, A17: CellEncoder: CellDecoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17) ⇒ C)(g: C ⇒ (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17)): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17)(f))(RowEncoder.encoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17)(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int)
    *
    * scala> val codec = RowCodec.codec(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17)(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13, is.i14, is.i15, is.i16, is.i17, is.i18))
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18))
    * res17: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18"))
    * res18: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f` and will be at index 1 of
    *           the value returned by `g`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f` and will be at index 2 of
    *           the value returned by `g`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f` and will be at index 3 of
    *           the value returned by `g`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f` and will be at index 4 of
    *           the value returned by `g`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f` and will be at index 5 of
    *           the value returned by `g`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f` and will be at index 6 of
    *           the value returned by `g`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f` and will be at index 7 of
    *           the value returned by `g`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f` and will be at index 8 of
    *           the value returned by `g`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f` and will be at index 9 of
    *           the value returned by `g`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f` and will be at index 10 of
    *           the value returned by `g`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f` and will be at index 11 of
    *           the value returned by `g`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f` and will be at index 12 of
    *           the value returned by `g`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f` and will be at index 13 of
    *           the value returned by `g`
    * @param i14 index of the cell that should be passed as parameter number 14 of `f` and will be at index 14 of
    *           the value returned by `g`
    * @param i15 index of the cell that should be passed as parameter number 15 of `f` and will be at index 15 of
    *           the value returned by `g`
    * @param i16 index of the cell that should be passed as parameter number 16 of `f` and will be at index 16 of
    *           the value returned by `g`
    * @param i17 index of the cell that should be passed as parameter number 17 of `f` and will be at index 17 of
    *           the value returned by `g`
    * @param i18 index of the cell that should be passed as parameter number 18 of `f` and will be at index 18 of
    *           the value returned by `g`
    */
  def codec[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder, A4: CellEncoder: CellDecoder, A5: CellEncoder: CellDecoder, A6: CellEncoder: CellDecoder, A7: CellEncoder: CellDecoder, A8: CellEncoder: CellDecoder, A9: CellEncoder: CellDecoder, A10: CellEncoder: CellDecoder, A11: CellEncoder: CellDecoder, A12: CellEncoder: CellDecoder, A13: CellEncoder: CellDecoder, A14: CellEncoder: CellDecoder, A15: CellEncoder: CellDecoder, A16: CellEncoder: CellDecoder, A17: CellEncoder: CellDecoder, A18: CellEncoder: CellDecoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18) ⇒ C)(g: C ⇒ (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18)): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18)(f))(RowEncoder.encoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18)(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int)
    *
    * scala> val codec = RowCodec.codec(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18)(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13, is.i14, is.i15, is.i16, is.i17, is.i18, is.i19))
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19))
    * res18: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19"))
    * res19: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f` and will be at index 1 of
    *           the value returned by `g`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f` and will be at index 2 of
    *           the value returned by `g`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f` and will be at index 3 of
    *           the value returned by `g`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f` and will be at index 4 of
    *           the value returned by `g`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f` and will be at index 5 of
    *           the value returned by `g`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f` and will be at index 6 of
    *           the value returned by `g`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f` and will be at index 7 of
    *           the value returned by `g`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f` and will be at index 8 of
    *           the value returned by `g`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f` and will be at index 9 of
    *           the value returned by `g`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f` and will be at index 10 of
    *           the value returned by `g`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f` and will be at index 11 of
    *           the value returned by `g`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f` and will be at index 12 of
    *           the value returned by `g`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f` and will be at index 13 of
    *           the value returned by `g`
    * @param i14 index of the cell that should be passed as parameter number 14 of `f` and will be at index 14 of
    *           the value returned by `g`
    * @param i15 index of the cell that should be passed as parameter number 15 of `f` and will be at index 15 of
    *           the value returned by `g`
    * @param i16 index of the cell that should be passed as parameter number 16 of `f` and will be at index 16 of
    *           the value returned by `g`
    * @param i17 index of the cell that should be passed as parameter number 17 of `f` and will be at index 17 of
    *           the value returned by `g`
    * @param i18 index of the cell that should be passed as parameter number 18 of `f` and will be at index 18 of
    *           the value returned by `g`
    * @param i19 index of the cell that should be passed as parameter number 19 of `f` and will be at index 19 of
    *           the value returned by `g`
    */
  def codec[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder, A4: CellEncoder: CellDecoder, A5: CellEncoder: CellDecoder, A6: CellEncoder: CellDecoder, A7: CellEncoder: CellDecoder, A8: CellEncoder: CellDecoder, A9: CellEncoder: CellDecoder, A10: CellEncoder: CellDecoder, A11: CellEncoder: CellDecoder, A12: CellEncoder: CellDecoder, A13: CellEncoder: CellDecoder, A14: CellEncoder: CellDecoder, A15: CellEncoder: CellDecoder, A16: CellEncoder: CellDecoder, A17: CellEncoder: CellDecoder, A18: CellEncoder: CellDecoder, A19: CellEncoder: CellDecoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19) ⇒ C)(g: C ⇒ (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19)): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19)(f))(RowEncoder.encoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19)(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int)
    *
    * scala> val codec = RowCodec.codec(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19)(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13, is.i14, is.i15, is.i16, is.i17, is.i18, is.i19, is.i20))
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20))
    * res19: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20"))
    * res20: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f` and will be at index 1 of
    *           the value returned by `g`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f` and will be at index 2 of
    *           the value returned by `g`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f` and will be at index 3 of
    *           the value returned by `g`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f` and will be at index 4 of
    *           the value returned by `g`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f` and will be at index 5 of
    *           the value returned by `g`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f` and will be at index 6 of
    *           the value returned by `g`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f` and will be at index 7 of
    *           the value returned by `g`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f` and will be at index 8 of
    *           the value returned by `g`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f` and will be at index 9 of
    *           the value returned by `g`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f` and will be at index 10 of
    *           the value returned by `g`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f` and will be at index 11 of
    *           the value returned by `g`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f` and will be at index 12 of
    *           the value returned by `g`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f` and will be at index 13 of
    *           the value returned by `g`
    * @param i14 index of the cell that should be passed as parameter number 14 of `f` and will be at index 14 of
    *           the value returned by `g`
    * @param i15 index of the cell that should be passed as parameter number 15 of `f` and will be at index 15 of
    *           the value returned by `g`
    * @param i16 index of the cell that should be passed as parameter number 16 of `f` and will be at index 16 of
    *           the value returned by `g`
    * @param i17 index of the cell that should be passed as parameter number 17 of `f` and will be at index 17 of
    *           the value returned by `g`
    * @param i18 index of the cell that should be passed as parameter number 18 of `f` and will be at index 18 of
    *           the value returned by `g`
    * @param i19 index of the cell that should be passed as parameter number 19 of `f` and will be at index 19 of
    *           the value returned by `g`
    * @param i20 index of the cell that should be passed as parameter number 20 of `f` and will be at index 20 of
    *           the value returned by `g`
    */
  def codec[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder, A4: CellEncoder: CellDecoder, A5: CellEncoder: CellDecoder, A6: CellEncoder: CellDecoder, A7: CellEncoder: CellDecoder, A8: CellEncoder: CellDecoder, A9: CellEncoder: CellDecoder, A10: CellEncoder: CellDecoder, A11: CellEncoder: CellDecoder, A12: CellEncoder: CellDecoder, A13: CellEncoder: CellDecoder, A14: CellEncoder: CellDecoder, A15: CellEncoder: CellDecoder, A16: CellEncoder: CellDecoder, A17: CellEncoder: CellDecoder, A18: CellEncoder: CellDecoder, A19: CellEncoder: CellDecoder, A20: CellEncoder: CellDecoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20) ⇒ C)(g: C ⇒ (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20)): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20)(f))(RowEncoder.encoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20)(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int, i21: Int)
    *
    * scala> val codec = RowCodec.codec(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20)(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13, is.i14, is.i15, is.i16, is.i17, is.i18, is.i19, is.i20, is.i21))
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21))
    * res20: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21"))
    * res21: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f` and will be at index 1 of
    *           the value returned by `g`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f` and will be at index 2 of
    *           the value returned by `g`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f` and will be at index 3 of
    *           the value returned by `g`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f` and will be at index 4 of
    *           the value returned by `g`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f` and will be at index 5 of
    *           the value returned by `g`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f` and will be at index 6 of
    *           the value returned by `g`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f` and will be at index 7 of
    *           the value returned by `g`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f` and will be at index 8 of
    *           the value returned by `g`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f` and will be at index 9 of
    *           the value returned by `g`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f` and will be at index 10 of
    *           the value returned by `g`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f` and will be at index 11 of
    *           the value returned by `g`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f` and will be at index 12 of
    *           the value returned by `g`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f` and will be at index 13 of
    *           the value returned by `g`
    * @param i14 index of the cell that should be passed as parameter number 14 of `f` and will be at index 14 of
    *           the value returned by `g`
    * @param i15 index of the cell that should be passed as parameter number 15 of `f` and will be at index 15 of
    *           the value returned by `g`
    * @param i16 index of the cell that should be passed as parameter number 16 of `f` and will be at index 16 of
    *           the value returned by `g`
    * @param i17 index of the cell that should be passed as parameter number 17 of `f` and will be at index 17 of
    *           the value returned by `g`
    * @param i18 index of the cell that should be passed as parameter number 18 of `f` and will be at index 18 of
    *           the value returned by `g`
    * @param i19 index of the cell that should be passed as parameter number 19 of `f` and will be at index 19 of
    *           the value returned by `g`
    * @param i20 index of the cell that should be passed as parameter number 20 of `f` and will be at index 20 of
    *           the value returned by `g`
    * @param i21 index of the cell that should be passed as parameter number 21 of `f` and will be at index 21 of
    *           the value returned by `g`
    */
  def codec[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder, A4: CellEncoder: CellDecoder, A5: CellEncoder: CellDecoder, A6: CellEncoder: CellDecoder, A7: CellEncoder: CellDecoder, A8: CellEncoder: CellDecoder, A9: CellEncoder: CellDecoder, A10: CellEncoder: CellDecoder, A11: CellEncoder: CellDecoder, A12: CellEncoder: CellDecoder, A13: CellEncoder: CellDecoder, A14: CellEncoder: CellDecoder, A15: CellEncoder: CellDecoder, A16: CellEncoder: CellDecoder, A17: CellEncoder: CellDecoder, A18: CellEncoder: CellDecoder, A19: CellEncoder: CellDecoder, A20: CellEncoder: CellDecoder, A21: CellEncoder: CellDecoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int, i21: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21) ⇒ C)(g: C ⇒ (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21)): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21)(f))(RowEncoder.encoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21)(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int, i21: Int, i22: Int)
    *
    * scala> val codec = RowCodec.codec(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21)(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13, is.i14, is.i15, is.i16, is.i17, is.i18, is.i19, is.i20, is.i21, is.i22))
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22))
    * res21: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22"))
    * res22: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f` and will be at index 1 of
    *           the value returned by `g`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f` and will be at index 2 of
    *           the value returned by `g`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f` and will be at index 3 of
    *           the value returned by `g`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f` and will be at index 4 of
    *           the value returned by `g`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f` and will be at index 5 of
    *           the value returned by `g`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f` and will be at index 6 of
    *           the value returned by `g`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f` and will be at index 7 of
    *           the value returned by `g`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f` and will be at index 8 of
    *           the value returned by `g`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f` and will be at index 9 of
    *           the value returned by `g`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f` and will be at index 10 of
    *           the value returned by `g`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f` and will be at index 11 of
    *           the value returned by `g`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f` and will be at index 12 of
    *           the value returned by `g`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f` and will be at index 13 of
    *           the value returned by `g`
    * @param i14 index of the cell that should be passed as parameter number 14 of `f` and will be at index 14 of
    *           the value returned by `g`
    * @param i15 index of the cell that should be passed as parameter number 15 of `f` and will be at index 15 of
    *           the value returned by `g`
    * @param i16 index of the cell that should be passed as parameter number 16 of `f` and will be at index 16 of
    *           the value returned by `g`
    * @param i17 index of the cell that should be passed as parameter number 17 of `f` and will be at index 17 of
    *           the value returned by `g`
    * @param i18 index of the cell that should be passed as parameter number 18 of `f` and will be at index 18 of
    *           the value returned by `g`
    * @param i19 index of the cell that should be passed as parameter number 19 of `f` and will be at index 19 of
    *           the value returned by `g`
    * @param i20 index of the cell that should be passed as parameter number 20 of `f` and will be at index 20 of
    *           the value returned by `g`
    * @param i21 index of the cell that should be passed as parameter number 21 of `f` and will be at index 21 of
    *           the value returned by `g`
    * @param i22 index of the cell that should be passed as parameter number 22 of `f` and will be at index 22 of
    *           the value returned by `g`
    */
  def codec[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder, A4: CellEncoder: CellDecoder, A5: CellEncoder: CellDecoder, A6: CellEncoder: CellDecoder, A7: CellEncoder: CellDecoder, A8: CellEncoder: CellDecoder, A9: CellEncoder: CellDecoder, A10: CellEncoder: CellDecoder, A11: CellEncoder: CellDecoder, A12: CellEncoder: CellDecoder, A13: CellEncoder: CellDecoder, A14: CellEncoder: CellDecoder, A15: CellEncoder: CellDecoder, A16: CellEncoder: CellDecoder, A17: CellEncoder: CellDecoder, A18: CellEncoder: CellDecoder, A19: CellEncoder: CellDecoder, A20: CellEncoder: CellDecoder, A21: CellEncoder: CellDecoder, A22: CellEncoder: CellDecoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int, i21: Int, i22: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22) ⇒ C)(g: C ⇒ (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22)): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22)(f))(RowEncoder.encoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22)(g))

  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int)
    *
    * scala> val codec = RowCodec.ordered(Ints.apply _)((is: Ints) ⇒ (is.i1))
    *
    * scala> codec.encode(Ints(1))
    * res0: Seq[String] = List(1)
    *
    * scala> codec.decode(Seq("1"))
    * res1: DecodeResult[Ints] = Right(Ints(1))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    */
  def ordered[C, A1: CellEncoder: CellDecoder](f: A1 ⇒ C)(g: C ⇒ A1): RowCodec[C] =
    combine(RowDecoder.decoder(0)(f))(RowEncoder.encoder(g))

  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int)
    *
    * scala> val codec = RowCodec.ordered(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2))
    *
    * scala> codec.encode(Ints(1, 2))
    * res1: Seq[String] = WrappedArray(1, 2)
    *
    * scala> codec.decode(Seq("1", "2"))
    * res2: DecodeResult[Ints] = Right(Ints(1,2))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    ]
    */
  def ordered[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder](f: (A1, A2) ⇒ C)(g: C ⇒ (A1, A2)): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.ordered(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int)
    *
    * scala> val codec = RowCodec.ordered(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3))
    *
    * scala> codec.encode(Ints(1, 2, 3))
    * res2: Seq[String] = WrappedArray(1, 2, 3)
    *
    * scala> codec.decode(Seq("1", "2", "3"))
    * res3: DecodeResult[Ints] = Right(Ints(1,2,3))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    ]
    */
  def ordered[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder](f: (A1, A2, A3) ⇒ C)(g: C ⇒ (A1, A2, A3)): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.ordered(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int)
    *
    * scala> val codec = RowCodec.ordered(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3, is.i4))
    *
    * scala> codec.encode(Ints(1, 2, 3, 4))
    * res3: Seq[String] = WrappedArray(1, 2, 3, 4)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4"))
    * res4: DecodeResult[Ints] = Right(Ints(1,2,3,4))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    ]
    */
  def ordered[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder, A4: CellEncoder: CellDecoder](f: (A1, A2, A3, A4) ⇒ C)(g: C ⇒ (A1, A2, A3, A4)): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.ordered(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int)
    *
    * scala> val codec = RowCodec.ordered(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3, is.i4, is.i5))
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5))
    * res4: Seq[String] = WrappedArray(1, 2, 3, 4, 5)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5"))
    * res5: DecodeResult[Ints] = Right(Ints(1,2,3,4,5))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    ]
    */
  def ordered[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder, A4: CellEncoder: CellDecoder, A5: CellEncoder: CellDecoder](f: (A1, A2, A3, A4, A5) ⇒ C)(g: C ⇒ (A1, A2, A3, A4, A5)): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.ordered(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int)
    *
    * scala> val codec = RowCodec.ordered(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6))
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6))
    * res5: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6"))
    * res6: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    ]
    */
  def ordered[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder, A4: CellEncoder: CellDecoder, A5: CellEncoder: CellDecoder, A6: CellEncoder: CellDecoder](f: (A1, A2, A3, A4, A5, A6) ⇒ C)(g: C ⇒ (A1, A2, A3, A4, A5, A6)): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.ordered(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int)
    *
    * scala> val codec = RowCodec.ordered(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7))
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7))
    * res6: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7"))
    * res7: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    ]
    */
  def ordered[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder, A4: CellEncoder: CellDecoder, A5: CellEncoder: CellDecoder, A6: CellEncoder: CellDecoder, A7: CellEncoder: CellDecoder](f: (A1, A2, A3, A4, A5, A6, A7) ⇒ C)(g: C ⇒ (A1, A2, A3, A4, A5, A6, A7)): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.ordered(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int)
    *
    * scala> val codec = RowCodec.ordered(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8))
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8))
    * res7: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8"))
    * res8: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    ]
    */
  def ordered[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder, A4: CellEncoder: CellDecoder, A5: CellEncoder: CellDecoder, A6: CellEncoder: CellDecoder, A7: CellEncoder: CellDecoder, A8: CellEncoder: CellDecoder](f: (A1, A2, A3, A4, A5, A6, A7, A8) ⇒ C)(g: C ⇒ (A1, A2, A3, A4, A5, A6, A7, A8)): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.ordered(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int)
    *
    * scala> val codec = RowCodec.ordered(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9))
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9))
    * res8: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9"))
    * res9: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    ]
    */
  def ordered[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder, A4: CellEncoder: CellDecoder, A5: CellEncoder: CellDecoder, A6: CellEncoder: CellDecoder, A7: CellEncoder: CellDecoder, A8: CellEncoder: CellDecoder, A9: CellEncoder: CellDecoder](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9) ⇒ C)(g: C ⇒ (A1, A2, A3, A4, A5, A6, A7, A8, A9)): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.ordered(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int)
    *
    * scala> val codec = RowCodec.ordered(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10))
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10))
    * res9: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10"))
    * res10: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    ]
    */
  def ordered[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder, A4: CellEncoder: CellDecoder, A5: CellEncoder: CellDecoder, A6: CellEncoder: CellDecoder, A7: CellEncoder: CellDecoder, A8: CellEncoder: CellDecoder, A9: CellEncoder: CellDecoder, A10: CellEncoder: CellDecoder](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10) ⇒ C)(g: C ⇒ (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10)): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.ordered(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int)
    *
    * scala> val codec = RowCodec.ordered(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11))
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11))
    * res10: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11"))
    * res11: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    ]
    */
  def ordered[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder, A4: CellEncoder: CellDecoder, A5: CellEncoder: CellDecoder, A6: CellEncoder: CellDecoder, A7: CellEncoder: CellDecoder, A8: CellEncoder: CellDecoder, A9: CellEncoder: CellDecoder, A10: CellEncoder: CellDecoder, A11: CellEncoder: CellDecoder](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11) ⇒ C)(g: C ⇒ (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11)): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.ordered(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int)
    *
    * scala> val codec = RowCodec.ordered(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12))
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12))
    * res11: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"))
    * res12: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    ]
    */
  def ordered[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder, A4: CellEncoder: CellDecoder, A5: CellEncoder: CellDecoder, A6: CellEncoder: CellDecoder, A7: CellEncoder: CellDecoder, A8: CellEncoder: CellDecoder, A9: CellEncoder: CellDecoder, A10: CellEncoder: CellDecoder, A11: CellEncoder: CellDecoder, A12: CellEncoder: CellDecoder](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12) ⇒ C)(g: C ⇒ (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12)): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.ordered(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int)
    *
    * scala> val codec = RowCodec.ordered(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13))
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13))
    * res12: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13"))
    * res13: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    ]
    */
  def ordered[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder, A4: CellEncoder: CellDecoder, A5: CellEncoder: CellDecoder, A6: CellEncoder: CellDecoder, A7: CellEncoder: CellDecoder, A8: CellEncoder: CellDecoder, A9: CellEncoder: CellDecoder, A10: CellEncoder: CellDecoder, A11: CellEncoder: CellDecoder, A12: CellEncoder: CellDecoder, A13: CellEncoder: CellDecoder](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13) ⇒ C)(g: C ⇒ (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13)): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.ordered(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int)
    *
    * scala> val codec = RowCodec.ordered(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13, is.i14))
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14))
    * res13: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14"))
    * res14: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    ]
    */
  def ordered[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder, A4: CellEncoder: CellDecoder, A5: CellEncoder: CellDecoder, A6: CellEncoder: CellDecoder, A7: CellEncoder: CellDecoder, A8: CellEncoder: CellDecoder, A9: CellEncoder: CellDecoder, A10: CellEncoder: CellDecoder, A11: CellEncoder: CellDecoder, A12: CellEncoder: CellDecoder, A13: CellEncoder: CellDecoder, A14: CellEncoder: CellDecoder](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14) ⇒ C)(g: C ⇒ (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14)): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.ordered(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int)
    *
    * scala> val codec = RowCodec.ordered(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13, is.i14, is.i15))
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15))
    * res14: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"))
    * res15: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    ]
    */
  def ordered[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder, A4: CellEncoder: CellDecoder, A5: CellEncoder: CellDecoder, A6: CellEncoder: CellDecoder, A7: CellEncoder: CellDecoder, A8: CellEncoder: CellDecoder, A9: CellEncoder: CellDecoder, A10: CellEncoder: CellDecoder, A11: CellEncoder: CellDecoder, A12: CellEncoder: CellDecoder, A13: CellEncoder: CellDecoder, A14: CellEncoder: CellDecoder, A15: CellEncoder: CellDecoder](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15) ⇒ C)(g: C ⇒ (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15)): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.ordered(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int)
    *
    * scala> val codec = RowCodec.ordered(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13, is.i14, is.i15, is.i16))
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16))
    * res15: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16"))
    * res16: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    ]
    */
  def ordered[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder, A4: CellEncoder: CellDecoder, A5: CellEncoder: CellDecoder, A6: CellEncoder: CellDecoder, A7: CellEncoder: CellDecoder, A8: CellEncoder: CellDecoder, A9: CellEncoder: CellDecoder, A10: CellEncoder: CellDecoder, A11: CellEncoder: CellDecoder, A12: CellEncoder: CellDecoder, A13: CellEncoder: CellDecoder, A14: CellEncoder: CellDecoder, A15: CellEncoder: CellDecoder, A16: CellEncoder: CellDecoder](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16) ⇒ C)(g: C ⇒ (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16)): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.ordered(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int)
    *
    * scala> val codec = RowCodec.ordered(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13, is.i14, is.i15, is.i16, is.i17))
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17))
    * res16: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17"))
    * res17: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    ]
    */
  def ordered[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder, A4: CellEncoder: CellDecoder, A5: CellEncoder: CellDecoder, A6: CellEncoder: CellDecoder, A7: CellEncoder: CellDecoder, A8: CellEncoder: CellDecoder, A9: CellEncoder: CellDecoder, A10: CellEncoder: CellDecoder, A11: CellEncoder: CellDecoder, A12: CellEncoder: CellDecoder, A13: CellEncoder: CellDecoder, A14: CellEncoder: CellDecoder, A15: CellEncoder: CellDecoder, A16: CellEncoder: CellDecoder, A17: CellEncoder: CellDecoder](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17) ⇒ C)(g: C ⇒ (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17)): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.ordered(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int)
    *
    * scala> val codec = RowCodec.ordered(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13, is.i14, is.i15, is.i16, is.i17, is.i18))
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18))
    * res17: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18"))
    * res18: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    ]
    */
  def ordered[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder, A4: CellEncoder: CellDecoder, A5: CellEncoder: CellDecoder, A6: CellEncoder: CellDecoder, A7: CellEncoder: CellDecoder, A8: CellEncoder: CellDecoder, A9: CellEncoder: CellDecoder, A10: CellEncoder: CellDecoder, A11: CellEncoder: CellDecoder, A12: CellEncoder: CellDecoder, A13: CellEncoder: CellDecoder, A14: CellEncoder: CellDecoder, A15: CellEncoder: CellDecoder, A16: CellEncoder: CellDecoder, A17: CellEncoder: CellDecoder, A18: CellEncoder: CellDecoder](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18) ⇒ C)(g: C ⇒ (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18)): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.ordered(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int)
    *
    * scala> val codec = RowCodec.ordered(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13, is.i14, is.i15, is.i16, is.i17, is.i18, is.i19))
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19))
    * res18: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19"))
    * res19: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    ]
    */
  def ordered[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder, A4: CellEncoder: CellDecoder, A5: CellEncoder: CellDecoder, A6: CellEncoder: CellDecoder, A7: CellEncoder: CellDecoder, A8: CellEncoder: CellDecoder, A9: CellEncoder: CellDecoder, A10: CellEncoder: CellDecoder, A11: CellEncoder: CellDecoder, A12: CellEncoder: CellDecoder, A13: CellEncoder: CellDecoder, A14: CellEncoder: CellDecoder, A15: CellEncoder: CellDecoder, A16: CellEncoder: CellDecoder, A17: CellEncoder: CellDecoder, A18: CellEncoder: CellDecoder, A19: CellEncoder: CellDecoder](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19) ⇒ C)(g: C ⇒ (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19)): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.ordered(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int)
    *
    * scala> val codec = RowCodec.ordered(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13, is.i14, is.i15, is.i16, is.i17, is.i18, is.i19, is.i20))
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20))
    * res19: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20"))
    * res20: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    ]
    */
  def ordered[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder, A4: CellEncoder: CellDecoder, A5: CellEncoder: CellDecoder, A6: CellEncoder: CellDecoder, A7: CellEncoder: CellDecoder, A8: CellEncoder: CellDecoder, A9: CellEncoder: CellDecoder, A10: CellEncoder: CellDecoder, A11: CellEncoder: CellDecoder, A12: CellEncoder: CellDecoder, A13: CellEncoder: CellDecoder, A14: CellEncoder: CellDecoder, A15: CellEncoder: CellDecoder, A16: CellEncoder: CellDecoder, A17: CellEncoder: CellDecoder, A18: CellEncoder: CellDecoder, A19: CellEncoder: CellDecoder, A20: CellEncoder: CellDecoder](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20) ⇒ C)(g: C ⇒ (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20)): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.ordered(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int, i21: Int)
    *
    * scala> val codec = RowCodec.ordered(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13, is.i14, is.i15, is.i16, is.i17, is.i18, is.i19, is.i20, is.i21))
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21))
    * res20: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21"))
    * res21: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    ]
    */
  def ordered[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder, A4: CellEncoder: CellDecoder, A5: CellEncoder: CellDecoder, A6: CellEncoder: CellDecoder, A7: CellEncoder: CellDecoder, A8: CellEncoder: CellDecoder, A9: CellEncoder: CellDecoder, A10: CellEncoder: CellDecoder, A11: CellEncoder: CellDecoder, A12: CellEncoder: CellDecoder, A13: CellEncoder: CellDecoder, A14: CellEncoder: CellDecoder, A15: CellEncoder: CellDecoder, A16: CellEncoder: CellDecoder, A17: CellEncoder: CellDecoder, A18: CellEncoder: CellDecoder, A19: CellEncoder: CellDecoder, A20: CellEncoder: CellDecoder, A21: CellEncoder: CellDecoder](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21) ⇒ C)(g: C ⇒ (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21)): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.ordered(g))
  /** Creates a new [[RowCodec]] instance from the specified encoding and decoding functions.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int, i21: Int, i22: Int)
    *
    * scala> val codec = RowCodec.ordered(Ints.apply _)((is: Ints) ⇒ (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13, is.i14, is.i15, is.i16, is.i17, is.i18, is.i19, is.i20, is.i21, is.i22))
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22))
    * res21: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22"))
    * res22: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22))
    * }}}
    *
    * @param f encoding function.
    * @param g decoding function.
    ]
    */
  def ordered[C, A1: CellEncoder: CellDecoder, A2: CellEncoder: CellDecoder, A3: CellEncoder: CellDecoder, A4: CellEncoder: CellDecoder, A5: CellEncoder: CellDecoder, A6: CellEncoder: CellDecoder, A7: CellEncoder: CellDecoder, A8: CellEncoder: CellDecoder, A9: CellEncoder: CellDecoder, A10: CellEncoder: CellDecoder, A11: CellEncoder: CellDecoder, A12: CellEncoder: CellDecoder, A13: CellEncoder: CellDecoder, A14: CellEncoder: CellDecoder, A15: CellEncoder: CellDecoder, A16: CellEncoder: CellDecoder, A17: CellEncoder: CellDecoder, A18: CellEncoder: CellDecoder, A19: CellEncoder: CellDecoder, A20: CellEncoder: CellDecoder, A21: CellEncoder: CellDecoder, A22: CellEncoder: CellDecoder](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22) ⇒ C)(g: C ⇒ (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22)): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.ordered(g))

  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int)
    *
    * scala> val codec = RowCodec.caseCodec(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1))
    * res0: Seq[String] = List(1)
    *
    * scala> codec.decode(Seq("1"))
    * res1: DecodeResult[Ints] = Right(Ints(1))
    * }}}
    */
  def caseCodec[C, A1: CellEncoder : CellDecoder](f: A1 ⇒ C)(g: C ⇒ Option[A1]): RowCodec[C] =
    combine(RowDecoder.decoder(0)(f))(RowEncoder.caseEncoder(g))

  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int)
    *
    * scala> val codec = RowCodec.caseCodec(0, 1)(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2))
    * res1: Seq[String] = WrappedArray(1, 2)
    *
    * scala> codec.decode(Seq("1", "2"))
    * res2: DecodeResult[Ints] = Right(Ints(1,2))
    * }}}
    */
  def caseCodec[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder](i1: Int, i2: Int)(f: (A1, A2) ⇒ C)(g: C ⇒ Option[Tuple2[A1, A2]]): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2)(f))(RowEncoder.caseEncoder(i1, i2)(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int)
    *
    * scala> val codec = RowCodec.caseCodec(0, 1, 2)(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3))
    * res2: Seq[String] = WrappedArray(1, 2, 3)
    *
    * scala> codec.decode(Seq("1", "2", "3"))
    * res3: DecodeResult[Ints] = Right(Ints(1,2,3))
    * }}}
    */
  def caseCodec[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder](i1: Int, i2: Int, i3: Int)(f: (A1, A2, A3) ⇒ C)(g: C ⇒ Option[Tuple3[A1, A2, A3]]): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3)(f))(RowEncoder.caseEncoder(i1, i2, i3)(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int)
    *
    * scala> val codec = RowCodec.caseCodec(0, 1, 2, 3)(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3, 4))
    * res3: Seq[String] = WrappedArray(1, 2, 3, 4)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4"))
    * res4: DecodeResult[Ints] = Right(Ints(1,2,3,4))
    * }}}
    */
  def caseCodec[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder, A4: CellEncoder : CellDecoder](i1: Int, i2: Int, i3: Int, i4: Int)(f: (A1, A2, A3, A4) ⇒ C)(g: C ⇒ Option[Tuple4[A1, A2, A3, A4]]): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3, i4)(f))(RowEncoder.caseEncoder(i1, i2, i3, i4)(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int)
    *
    * scala> val codec = RowCodec.caseCodec(0, 1, 2, 3, 4)(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5))
    * res4: Seq[String] = WrappedArray(1, 2, 3, 4, 5)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5"))
    * res5: DecodeResult[Ints] = Right(Ints(1,2,3,4,5))
    * }}}
    */
  def caseCodec[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder, A4: CellEncoder : CellDecoder, A5: CellEncoder : CellDecoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int)(f: (A1, A2, A3, A4, A5) ⇒ C)(g: C ⇒ Option[Tuple5[A1, A2, A3, A4, A5]]): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3, i4, i5)(f))(RowEncoder.caseEncoder(i1, i2, i3, i4, i5)(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int)
    *
    * scala> val codec = RowCodec.caseCodec(0, 1, 2, 3, 4, 5)(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6))
    * res5: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6"))
    * res6: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6))
    * }}}
    */
  def caseCodec[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder, A4: CellEncoder : CellDecoder, A5: CellEncoder : CellDecoder, A6: CellEncoder : CellDecoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int)(f: (A1, A2, A3, A4, A5, A6) ⇒ C)(g: C ⇒ Option[Tuple6[A1, A2, A3, A4, A5, A6]]): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3, i4, i5, i6)(f))(RowEncoder.caseEncoder(i1, i2, i3, i4, i5, i6)(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int)
    *
    * scala> val codec = RowCodec.caseCodec(0, 1, 2, 3, 4, 5, 6)(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7))
    * res6: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7"))
    * res7: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7))
    * }}}
    */
  def caseCodec[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder, A4: CellEncoder : CellDecoder, A5: CellEncoder : CellDecoder, A6: CellEncoder : CellDecoder, A7: CellEncoder : CellDecoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int)(f: (A1, A2, A3, A4, A5, A6, A7) ⇒ C)(g: C ⇒ Option[Tuple7[A1, A2, A3, A4, A5, A6, A7]]): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3, i4, i5, i6, i7)(f))(RowEncoder.caseEncoder(i1, i2, i3, i4, i5, i6, i7)(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int)
    *
    * scala> val codec = RowCodec.caseCodec(0, 1, 2, 3, 4, 5, 6, 7)(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8))
    * res7: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8"))
    * res8: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8))
    * }}}
    */
  def caseCodec[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder, A4: CellEncoder : CellDecoder, A5: CellEncoder : CellDecoder, A6: CellEncoder : CellDecoder, A7: CellEncoder : CellDecoder, A8: CellEncoder : CellDecoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8) ⇒ C)(g: C ⇒ Option[Tuple8[A1, A2, A3, A4, A5, A6, A7, A8]]): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3, i4, i5, i6, i7, i8)(f))(RowEncoder.caseEncoder(i1, i2, i3, i4, i5, i6, i7, i8)(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int)
    *
    * scala> val codec = RowCodec.caseCodec(0, 1, 2, 3, 4, 5, 6, 7, 8)(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9))
    * res8: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9"))
    * res9: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9))
    * }}}
    */
  def caseCodec[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder, A4: CellEncoder : CellDecoder, A5: CellEncoder : CellDecoder, A6: CellEncoder : CellDecoder, A7: CellEncoder : CellDecoder, A8: CellEncoder : CellDecoder, A9: CellEncoder : CellDecoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9) ⇒ C)(g: C ⇒ Option[Tuple9[A1, A2, A3, A4, A5, A6, A7, A8, A9]]): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3, i4, i5, i6, i7, i8, i9)(f))(RowEncoder.caseEncoder(i1, i2, i3, i4, i5, i6, i7, i8, i9)(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int)
    *
    * scala> val codec = RowCodec.caseCodec(0, 1, 2, 3, 4, 5, 6, 7, 8, 9)(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10))
    * res9: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10"))
    * res10: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10))
    * }}}
    */
  def caseCodec[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder, A4: CellEncoder : CellDecoder, A5: CellEncoder : CellDecoder, A6: CellEncoder : CellDecoder, A7: CellEncoder : CellDecoder, A8: CellEncoder : CellDecoder, A9: CellEncoder : CellDecoder, A10: CellEncoder : CellDecoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10) ⇒ C)(g: C ⇒ Option[Tuple10[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10]]): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10)(f))(RowEncoder.caseEncoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10)(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int)
    *
    * scala> val codec = RowCodec.caseCodec(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10)(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11))
    * res10: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11"))
    * res11: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11))
    * }}}
    */
  def caseCodec[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder, A4: CellEncoder : CellDecoder, A5: CellEncoder : CellDecoder, A6: CellEncoder : CellDecoder, A7: CellEncoder : CellDecoder, A8: CellEncoder : CellDecoder, A9: CellEncoder : CellDecoder, A10: CellEncoder : CellDecoder, A11: CellEncoder : CellDecoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11) ⇒ C)(g: C ⇒ Option[Tuple11[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11]]): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11)(f))(RowEncoder.caseEncoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11)(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int)
    *
    * scala> val codec = RowCodec.caseCodec(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11)(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12))
    * res11: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"))
    * res12: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12))
    * }}}
    */
  def caseCodec[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder, A4: CellEncoder : CellDecoder, A5: CellEncoder : CellDecoder, A6: CellEncoder : CellDecoder, A7: CellEncoder : CellDecoder, A8: CellEncoder : CellDecoder, A9: CellEncoder : CellDecoder, A10: CellEncoder : CellDecoder, A11: CellEncoder : CellDecoder, A12: CellEncoder : CellDecoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12) ⇒ C)(g: C ⇒ Option[Tuple12[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12]]): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12)(f))(RowEncoder.caseEncoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12)(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int)
    *
    * scala> val codec = RowCodec.caseCodec(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12)(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13))
    * res12: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13"))
    * res13: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13))
    * }}}
    */
  def caseCodec[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder, A4: CellEncoder : CellDecoder, A5: CellEncoder : CellDecoder, A6: CellEncoder : CellDecoder, A7: CellEncoder : CellDecoder, A8: CellEncoder : CellDecoder, A9: CellEncoder : CellDecoder, A10: CellEncoder : CellDecoder, A11: CellEncoder : CellDecoder, A12: CellEncoder : CellDecoder, A13: CellEncoder : CellDecoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13) ⇒ C)(g: C ⇒ Option[Tuple13[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13]]): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13)(f))(RowEncoder.caseEncoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13)(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int)
    *
    * scala> val codec = RowCodec.caseCodec(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13)(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14))
    * res13: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14"))
    * res14: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14))
    * }}}
    */
  def caseCodec[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder, A4: CellEncoder : CellDecoder, A5: CellEncoder : CellDecoder, A6: CellEncoder : CellDecoder, A7: CellEncoder : CellDecoder, A8: CellEncoder : CellDecoder, A9: CellEncoder : CellDecoder, A10: CellEncoder : CellDecoder, A11: CellEncoder : CellDecoder, A12: CellEncoder : CellDecoder, A13: CellEncoder : CellDecoder, A14: CellEncoder : CellDecoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14) ⇒ C)(g: C ⇒ Option[Tuple14[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14]]): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14)(f))(RowEncoder.caseEncoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14)(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int)
    *
    * scala> val codec = RowCodec.caseCodec(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14)(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15))
    * res14: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"))
    * res15: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15))
    * }}}
    */
  def caseCodec[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder, A4: CellEncoder : CellDecoder, A5: CellEncoder : CellDecoder, A6: CellEncoder : CellDecoder, A7: CellEncoder : CellDecoder, A8: CellEncoder : CellDecoder, A9: CellEncoder : CellDecoder, A10: CellEncoder : CellDecoder, A11: CellEncoder : CellDecoder, A12: CellEncoder : CellDecoder, A13: CellEncoder : CellDecoder, A14: CellEncoder : CellDecoder, A15: CellEncoder : CellDecoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15) ⇒ C)(g: C ⇒ Option[Tuple15[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15]]): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15)(f))(RowEncoder.caseEncoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15)(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int)
    *
    * scala> val codec = RowCodec.caseCodec(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16))
    * res15: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16"))
    * res16: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16))
    * }}}
    */
  def caseCodec[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder, A4: CellEncoder : CellDecoder, A5: CellEncoder : CellDecoder, A6: CellEncoder : CellDecoder, A7: CellEncoder : CellDecoder, A8: CellEncoder : CellDecoder, A9: CellEncoder : CellDecoder, A10: CellEncoder : CellDecoder, A11: CellEncoder : CellDecoder, A12: CellEncoder : CellDecoder, A13: CellEncoder : CellDecoder, A14: CellEncoder : CellDecoder, A15: CellEncoder : CellDecoder, A16: CellEncoder : CellDecoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16) ⇒ C)(g: C ⇒ Option[Tuple16[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16]]): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16)(f))(RowEncoder.caseEncoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16)(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int)
    *
    * scala> val codec = RowCodec.caseCodec(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16)(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17))
    * res16: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17"))
    * res17: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17))
    * }}}
    */
  def caseCodec[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder, A4: CellEncoder : CellDecoder, A5: CellEncoder : CellDecoder, A6: CellEncoder : CellDecoder, A7: CellEncoder : CellDecoder, A8: CellEncoder : CellDecoder, A9: CellEncoder : CellDecoder, A10: CellEncoder : CellDecoder, A11: CellEncoder : CellDecoder, A12: CellEncoder : CellDecoder, A13: CellEncoder : CellDecoder, A14: CellEncoder : CellDecoder, A15: CellEncoder : CellDecoder, A16: CellEncoder : CellDecoder, A17: CellEncoder : CellDecoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17) ⇒ C)(g: C ⇒ Option[Tuple17[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17]]): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17)(f))(RowEncoder.caseEncoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17)(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int)
    *
    * scala> val codec = RowCodec.caseCodec(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17)(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18))
    * res17: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18"))
    * res18: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18))
    * }}}
    */
  def caseCodec[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder, A4: CellEncoder : CellDecoder, A5: CellEncoder : CellDecoder, A6: CellEncoder : CellDecoder, A7: CellEncoder : CellDecoder, A8: CellEncoder : CellDecoder, A9: CellEncoder : CellDecoder, A10: CellEncoder : CellDecoder, A11: CellEncoder : CellDecoder, A12: CellEncoder : CellDecoder, A13: CellEncoder : CellDecoder, A14: CellEncoder : CellDecoder, A15: CellEncoder : CellDecoder, A16: CellEncoder : CellDecoder, A17: CellEncoder : CellDecoder, A18: CellEncoder : CellDecoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18) ⇒ C)(g: C ⇒ Option[Tuple18[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18]]): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18)(f))(RowEncoder.caseEncoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18)(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int)
    *
    * scala> val codec = RowCodec.caseCodec(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18)(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19))
    * res18: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19"))
    * res19: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19))
    * }}}
    */
  def caseCodec[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder, A4: CellEncoder : CellDecoder, A5: CellEncoder : CellDecoder, A6: CellEncoder : CellDecoder, A7: CellEncoder : CellDecoder, A8: CellEncoder : CellDecoder, A9: CellEncoder : CellDecoder, A10: CellEncoder : CellDecoder, A11: CellEncoder : CellDecoder, A12: CellEncoder : CellDecoder, A13: CellEncoder : CellDecoder, A14: CellEncoder : CellDecoder, A15: CellEncoder : CellDecoder, A16: CellEncoder : CellDecoder, A17: CellEncoder : CellDecoder, A18: CellEncoder : CellDecoder, A19: CellEncoder : CellDecoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19) ⇒ C)(g: C ⇒ Option[Tuple19[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19]]): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19)(f))(RowEncoder.caseEncoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19)(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int)
    *
    * scala> val codec = RowCodec.caseCodec(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19)(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20))
    * res19: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20"))
    * res20: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20))
    * }}}
    */
  def caseCodec[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder, A4: CellEncoder : CellDecoder, A5: CellEncoder : CellDecoder, A6: CellEncoder : CellDecoder, A7: CellEncoder : CellDecoder, A8: CellEncoder : CellDecoder, A9: CellEncoder : CellDecoder, A10: CellEncoder : CellDecoder, A11: CellEncoder : CellDecoder, A12: CellEncoder : CellDecoder, A13: CellEncoder : CellDecoder, A14: CellEncoder : CellDecoder, A15: CellEncoder : CellDecoder, A16: CellEncoder : CellDecoder, A17: CellEncoder : CellDecoder, A18: CellEncoder : CellDecoder, A19: CellEncoder : CellDecoder, A20: CellEncoder : CellDecoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20) ⇒ C)(g: C ⇒ Option[Tuple20[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20]]): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20)(f))(RowEncoder.caseEncoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20)(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int, i21: Int)
    *
    * scala> val codec = RowCodec.caseCodec(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20)(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21))
    * res20: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21"))
    * res21: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21))
    * }}}
    */
  def caseCodec[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder, A4: CellEncoder : CellDecoder, A5: CellEncoder : CellDecoder, A6: CellEncoder : CellDecoder, A7: CellEncoder : CellDecoder, A8: CellEncoder : CellDecoder, A9: CellEncoder : CellDecoder, A10: CellEncoder : CellDecoder, A11: CellEncoder : CellDecoder, A12: CellEncoder : CellDecoder, A13: CellEncoder : CellDecoder, A14: CellEncoder : CellDecoder, A15: CellEncoder : CellDecoder, A16: CellEncoder : CellDecoder, A17: CellEncoder : CellDecoder, A18: CellEncoder : CellDecoder, A19: CellEncoder : CellDecoder, A20: CellEncoder : CellDecoder, A21: CellEncoder : CellDecoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int, i21: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21) ⇒ C)(g: C ⇒ Option[Tuple21[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21]]): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21)(f))(RowEncoder.caseEncoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21)(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int, i21: Int, i22: Int)
    *
    * scala> val codec = RowCodec.caseCodec(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21)(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22))
    * res21: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22"))
    * res22: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22))
    * }}}
    */
  def caseCodec[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder, A4: CellEncoder : CellDecoder, A5: CellEncoder : CellDecoder, A6: CellEncoder : CellDecoder, A7: CellEncoder : CellDecoder, A8: CellEncoder : CellDecoder, A9: CellEncoder : CellDecoder, A10: CellEncoder : CellDecoder, A11: CellEncoder : CellDecoder, A12: CellEncoder : CellDecoder, A13: CellEncoder : CellDecoder, A14: CellEncoder : CellDecoder, A15: CellEncoder : CellDecoder, A16: CellEncoder : CellDecoder, A17: CellEncoder : CellDecoder, A18: CellEncoder : CellDecoder, A19: CellEncoder : CellDecoder, A20: CellEncoder : CellDecoder, A21: CellEncoder : CellDecoder, A22: CellEncoder : CellDecoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int, i21: Int, i22: Int)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22) ⇒ C)(g: C ⇒ Option[Tuple22[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22]]): RowCodec[C] =
    combine(RowDecoder.decoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22)(f))(RowEncoder.caseEncoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22)(g))

  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int)
    *
    * scala> val codec = RowCodec.caseOrdered(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1))
    * res0: Seq[String] = List(1)
    *
    * scala> codec.decode(Seq("1"))
    * res1: DecodeResult[Ints] = Right(Ints(1))
    * }}}
    */
  def caseOrdered[C, A1: CellEncoder : CellDecoder](f: A1 ⇒ C)(g: C ⇒ Option[A1]): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.caseOrdered(g))

  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int)
    *
    * scala> val codec = RowCodec.caseOrdered(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2))
    * res1: Seq[String] = WrappedArray(1, 2)
    *
    * scala> codec.decode(Seq("1", "2"))
    * res2: DecodeResult[Ints] = Right(Ints(1,2))
    * }}}
    */
  def caseOrdered[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder](f: (A1, A2) ⇒ C)(g: C ⇒ Option[Tuple2[A1, A2]]): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.caseOrdered(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int)
    *
    * scala> val codec = RowCodec.caseOrdered(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3))
    * res2: Seq[String] = WrappedArray(1, 2, 3)
    *
    * scala> codec.decode(Seq("1", "2", "3"))
    * res3: DecodeResult[Ints] = Right(Ints(1,2,3))
    * }}}
    */
  def caseOrdered[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder](f: (A1, A2, A3) ⇒ C)(g: C ⇒ Option[Tuple3[A1, A2, A3]]): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.caseOrdered(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int)
    *
    * scala> val codec = RowCodec.caseOrdered(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3, 4))
    * res3: Seq[String] = WrappedArray(1, 2, 3, 4)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4"))
    * res4: DecodeResult[Ints] = Right(Ints(1,2,3,4))
    * }}}
    */
  def caseOrdered[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder, A4: CellEncoder : CellDecoder](f: (A1, A2, A3, A4) ⇒ C)(g: C ⇒ Option[Tuple4[A1, A2, A3, A4]]): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.caseOrdered(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int)
    *
    * scala> val codec = RowCodec.caseOrdered(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5))
    * res4: Seq[String] = WrappedArray(1, 2, 3, 4, 5)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5"))
    * res5: DecodeResult[Ints] = Right(Ints(1,2,3,4,5))
    * }}}
    */
  def caseOrdered[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder, A4: CellEncoder : CellDecoder, A5: CellEncoder : CellDecoder](f: (A1, A2, A3, A4, A5) ⇒ C)(g: C ⇒ Option[Tuple5[A1, A2, A3, A4, A5]]): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.caseOrdered(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int)
    *
    * scala> val codec = RowCodec.caseOrdered(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6))
    * res5: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6"))
    * res6: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6))
    * }}}
    */
  def caseOrdered[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder, A4: CellEncoder : CellDecoder, A5: CellEncoder : CellDecoder, A6: CellEncoder : CellDecoder](f: (A1, A2, A3, A4, A5, A6) ⇒ C)(g: C ⇒ Option[Tuple6[A1, A2, A3, A4, A5, A6]]): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.caseOrdered(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int)
    *
    * scala> val codec = RowCodec.caseOrdered(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7))
    * res6: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7"))
    * res7: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7))
    * }}}
    */
  def caseOrdered[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder, A4: CellEncoder : CellDecoder, A5: CellEncoder : CellDecoder, A6: CellEncoder : CellDecoder, A7: CellEncoder : CellDecoder](f: (A1, A2, A3, A4, A5, A6, A7) ⇒ C)(g: C ⇒ Option[Tuple7[A1, A2, A3, A4, A5, A6, A7]]): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.caseOrdered(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int)
    *
    * scala> val codec = RowCodec.caseOrdered(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8))
    * res7: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8"))
    * res8: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8))
    * }}}
    */
  def caseOrdered[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder, A4: CellEncoder : CellDecoder, A5: CellEncoder : CellDecoder, A6: CellEncoder : CellDecoder, A7: CellEncoder : CellDecoder, A8: CellEncoder : CellDecoder](f: (A1, A2, A3, A4, A5, A6, A7, A8) ⇒ C)(g: C ⇒ Option[Tuple8[A1, A2, A3, A4, A5, A6, A7, A8]]): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.caseOrdered(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int)
    *
    * scala> val codec = RowCodec.caseOrdered(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9))
    * res8: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9"))
    * res9: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9))
    * }}}
    */
  def caseOrdered[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder, A4: CellEncoder : CellDecoder, A5: CellEncoder : CellDecoder, A6: CellEncoder : CellDecoder, A7: CellEncoder : CellDecoder, A8: CellEncoder : CellDecoder, A9: CellEncoder : CellDecoder](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9) ⇒ C)(g: C ⇒ Option[Tuple9[A1, A2, A3, A4, A5, A6, A7, A8, A9]]): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.caseOrdered(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int)
    *
    * scala> val codec = RowCodec.caseOrdered(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10))
    * res9: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10"))
    * res10: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10))
    * }}}
    */
  def caseOrdered[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder, A4: CellEncoder : CellDecoder, A5: CellEncoder : CellDecoder, A6: CellEncoder : CellDecoder, A7: CellEncoder : CellDecoder, A8: CellEncoder : CellDecoder, A9: CellEncoder : CellDecoder, A10: CellEncoder : CellDecoder](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10) ⇒ C)(g: C ⇒ Option[Tuple10[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10]]): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.caseOrdered(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int)
    *
    * scala> val codec = RowCodec.caseOrdered(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11))
    * res10: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11"))
    * res11: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11))
    * }}}
    */
  def caseOrdered[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder, A4: CellEncoder : CellDecoder, A5: CellEncoder : CellDecoder, A6: CellEncoder : CellDecoder, A7: CellEncoder : CellDecoder, A8: CellEncoder : CellDecoder, A9: CellEncoder : CellDecoder, A10: CellEncoder : CellDecoder, A11: CellEncoder : CellDecoder](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11) ⇒ C)(g: C ⇒ Option[Tuple11[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11]]): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.caseOrdered(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int)
    *
    * scala> val codec = RowCodec.caseOrdered(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12))
    * res11: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"))
    * res12: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12))
    * }}}
    */
  def caseOrdered[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder, A4: CellEncoder : CellDecoder, A5: CellEncoder : CellDecoder, A6: CellEncoder : CellDecoder, A7: CellEncoder : CellDecoder, A8: CellEncoder : CellDecoder, A9: CellEncoder : CellDecoder, A10: CellEncoder : CellDecoder, A11: CellEncoder : CellDecoder, A12: CellEncoder : CellDecoder](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12) ⇒ C)(g: C ⇒ Option[Tuple12[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12]]): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.caseOrdered(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int)
    *
    * scala> val codec = RowCodec.caseOrdered(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13))
    * res12: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13"))
    * res13: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13))
    * }}}
    */
  def caseOrdered[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder, A4: CellEncoder : CellDecoder, A5: CellEncoder : CellDecoder, A6: CellEncoder : CellDecoder, A7: CellEncoder : CellDecoder, A8: CellEncoder : CellDecoder, A9: CellEncoder : CellDecoder, A10: CellEncoder : CellDecoder, A11: CellEncoder : CellDecoder, A12: CellEncoder : CellDecoder, A13: CellEncoder : CellDecoder](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13) ⇒ C)(g: C ⇒ Option[Tuple13[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13]]): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.caseOrdered(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int)
    *
    * scala> val codec = RowCodec.caseOrdered(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14))
    * res13: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14"))
    * res14: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14))
    * }}}
    */
  def caseOrdered[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder, A4: CellEncoder : CellDecoder, A5: CellEncoder : CellDecoder, A6: CellEncoder : CellDecoder, A7: CellEncoder : CellDecoder, A8: CellEncoder : CellDecoder, A9: CellEncoder : CellDecoder, A10: CellEncoder : CellDecoder, A11: CellEncoder : CellDecoder, A12: CellEncoder : CellDecoder, A13: CellEncoder : CellDecoder, A14: CellEncoder : CellDecoder](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14) ⇒ C)(g: C ⇒ Option[Tuple14[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14]]): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.caseOrdered(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int)
    *
    * scala> val codec = RowCodec.caseOrdered(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15))
    * res14: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"))
    * res15: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15))
    * }}}
    */
  def caseOrdered[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder, A4: CellEncoder : CellDecoder, A5: CellEncoder : CellDecoder, A6: CellEncoder : CellDecoder, A7: CellEncoder : CellDecoder, A8: CellEncoder : CellDecoder, A9: CellEncoder : CellDecoder, A10: CellEncoder : CellDecoder, A11: CellEncoder : CellDecoder, A12: CellEncoder : CellDecoder, A13: CellEncoder : CellDecoder, A14: CellEncoder : CellDecoder, A15: CellEncoder : CellDecoder](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15) ⇒ C)(g: C ⇒ Option[Tuple15[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15]]): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.caseOrdered(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int)
    *
    * scala> val codec = RowCodec.caseOrdered(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16))
    * res15: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16"))
    * res16: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16))
    * }}}
    */
  def caseOrdered[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder, A4: CellEncoder : CellDecoder, A5: CellEncoder : CellDecoder, A6: CellEncoder : CellDecoder, A7: CellEncoder : CellDecoder, A8: CellEncoder : CellDecoder, A9: CellEncoder : CellDecoder, A10: CellEncoder : CellDecoder, A11: CellEncoder : CellDecoder, A12: CellEncoder : CellDecoder, A13: CellEncoder : CellDecoder, A14: CellEncoder : CellDecoder, A15: CellEncoder : CellDecoder, A16: CellEncoder : CellDecoder](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16) ⇒ C)(g: C ⇒ Option[Tuple16[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16]]): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.caseOrdered(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int)
    *
    * scala> val codec = RowCodec.caseOrdered(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17))
    * res16: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17"))
    * res17: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17))
    * }}}
    */
  def caseOrdered[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder, A4: CellEncoder : CellDecoder, A5: CellEncoder : CellDecoder, A6: CellEncoder : CellDecoder, A7: CellEncoder : CellDecoder, A8: CellEncoder : CellDecoder, A9: CellEncoder : CellDecoder, A10: CellEncoder : CellDecoder, A11: CellEncoder : CellDecoder, A12: CellEncoder : CellDecoder, A13: CellEncoder : CellDecoder, A14: CellEncoder : CellDecoder, A15: CellEncoder : CellDecoder, A16: CellEncoder : CellDecoder, A17: CellEncoder : CellDecoder](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17) ⇒ C)(g: C ⇒ Option[Tuple17[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17]]): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.caseOrdered(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int)
    *
    * scala> val codec = RowCodec.caseOrdered(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18))
    * res17: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18"))
    * res18: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18))
    * }}}
    */
  def caseOrdered[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder, A4: CellEncoder : CellDecoder, A5: CellEncoder : CellDecoder, A6: CellEncoder : CellDecoder, A7: CellEncoder : CellDecoder, A8: CellEncoder : CellDecoder, A9: CellEncoder : CellDecoder, A10: CellEncoder : CellDecoder, A11: CellEncoder : CellDecoder, A12: CellEncoder : CellDecoder, A13: CellEncoder : CellDecoder, A14: CellEncoder : CellDecoder, A15: CellEncoder : CellDecoder, A16: CellEncoder : CellDecoder, A17: CellEncoder : CellDecoder, A18: CellEncoder : CellDecoder](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18) ⇒ C)(g: C ⇒ Option[Tuple18[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18]]): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.caseOrdered(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int)
    *
    * scala> val codec = RowCodec.caseOrdered(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19))
    * res18: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19"))
    * res19: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19))
    * }}}
    */
  def caseOrdered[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder, A4: CellEncoder : CellDecoder, A5: CellEncoder : CellDecoder, A6: CellEncoder : CellDecoder, A7: CellEncoder : CellDecoder, A8: CellEncoder : CellDecoder, A9: CellEncoder : CellDecoder, A10: CellEncoder : CellDecoder, A11: CellEncoder : CellDecoder, A12: CellEncoder : CellDecoder, A13: CellEncoder : CellDecoder, A14: CellEncoder : CellDecoder, A15: CellEncoder : CellDecoder, A16: CellEncoder : CellDecoder, A17: CellEncoder : CellDecoder, A18: CellEncoder : CellDecoder, A19: CellEncoder : CellDecoder](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19) ⇒ C)(g: C ⇒ Option[Tuple19[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19]]): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.caseOrdered(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int)
    *
    * scala> val codec = RowCodec.caseOrdered(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20))
    * res19: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20"))
    * res20: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20))
    * }}}
    */
  def caseOrdered[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder, A4: CellEncoder : CellDecoder, A5: CellEncoder : CellDecoder, A6: CellEncoder : CellDecoder, A7: CellEncoder : CellDecoder, A8: CellEncoder : CellDecoder, A9: CellEncoder : CellDecoder, A10: CellEncoder : CellDecoder, A11: CellEncoder : CellDecoder, A12: CellEncoder : CellDecoder, A13: CellEncoder : CellDecoder, A14: CellEncoder : CellDecoder, A15: CellEncoder : CellDecoder, A16: CellEncoder : CellDecoder, A17: CellEncoder : CellDecoder, A18: CellEncoder : CellDecoder, A19: CellEncoder : CellDecoder, A20: CellEncoder : CellDecoder](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20) ⇒ C)(g: C ⇒ Option[Tuple20[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20]]): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.caseOrdered(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int, i21: Int)
    *
    * scala> val codec = RowCodec.caseOrdered(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21))
    * res20: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21"))
    * res21: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21))
    * }}}
    */
  def caseOrdered[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder, A4: CellEncoder : CellDecoder, A5: CellEncoder : CellDecoder, A6: CellEncoder : CellDecoder, A7: CellEncoder : CellDecoder, A8: CellEncoder : CellDecoder, A9: CellEncoder : CellDecoder, A10: CellEncoder : CellDecoder, A11: CellEncoder : CellDecoder, A12: CellEncoder : CellDecoder, A13: CellEncoder : CellDecoder, A14: CellEncoder : CellDecoder, A15: CellEncoder : CellDecoder, A16: CellEncoder : CellDecoder, A17: CellEncoder : CellDecoder, A18: CellEncoder : CellDecoder, A19: CellEncoder : CellDecoder, A20: CellEncoder : CellDecoder, A21: CellEncoder : CellDecoder](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21) ⇒ C)(g: C ⇒ Option[Tuple21[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21]]): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.caseOrdered(g))
  /** Creates a new [[RowCodec]] instance for the specified encoding and decoding functions.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `Some`, which allows `caseCodec` to call `get` on the return value.
    *
    * @example
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int, i21: Int, i22: Int)
    *
    * scala> val codec = RowCodec.caseOrdered(Ints.apply _)(Ints.unapply _)
    *
    * scala> codec.encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22))
    * res21: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22)
    *
    * scala> codec.decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22"))
    * res22: DecodeResult[Ints] = Right(Ints(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22))
    * }}}
    */
  def caseOrdered[C, A1: CellEncoder : CellDecoder, A2: CellEncoder : CellDecoder, A3: CellEncoder : CellDecoder, A4: CellEncoder : CellDecoder, A5: CellEncoder : CellDecoder, A6: CellEncoder : CellDecoder, A7: CellEncoder : CellDecoder, A8: CellEncoder : CellDecoder, A9: CellEncoder : CellDecoder, A10: CellEncoder : CellDecoder, A11: CellEncoder : CellDecoder, A12: CellEncoder : CellDecoder, A13: CellEncoder : CellDecoder, A14: CellEncoder : CellDecoder, A15: CellEncoder : CellDecoder, A16: CellEncoder : CellDecoder, A17: CellEncoder : CellDecoder, A18: CellEncoder : CellDecoder, A19: CellEncoder : CellDecoder, A20: CellEncoder : CellDecoder, A21: CellEncoder : CellDecoder, A22: CellEncoder : CellDecoder](f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22) ⇒ C)(g: C ⇒ Option[Tuple22[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22]]): RowCodec[C] =
    combine(RowDecoder.ordered(f))(RowEncoder.caseOrdered(g))
}
