// auto-generated by sbt-boilerplate
/*
 * Copyright 2015 Nicolas Rinaudo
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package kantan.csv

/** Provides [[RowDecoder]] and [[RowEncoder]] instances for tuples of any arity. */
trait TupleInstances {
  /** Provides an instance of [[RowDecoder]] for `Tuple1`, provided all internal types have an instance of [[CellDecoder]].
    *
    * @example
    * {{{
    * scala> RowDecoder[Tuple1[Int]].decode(Seq("1"))
    * res0: DecodeResult[Tuple1[Int]] = Right((1))
    * }}}
    */
   implicit def tupleRowDecoder1[A1: CellDecoder]: RowDecoder[Tuple1[A1]] =
    RowDecoder.ordered(Tuple1.apply[A1] _)

  /** Provides an instance of [[RowDecoder]] for `Tuple2`, provided all internal types have an instance of [[CellDecoder]].
    *
    * @example
    * {{{
    * scala> RowDecoder[Tuple2[Int, Int]].decode(Seq("1", "2"))
    * res1: DecodeResult[Tuple2[Int, Int]] = Right((1,2))
    * }}}
    */
   implicit def tupleRowDecoder2[A1: CellDecoder, A2: CellDecoder]: RowDecoder[Tuple2[A1, A2]] =
    RowDecoder.ordered(Tuple2.apply[A1, A2] _)

  /** Provides an instance of [[RowDecoder]] for `Tuple3`, provided all internal types have an instance of [[CellDecoder]].
    *
    * @example
    * {{{
    * scala> RowDecoder[Tuple3[Int, Int, Int]].decode(Seq("1", "2", "3"))
    * res2: DecodeResult[Tuple3[Int, Int, Int]] = Right((1,2,3))
    * }}}
    */
   implicit def tupleRowDecoder3[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder]: RowDecoder[Tuple3[A1, A2, A3]] =
    RowDecoder.ordered(Tuple3.apply[A1, A2, A3] _)

  /** Provides an instance of [[RowDecoder]] for `Tuple4`, provided all internal types have an instance of [[CellDecoder]].
    *
    * @example
    * {{{
    * scala> RowDecoder[Tuple4[Int, Int, Int, Int]].decode(Seq("1", "2", "3", "4"))
    * res3: DecodeResult[Tuple4[Int, Int, Int, Int]] = Right((1,2,3,4))
    * }}}
    */
   implicit def tupleRowDecoder4[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder]: RowDecoder[Tuple4[A1, A2, A3, A4]] =
    RowDecoder.ordered(Tuple4.apply[A1, A2, A3, A4] _)

  /** Provides an instance of [[RowDecoder]] for `Tuple5`, provided all internal types have an instance of [[CellDecoder]].
    *
    * @example
    * {{{
    * scala> RowDecoder[Tuple5[Int, Int, Int, Int, Int]].decode(Seq("1", "2", "3", "4", "5"))
    * res4: DecodeResult[Tuple5[Int, Int, Int, Int, Int]] = Right((1,2,3,4,5))
    * }}}
    */
   implicit def tupleRowDecoder5[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder]: RowDecoder[Tuple5[A1, A2, A3, A4, A5]] =
    RowDecoder.ordered(Tuple5.apply[A1, A2, A3, A4, A5] _)

  /** Provides an instance of [[RowDecoder]] for `Tuple6`, provided all internal types have an instance of [[CellDecoder]].
    *
    * @example
    * {{{
    * scala> RowDecoder[Tuple6[Int, Int, Int, Int, Int, Int]].decode(Seq("1", "2", "3", "4", "5", "6"))
    * res5: DecodeResult[Tuple6[Int, Int, Int, Int, Int, Int]] = Right((1,2,3,4,5,6))
    * }}}
    */
   implicit def tupleRowDecoder6[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder]: RowDecoder[Tuple6[A1, A2, A3, A4, A5, A6]] =
    RowDecoder.ordered(Tuple6.apply[A1, A2, A3, A4, A5, A6] _)

  /** Provides an instance of [[RowDecoder]] for `Tuple7`, provided all internal types have an instance of [[CellDecoder]].
    *
    * @example
    * {{{
    * scala> RowDecoder[Tuple7[Int, Int, Int, Int, Int, Int, Int]].decode(Seq("1", "2", "3", "4", "5", "6", "7"))
    * res6: DecodeResult[Tuple7[Int, Int, Int, Int, Int, Int, Int]] = Right((1,2,3,4,5,6,7))
    * }}}
    */
   implicit def tupleRowDecoder7[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder]: RowDecoder[Tuple7[A1, A2, A3, A4, A5, A6, A7]] =
    RowDecoder.ordered(Tuple7.apply[A1, A2, A3, A4, A5, A6, A7] _)

  /** Provides an instance of [[RowDecoder]] for `Tuple8`, provided all internal types have an instance of [[CellDecoder]].
    *
    * @example
    * {{{
    * scala> RowDecoder[Tuple8[Int, Int, Int, Int, Int, Int, Int, Int]].decode(Seq("1", "2", "3", "4", "5", "6", "7", "8"))
    * res7: DecodeResult[Tuple8[Int, Int, Int, Int, Int, Int, Int, Int]] = Right((1,2,3,4,5,6,7,8))
    * }}}
    */
   implicit def tupleRowDecoder8[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder]: RowDecoder[Tuple8[A1, A2, A3, A4, A5, A6, A7, A8]] =
    RowDecoder.ordered(Tuple8.apply[A1, A2, A3, A4, A5, A6, A7, A8] _)

  /** Provides an instance of [[RowDecoder]] for `Tuple9`, provided all internal types have an instance of [[CellDecoder]].
    *
    * @example
    * {{{
    * scala> RowDecoder[Tuple9[Int, Int, Int, Int, Int, Int, Int, Int, Int]].decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9"))
    * res8: DecodeResult[Tuple9[Int, Int, Int, Int, Int, Int, Int, Int, Int]] = Right((1,2,3,4,5,6,7,8,9))
    * }}}
    */
   implicit def tupleRowDecoder9[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder]: RowDecoder[Tuple9[A1, A2, A3, A4, A5, A6, A7, A8, A9]] =
    RowDecoder.ordered(Tuple9.apply[A1, A2, A3, A4, A5, A6, A7, A8, A9] _)

  /** Provides an instance of [[RowDecoder]] for `Tuple10`, provided all internal types have an instance of [[CellDecoder]].
    *
    * @example
    * {{{
    * scala> RowDecoder[Tuple10[Int, Int, Int, Int, Int, Int, Int, Int, Int, Int]].decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10"))
    * res9: DecodeResult[Tuple10[Int, Int, Int, Int, Int, Int, Int, Int, Int, Int]] = Right((1,2,3,4,5,6,7,8,9,10))
    * }}}
    */
   implicit def tupleRowDecoder10[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder]: RowDecoder[Tuple10[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10]] =
    RowDecoder.ordered(Tuple10.apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10] _)

  /** Provides an instance of [[RowDecoder]] for `Tuple11`, provided all internal types have an instance of [[CellDecoder]].
    *
    * @example
    * {{{
    * scala> RowDecoder[Tuple11[Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int]].decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11"))
    * res10: DecodeResult[Tuple11[Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int]] = Right((1,2,3,4,5,6,7,8,9,10,11))
    * }}}
    */
   implicit def tupleRowDecoder11[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder]: RowDecoder[Tuple11[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11]] =
    RowDecoder.ordered(Tuple11.apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11] _)

  /** Provides an instance of [[RowDecoder]] for `Tuple12`, provided all internal types have an instance of [[CellDecoder]].
    *
    * @example
    * {{{
    * scala> RowDecoder[Tuple12[Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int]].decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"))
    * res11: DecodeResult[Tuple12[Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int]] = Right((1,2,3,4,5,6,7,8,9,10,11,12))
    * }}}
    */
   implicit def tupleRowDecoder12[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder]: RowDecoder[Tuple12[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12]] =
    RowDecoder.ordered(Tuple12.apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12] _)

  /** Provides an instance of [[RowDecoder]] for `Tuple13`, provided all internal types have an instance of [[CellDecoder]].
    *
    * @example
    * {{{
    * scala> RowDecoder[Tuple13[Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int]].decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13"))
    * res12: DecodeResult[Tuple13[Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int]] = Right((1,2,3,4,5,6,7,8,9,10,11,12,13))
    * }}}
    */
   implicit def tupleRowDecoder13[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder]: RowDecoder[Tuple13[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13]] =
    RowDecoder.ordered(Tuple13.apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13] _)

  /** Provides an instance of [[RowDecoder]] for `Tuple14`, provided all internal types have an instance of [[CellDecoder]].
    *
    * @example
    * {{{
    * scala> RowDecoder[Tuple14[Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int]].decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14"))
    * res13: DecodeResult[Tuple14[Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int]] = Right((1,2,3,4,5,6,7,8,9,10,11,12,13,14))
    * }}}
    */
   implicit def tupleRowDecoder14[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder, A14: CellDecoder]: RowDecoder[Tuple14[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14]] =
    RowDecoder.ordered(Tuple14.apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14] _)

  /** Provides an instance of [[RowDecoder]] for `Tuple15`, provided all internal types have an instance of [[CellDecoder]].
    *
    * @example
    * {{{
    * scala> RowDecoder[Tuple15[Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int]].decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"))
    * res14: DecodeResult[Tuple15[Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int]] = Right((1,2,3,4,5,6,7,8,9,10,11,12,13,14,15))
    * }}}
    */
   implicit def tupleRowDecoder15[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder, A14: CellDecoder, A15: CellDecoder]: RowDecoder[Tuple15[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15]] =
    RowDecoder.ordered(Tuple15.apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15] _)

  /** Provides an instance of [[RowDecoder]] for `Tuple16`, provided all internal types have an instance of [[CellDecoder]].
    *
    * @example
    * {{{
    * scala> RowDecoder[Tuple16[Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int]].decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16"))
    * res15: DecodeResult[Tuple16[Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int]] = Right((1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16))
    * }}}
    */
   implicit def tupleRowDecoder16[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder, A14: CellDecoder, A15: CellDecoder, A16: CellDecoder]: RowDecoder[Tuple16[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16]] =
    RowDecoder.ordered(Tuple16.apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16] _)

  /** Provides an instance of [[RowDecoder]] for `Tuple17`, provided all internal types have an instance of [[CellDecoder]].
    *
    * @example
    * {{{
    * scala> RowDecoder[Tuple17[Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int]].decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17"))
    * res16: DecodeResult[Tuple17[Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int]] = Right((1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17))
    * }}}
    */
   implicit def tupleRowDecoder17[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder, A14: CellDecoder, A15: CellDecoder, A16: CellDecoder, A17: CellDecoder]: RowDecoder[Tuple17[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17]] =
    RowDecoder.ordered(Tuple17.apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17] _)

  /** Provides an instance of [[RowDecoder]] for `Tuple18`, provided all internal types have an instance of [[CellDecoder]].
    *
    * @example
    * {{{
    * scala> RowDecoder[Tuple18[Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int]].decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18"))
    * res17: DecodeResult[Tuple18[Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int]] = Right((1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18))
    * }}}
    */
   implicit def tupleRowDecoder18[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder, A14: CellDecoder, A15: CellDecoder, A16: CellDecoder, A17: CellDecoder, A18: CellDecoder]: RowDecoder[Tuple18[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18]] =
    RowDecoder.ordered(Tuple18.apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18] _)

  /** Provides an instance of [[RowDecoder]] for `Tuple19`, provided all internal types have an instance of [[CellDecoder]].
    *
    * @example
    * {{{
    * scala> RowDecoder[Tuple19[Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int]].decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19"))
    * res18: DecodeResult[Tuple19[Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int]] = Right((1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19))
    * }}}
    */
   implicit def tupleRowDecoder19[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder, A14: CellDecoder, A15: CellDecoder, A16: CellDecoder, A17: CellDecoder, A18: CellDecoder, A19: CellDecoder]: RowDecoder[Tuple19[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19]] =
    RowDecoder.ordered(Tuple19.apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19] _)

  /** Provides an instance of [[RowDecoder]] for `Tuple20`, provided all internal types have an instance of [[CellDecoder]].
    *
    * @example
    * {{{
    * scala> RowDecoder[Tuple20[Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int]].decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20"))
    * res19: DecodeResult[Tuple20[Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int]] = Right((1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20))
    * }}}
    */
   implicit def tupleRowDecoder20[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder, A14: CellDecoder, A15: CellDecoder, A16: CellDecoder, A17: CellDecoder, A18: CellDecoder, A19: CellDecoder, A20: CellDecoder]: RowDecoder[Tuple20[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20]] =
    RowDecoder.ordered(Tuple20.apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20] _)

  /** Provides an instance of [[RowDecoder]] for `Tuple21`, provided all internal types have an instance of [[CellDecoder]].
    *
    * @example
    * {{{
    * scala> RowDecoder[Tuple21[Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int]].decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21"))
    * res20: DecodeResult[Tuple21[Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int]] = Right((1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21))
    * }}}
    */
   implicit def tupleRowDecoder21[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder, A14: CellDecoder, A15: CellDecoder, A16: CellDecoder, A17: CellDecoder, A18: CellDecoder, A19: CellDecoder, A20: CellDecoder, A21: CellDecoder]: RowDecoder[Tuple21[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21]] =
    RowDecoder.ordered(Tuple21.apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21] _)

  /** Provides an instance of [[RowDecoder]] for `Tuple22`, provided all internal types have an instance of [[CellDecoder]].
    *
    * @example
    * {{{
    * scala> RowDecoder[Tuple22[Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int]].decode(Seq("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22"))
    * res21: DecodeResult[Tuple22[Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int]] = Right((1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22))
    * }}}
    */
   implicit def tupleRowDecoder22[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder, A14: CellDecoder, A15: CellDecoder, A16: CellDecoder, A17: CellDecoder, A18: CellDecoder, A19: CellDecoder, A20: CellDecoder, A21: CellDecoder, A22: CellDecoder]: RowDecoder[Tuple22[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22]] =
    RowDecoder.ordered(Tuple22.apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22] _)

  /** Provides an instance of [[RowEncoder]] for `Tuple1`, provided all internal types have an instance of [[CellEncoder]].
    *
    * @example
    * {{{
    * scala> RowEncoder[Tuple1[Int]].encode(Tuple1(1))
    * res0: Seq[String] = List(1)
    * }}}
    */
  implicit def tupleRowEncoder1[A1: CellEncoder]: RowEncoder[Tuple1[A1]] =
    RowEncoder.ordered((t: Tuple1[A1]) ⇒ t._1)

  /** Provides an instance of [[RowEncoder]] for `Tuple2`, provided all internal types have an instance of [[CellEncoder]].
    *
    * @example
    * {{{
    * scala> RowEncoder[Tuple2[Int, Int]].encode((1, 2))
    * res1: Seq[String] = WrappedArray(1, 2)
    * }}}
    */implicit def tupleRowEncoder2[A1: CellEncoder, A2: CellEncoder]: RowEncoder[Tuple2[A1, A2]] =
    RowEncoder.ordered((t: Tuple2[A1, A2]) ⇒ t)

  /** Provides an instance of [[RowEncoder]] for `Tuple3`, provided all internal types have an instance of [[CellEncoder]].
    *
    * @example
    * {{{
    * scala> RowEncoder[Tuple3[Int, Int, Int]].encode((1, 2, 3))
    * res2: Seq[String] = WrappedArray(1, 2, 3)
    * }}}
    */implicit def tupleRowEncoder3[A1: CellEncoder, A2: CellEncoder, A3: CellEncoder]: RowEncoder[Tuple3[A1, A2, A3]] =
    RowEncoder.ordered((t: Tuple3[A1, A2, A3]) ⇒ t)

  /** Provides an instance of [[RowEncoder]] for `Tuple4`, provided all internal types have an instance of [[CellEncoder]].
    *
    * @example
    * {{{
    * scala> RowEncoder[Tuple4[Int, Int, Int, Int]].encode((1, 2, 3, 4))
    * res3: Seq[String] = WrappedArray(1, 2, 3, 4)
    * }}}
    */implicit def tupleRowEncoder4[A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder]: RowEncoder[Tuple4[A1, A2, A3, A4]] =
    RowEncoder.ordered((t: Tuple4[A1, A2, A3, A4]) ⇒ t)

  /** Provides an instance of [[RowEncoder]] for `Tuple5`, provided all internal types have an instance of [[CellEncoder]].
    *
    * @example
    * {{{
    * scala> RowEncoder[Tuple5[Int, Int, Int, Int, Int]].encode((1, 2, 3, 4, 5))
    * res4: Seq[String] = WrappedArray(1, 2, 3, 4, 5)
    * }}}
    */implicit def tupleRowEncoder5[A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder]: RowEncoder[Tuple5[A1, A2, A3, A4, A5]] =
    RowEncoder.ordered((t: Tuple5[A1, A2, A3, A4, A5]) ⇒ t)

  /** Provides an instance of [[RowEncoder]] for `Tuple6`, provided all internal types have an instance of [[CellEncoder]].
    *
    * @example
    * {{{
    * scala> RowEncoder[Tuple6[Int, Int, Int, Int, Int, Int]].encode((1, 2, 3, 4, 5, 6))
    * res5: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6)
    * }}}
    */implicit def tupleRowEncoder6[A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder]: RowEncoder[Tuple6[A1, A2, A3, A4, A5, A6]] =
    RowEncoder.ordered((t: Tuple6[A1, A2, A3, A4, A5, A6]) ⇒ t)

  /** Provides an instance of [[RowEncoder]] for `Tuple7`, provided all internal types have an instance of [[CellEncoder]].
    *
    * @example
    * {{{
    * scala> RowEncoder[Tuple7[Int, Int, Int, Int, Int, Int, Int]].encode((1, 2, 3, 4, 5, 6, 7))
    * res6: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7)
    * }}}
    */implicit def tupleRowEncoder7[A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder]: RowEncoder[Tuple7[A1, A2, A3, A4, A5, A6, A7]] =
    RowEncoder.ordered((t: Tuple7[A1, A2, A3, A4, A5, A6, A7]) ⇒ t)

  /** Provides an instance of [[RowEncoder]] for `Tuple8`, provided all internal types have an instance of [[CellEncoder]].
    *
    * @example
    * {{{
    * scala> RowEncoder[Tuple8[Int, Int, Int, Int, Int, Int, Int, Int]].encode((1, 2, 3, 4, 5, 6, 7, 8))
    * res7: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8)
    * }}}
    */implicit def tupleRowEncoder8[A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder]: RowEncoder[Tuple8[A1, A2, A3, A4, A5, A6, A7, A8]] =
    RowEncoder.ordered((t: Tuple8[A1, A2, A3, A4, A5, A6, A7, A8]) ⇒ t)

  /** Provides an instance of [[RowEncoder]] for `Tuple9`, provided all internal types have an instance of [[CellEncoder]].
    *
    * @example
    * {{{
    * scala> RowEncoder[Tuple9[Int, Int, Int, Int, Int, Int, Int, Int, Int]].encode((1, 2, 3, 4, 5, 6, 7, 8, 9))
    * res8: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9)
    * }}}
    */implicit def tupleRowEncoder9[A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder]: RowEncoder[Tuple9[A1, A2, A3, A4, A5, A6, A7, A8, A9]] =
    RowEncoder.ordered((t: Tuple9[A1, A2, A3, A4, A5, A6, A7, A8, A9]) ⇒ t)

  /** Provides an instance of [[RowEncoder]] for `Tuple10`, provided all internal types have an instance of [[CellEncoder]].
    *
    * @example
    * {{{
    * scala> RowEncoder[Tuple10[Int, Int, Int, Int, Int, Int, Int, Int, Int, Int]].encode((1, 2, 3, 4, 5, 6, 7, 8, 9, 10))
    * res9: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10)
    * }}}
    */implicit def tupleRowEncoder10[A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder]: RowEncoder[Tuple10[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10]] =
    RowEncoder.ordered((t: Tuple10[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10]) ⇒ t)

  /** Provides an instance of [[RowEncoder]] for `Tuple11`, provided all internal types have an instance of [[CellEncoder]].
    *
    * @example
    * {{{
    * scala> RowEncoder[Tuple11[Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int]].encode((1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11))
    * res10: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11)
    * }}}
    */implicit def tupleRowEncoder11[A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder]: RowEncoder[Tuple11[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11]] =
    RowEncoder.ordered((t: Tuple11[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11]) ⇒ t)

  /** Provides an instance of [[RowEncoder]] for `Tuple12`, provided all internal types have an instance of [[CellEncoder]].
    *
    * @example
    * {{{
    * scala> RowEncoder[Tuple12[Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int]].encode((1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12))
    * res11: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12)
    * }}}
    */implicit def tupleRowEncoder12[A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder]: RowEncoder[Tuple12[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12]] =
    RowEncoder.ordered((t: Tuple12[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12]) ⇒ t)

  /** Provides an instance of [[RowEncoder]] for `Tuple13`, provided all internal types have an instance of [[CellEncoder]].
    *
    * @example
    * {{{
    * scala> RowEncoder[Tuple13[Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int]].encode((1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13))
    * res12: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13)
    * }}}
    */implicit def tupleRowEncoder13[A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder]: RowEncoder[Tuple13[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13]] =
    RowEncoder.ordered((t: Tuple13[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13]) ⇒ t)

  /** Provides an instance of [[RowEncoder]] for `Tuple14`, provided all internal types have an instance of [[CellEncoder]].
    *
    * @example
    * {{{
    * scala> RowEncoder[Tuple14[Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int]].encode((1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14))
    * res13: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14)
    * }}}
    */implicit def tupleRowEncoder14[A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder]: RowEncoder[Tuple14[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14]] =
    RowEncoder.ordered((t: Tuple14[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14]) ⇒ t)

  /** Provides an instance of [[RowEncoder]] for `Tuple15`, provided all internal types have an instance of [[CellEncoder]].
    *
    * @example
    * {{{
    * scala> RowEncoder[Tuple15[Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int]].encode((1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15))
    * res14: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)
    * }}}
    */implicit def tupleRowEncoder15[A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder]: RowEncoder[Tuple15[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15]] =
    RowEncoder.ordered((t: Tuple15[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15]) ⇒ t)

  /** Provides an instance of [[RowEncoder]] for `Tuple16`, provided all internal types have an instance of [[CellEncoder]].
    *
    * @example
    * {{{
    * scala> RowEncoder[Tuple16[Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int]].encode((1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16))
    * res15: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16)
    * }}}
    */implicit def tupleRowEncoder16[A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder, A16: CellEncoder]: RowEncoder[Tuple16[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16]] =
    RowEncoder.ordered((t: Tuple16[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16]) ⇒ t)

  /** Provides an instance of [[RowEncoder]] for `Tuple17`, provided all internal types have an instance of [[CellEncoder]].
    *
    * @example
    * {{{
    * scala> RowEncoder[Tuple17[Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int]].encode((1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17))
    * res16: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17)
    * }}}
    */implicit def tupleRowEncoder17[A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder, A16: CellEncoder, A17: CellEncoder]: RowEncoder[Tuple17[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17]] =
    RowEncoder.ordered((t: Tuple17[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17]) ⇒ t)

  /** Provides an instance of [[RowEncoder]] for `Tuple18`, provided all internal types have an instance of [[CellEncoder]].
    *
    * @example
    * {{{
    * scala> RowEncoder[Tuple18[Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int]].encode((1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18))
    * res17: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18)
    * }}}
    */implicit def tupleRowEncoder18[A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder, A16: CellEncoder, A17: CellEncoder, A18: CellEncoder]: RowEncoder[Tuple18[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18]] =
    RowEncoder.ordered((t: Tuple18[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18]) ⇒ t)

  /** Provides an instance of [[RowEncoder]] for `Tuple19`, provided all internal types have an instance of [[CellEncoder]].
    *
    * @example
    * {{{
    * scala> RowEncoder[Tuple19[Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int]].encode((1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19))
    * res18: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19)
    * }}}
    */implicit def tupleRowEncoder19[A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder, A16: CellEncoder, A17: CellEncoder, A18: CellEncoder, A19: CellEncoder]: RowEncoder[Tuple19[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19]] =
    RowEncoder.ordered((t: Tuple19[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19]) ⇒ t)

  /** Provides an instance of [[RowEncoder]] for `Tuple20`, provided all internal types have an instance of [[CellEncoder]].
    *
    * @example
    * {{{
    * scala> RowEncoder[Tuple20[Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int]].encode((1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20))
    * res19: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20)
    * }}}
    */implicit def tupleRowEncoder20[A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder, A16: CellEncoder, A17: CellEncoder, A18: CellEncoder, A19: CellEncoder, A20: CellEncoder]: RowEncoder[Tuple20[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20]] =
    RowEncoder.ordered((t: Tuple20[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20]) ⇒ t)

  /** Provides an instance of [[RowEncoder]] for `Tuple21`, provided all internal types have an instance of [[CellEncoder]].
    *
    * @example
    * {{{
    * scala> RowEncoder[Tuple21[Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int]].encode((1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21))
    * res20: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21)
    * }}}
    */implicit def tupleRowEncoder21[A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder, A16: CellEncoder, A17: CellEncoder, A18: CellEncoder, A19: CellEncoder, A20: CellEncoder, A21: CellEncoder]: RowEncoder[Tuple21[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21]] =
    RowEncoder.ordered((t: Tuple21[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21]) ⇒ t)

  /** Provides an instance of [[RowEncoder]] for `Tuple22`, provided all internal types have an instance of [[CellEncoder]].
    *
    * @example
    * {{{
    * scala> RowEncoder[Tuple22[Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int, Int]].encode((1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22))
    * res21: Seq[String] = WrappedArray(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22)
    * }}}
    */implicit def tupleRowEncoder22[A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder, A16: CellEncoder, A17: CellEncoder, A18: CellEncoder, A19: CellEncoder, A20: CellEncoder, A21: CellEncoder, A22: CellEncoder]: RowEncoder[Tuple22[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22]] =
    RowEncoder.ordered((t: Tuple22[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22]) ⇒ t)
}
