// auto-generated by sbt-boilerplate
/*
 * Copyright 2015 Nicolas Rinaudo
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package kantan.csv

trait GeneratedHeaderDecoders {
  /** Creates a new [[HeaderDecoder]] from the specified field list and function.
   *
   * @example
   * {{{
   * scala> import kantan.csv.ops._
   *
   * scala> case class Foo(i1: Int)
   * scala> implicit val decoder: HeaderDecoder[Foo] = HeaderDecoder.decoder("f1")(Foo.apply _)
   *
   * scala> "f1\n1".asCsvReader[Foo](rfc.withHeader).next()
   * res0: ReadResult[Foo] = Right(Foo(1))
   * }}}
   *
   */
  def decoder[A1: CellDecoder, R](f1: String)(f: (A1) => R): HeaderDecoder[R] = new HeaderDecoder[R] {
    override def fromHeader(header: Seq[String]): DecodeResult[RowDecoder[R]] =
      HeaderDecoder.determineRowMappings(Seq(f1), header).map(mapping => RowDecoder.decoder(mapping(0))(f))
    override def noHeader = RowDecoder.ordered(f)
  }

  /** Creates a new [[HeaderDecoder]] from the specified field list and function.
   *
   * @example
   * {{{
   * scala> import kantan.csv.ops._
   *
   * scala> case class Foo(i1: Int, i2: Int)
   * scala> implicit val decoder: HeaderDecoder[Foo] = HeaderDecoder.decoder("f1", "f2")(Foo.apply _)
   *
   * scala> "f1, f2\n1, 2".asCsvReader[Foo](rfc.withHeader).next()
   * res1: ReadResult[Foo] = Right(Foo(1,2))
   * }}}
   *
   */
  def decoder[A1: CellDecoder, A2: CellDecoder, R](f1: String, f2: String)(f: (A1, A2) => R): HeaderDecoder[R] = new HeaderDecoder[R] {
    override def fromHeader(header: Seq[String]): DecodeResult[RowDecoder[R]] =
      HeaderDecoder.determineRowMappings(Seq(f1, f2), header).map(mapping => RowDecoder.decoder(mapping(0), mapping(1))(f))
    override def noHeader = RowDecoder.ordered(f)
  }

  /** Creates a new [[HeaderDecoder]] from the specified field list and function.
   *
   * @example
   * {{{
   * scala> import kantan.csv.ops._
   *
   * scala> case class Foo(i1: Int, i2: Int, i3: Int)
   * scala> implicit val decoder: HeaderDecoder[Foo] = HeaderDecoder.decoder("f1", "f2", "f3")(Foo.apply _)
   *
   * scala> "f1, f2, f3\n1, 2, 3".asCsvReader[Foo](rfc.withHeader).next()
   * res2: ReadResult[Foo] = Right(Foo(1,2,3))
   * }}}
   *
   */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, R](f1: String, f2: String, f3: String)(f: (A1, A2, A3) => R): HeaderDecoder[R] = new HeaderDecoder[R] {
    override def fromHeader(header: Seq[String]): DecodeResult[RowDecoder[R]] =
      HeaderDecoder.determineRowMappings(Seq(f1, f2, f3), header).map(mapping => RowDecoder.decoder(mapping(0), mapping(1), mapping(2))(f))
    override def noHeader = RowDecoder.ordered(f)
  }

  /** Creates a new [[HeaderDecoder]] from the specified field list and function.
   *
   * @example
   * {{{
   * scala> import kantan.csv.ops._
   *
   * scala> case class Foo(i1: Int, i2: Int, i3: Int, i4: Int)
   * scala> implicit val decoder: HeaderDecoder[Foo] = HeaderDecoder.decoder("f1", "f2", "f3", "f4")(Foo.apply _)
   *
   * scala> "f1, f2, f3, f4\n1, 2, 3, 4".asCsvReader[Foo](rfc.withHeader).next()
   * res3: ReadResult[Foo] = Right(Foo(1,2,3,4))
   * }}}
   *
   */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, R](f1: String, f2: String, f3: String, f4: String)(f: (A1, A2, A3, A4) => R): HeaderDecoder[R] = new HeaderDecoder[R] {
    override def fromHeader(header: Seq[String]): DecodeResult[RowDecoder[R]] =
      HeaderDecoder.determineRowMappings(Seq(f1, f2, f3, f4), header).map(mapping => RowDecoder.decoder(mapping(0), mapping(1), mapping(2), mapping(3))(f))
    override def noHeader = RowDecoder.ordered(f)
  }

  /** Creates a new [[HeaderDecoder]] from the specified field list and function.
   *
   * @example
   * {{{
   * scala> import kantan.csv.ops._
   *
   * scala> case class Foo(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int)
   * scala> implicit val decoder: HeaderDecoder[Foo] = HeaderDecoder.decoder("f1", "f2", "f3", "f4", "f5")(Foo.apply _)
   *
   * scala> "f1, f2, f3, f4, f5\n1, 2, 3, 4, 5".asCsvReader[Foo](rfc.withHeader).next()
   * res4: ReadResult[Foo] = Right(Foo(1,2,3,4,5))
   * }}}
   *
   */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, R](f1: String, f2: String, f3: String, f4: String, f5: String)(f: (A1, A2, A3, A4, A5) => R): HeaderDecoder[R] = new HeaderDecoder[R] {
    override def fromHeader(header: Seq[String]): DecodeResult[RowDecoder[R]] =
      HeaderDecoder.determineRowMappings(Seq(f1, f2, f3, f4, f5), header).map(mapping => RowDecoder.decoder(mapping(0), mapping(1), mapping(2), mapping(3), mapping(4))(f))
    override def noHeader = RowDecoder.ordered(f)
  }

  /** Creates a new [[HeaderDecoder]] from the specified field list and function.
   *
   * @example
   * {{{
   * scala> import kantan.csv.ops._
   *
   * scala> case class Foo(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int)
   * scala> implicit val decoder: HeaderDecoder[Foo] = HeaderDecoder.decoder("f1", "f2", "f3", "f4", "f5", "f6")(Foo.apply _)
   *
   * scala> "f1, f2, f3, f4, f5, f6\n1, 2, 3, 4, 5, 6".asCsvReader[Foo](rfc.withHeader).next()
   * res5: ReadResult[Foo] = Right(Foo(1,2,3,4,5,6))
   * }}}
   *
   */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, R](f1: String, f2: String, f3: String, f4: String, f5: String, f6: String)(f: (A1, A2, A3, A4, A5, A6) => R): HeaderDecoder[R] = new HeaderDecoder[R] {
    override def fromHeader(header: Seq[String]): DecodeResult[RowDecoder[R]] =
      HeaderDecoder.determineRowMappings(Seq(f1, f2, f3, f4, f5, f6), header).map(mapping => RowDecoder.decoder(mapping(0), mapping(1), mapping(2), mapping(3), mapping(4), mapping(5))(f))
    override def noHeader = RowDecoder.ordered(f)
  }

  /** Creates a new [[HeaderDecoder]] from the specified field list and function.
   *
   * @example
   * {{{
   * scala> import kantan.csv.ops._
   *
   * scala> case class Foo(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int)
   * scala> implicit val decoder: HeaderDecoder[Foo] = HeaderDecoder.decoder("f1", "f2", "f3", "f4", "f5", "f6", "f7")(Foo.apply _)
   *
   * scala> "f1, f2, f3, f4, f5, f6, f7\n1, 2, 3, 4, 5, 6, 7".asCsvReader[Foo](rfc.withHeader).next()
   * res6: ReadResult[Foo] = Right(Foo(1,2,3,4,5,6,7))
   * }}}
   *
   */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, R](f1: String, f2: String, f3: String, f4: String, f5: String, f6: String, f7: String)(f: (A1, A2, A3, A4, A5, A6, A7) => R): HeaderDecoder[R] = new HeaderDecoder[R] {
    override def fromHeader(header: Seq[String]): DecodeResult[RowDecoder[R]] =
      HeaderDecoder.determineRowMappings(Seq(f1, f2, f3, f4, f5, f6, f7), header).map(mapping => RowDecoder.decoder(mapping(0), mapping(1), mapping(2), mapping(3), mapping(4), mapping(5), mapping(6))(f))
    override def noHeader = RowDecoder.ordered(f)
  }

  /** Creates a new [[HeaderDecoder]] from the specified field list and function.
   *
   * @example
   * {{{
   * scala> import kantan.csv.ops._
   *
   * scala> case class Foo(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int)
   * scala> implicit val decoder: HeaderDecoder[Foo] = HeaderDecoder.decoder("f1", "f2", "f3", "f4", "f5", "f6", "f7", "f8")(Foo.apply _)
   *
   * scala> "f1, f2, f3, f4, f5, f6, f7, f8\n1, 2, 3, 4, 5, 6, 7, 8".asCsvReader[Foo](rfc.withHeader).next()
   * res7: ReadResult[Foo] = Right(Foo(1,2,3,4,5,6,7,8))
   * }}}
   *
   */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, R](f1: String, f2: String, f3: String, f4: String, f5: String, f6: String, f7: String, f8: String)(f: (A1, A2, A3, A4, A5, A6, A7, A8) => R): HeaderDecoder[R] = new HeaderDecoder[R] {
    override def fromHeader(header: Seq[String]): DecodeResult[RowDecoder[R]] =
      HeaderDecoder.determineRowMappings(Seq(f1, f2, f3, f4, f5, f6, f7, f8), header).map(mapping => RowDecoder.decoder(mapping(0), mapping(1), mapping(2), mapping(3), mapping(4), mapping(5), mapping(6), mapping(7))(f))
    override def noHeader = RowDecoder.ordered(f)
  }

  /** Creates a new [[HeaderDecoder]] from the specified field list and function.
   *
   * @example
   * {{{
   * scala> import kantan.csv.ops._
   *
   * scala> case class Foo(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int)
   * scala> implicit val decoder: HeaderDecoder[Foo] = HeaderDecoder.decoder("f1", "f2", "f3", "f4", "f5", "f6", "f7", "f8", "f9")(Foo.apply _)
   *
   * scala> "f1, f2, f3, f4, f5, f6, f7, f8, f9\n1, 2, 3, 4, 5, 6, 7, 8, 9".asCsvReader[Foo](rfc.withHeader).next()
   * res8: ReadResult[Foo] = Right(Foo(1,2,3,4,5,6,7,8,9))
   * }}}
   *
   */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, R](f1: String, f2: String, f3: String, f4: String, f5: String, f6: String, f7: String, f8: String, f9: String)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9) => R): HeaderDecoder[R] = new HeaderDecoder[R] {
    override def fromHeader(header: Seq[String]): DecodeResult[RowDecoder[R]] =
      HeaderDecoder.determineRowMappings(Seq(f1, f2, f3, f4, f5, f6, f7, f8, f9), header).map(mapping => RowDecoder.decoder(mapping(0), mapping(1), mapping(2), mapping(3), mapping(4), mapping(5), mapping(6), mapping(7), mapping(8))(f))
    override def noHeader = RowDecoder.ordered(f)
  }

  /** Creates a new [[HeaderDecoder]] from the specified field list and function.
   *
   * @example
   * {{{
   * scala> import kantan.csv.ops._
   *
   * scala> case class Foo(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int)
   * scala> implicit val decoder: HeaderDecoder[Foo] = HeaderDecoder.decoder("f1", "f2", "f3", "f4", "f5", "f6", "f7", "f8", "f9", "f10")(Foo.apply _)
   *
   * scala> "f1, f2, f3, f4, f5, f6, f7, f8, f9, f10\n1, 2, 3, 4, 5, 6, 7, 8, 9, 10".asCsvReader[Foo](rfc.withHeader).next()
   * res9: ReadResult[Foo] = Right(Foo(1,2,3,4,5,6,7,8,9,10))
   * }}}
   *
   */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, R](f1: String, f2: String, f3: String, f4: String, f5: String, f6: String, f7: String, f8: String, f9: String, f10: String)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10) => R): HeaderDecoder[R] = new HeaderDecoder[R] {
    override def fromHeader(header: Seq[String]): DecodeResult[RowDecoder[R]] =
      HeaderDecoder.determineRowMappings(Seq(f1, f2, f3, f4, f5, f6, f7, f8, f9, f10), header).map(mapping => RowDecoder.decoder(mapping(0), mapping(1), mapping(2), mapping(3), mapping(4), mapping(5), mapping(6), mapping(7), mapping(8), mapping(9))(f))
    override def noHeader = RowDecoder.ordered(f)
  }

  /** Creates a new [[HeaderDecoder]] from the specified field list and function.
   *
   * @example
   * {{{
   * scala> import kantan.csv.ops._
   *
   * scala> case class Foo(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int)
   * scala> implicit val decoder: HeaderDecoder[Foo] = HeaderDecoder.decoder("f1", "f2", "f3", "f4", "f5", "f6", "f7", "f8", "f9", "f10", "f11")(Foo.apply _)
   *
   * scala> "f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11\n1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11".asCsvReader[Foo](rfc.withHeader).next()
   * res10: ReadResult[Foo] = Right(Foo(1,2,3,4,5,6,7,8,9,10,11))
   * }}}
   *
   */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, R](f1: String, f2: String, f3: String, f4: String, f5: String, f6: String, f7: String, f8: String, f9: String, f10: String, f11: String)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11) => R): HeaderDecoder[R] = new HeaderDecoder[R] {
    override def fromHeader(header: Seq[String]): DecodeResult[RowDecoder[R]] =
      HeaderDecoder.determineRowMappings(Seq(f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11), header).map(mapping => RowDecoder.decoder(mapping(0), mapping(1), mapping(2), mapping(3), mapping(4), mapping(5), mapping(6), mapping(7), mapping(8), mapping(9), mapping(10))(f))
    override def noHeader = RowDecoder.ordered(f)
  }

  /** Creates a new [[HeaderDecoder]] from the specified field list and function.
   *
   * @example
   * {{{
   * scala> import kantan.csv.ops._
   *
   * scala> case class Foo(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int)
   * scala> implicit val decoder: HeaderDecoder[Foo] = HeaderDecoder.decoder("f1", "f2", "f3", "f4", "f5", "f6", "f7", "f8", "f9", "f10", "f11", "f12")(Foo.apply _)
   *
   * scala> "f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12\n1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12".asCsvReader[Foo](rfc.withHeader).next()
   * res11: ReadResult[Foo] = Right(Foo(1,2,3,4,5,6,7,8,9,10,11,12))
   * }}}
   *
   */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, R](f1: String, f2: String, f3: String, f4: String, f5: String, f6: String, f7: String, f8: String, f9: String, f10: String, f11: String, f12: String)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12) => R): HeaderDecoder[R] = new HeaderDecoder[R] {
    override def fromHeader(header: Seq[String]): DecodeResult[RowDecoder[R]] =
      HeaderDecoder.determineRowMappings(Seq(f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12), header).map(mapping => RowDecoder.decoder(mapping(0), mapping(1), mapping(2), mapping(3), mapping(4), mapping(5), mapping(6), mapping(7), mapping(8), mapping(9), mapping(10), mapping(11))(f))
    override def noHeader = RowDecoder.ordered(f)
  }

  /** Creates a new [[HeaderDecoder]] from the specified field list and function.
   *
   * @example
   * {{{
   * scala> import kantan.csv.ops._
   *
   * scala> case class Foo(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int)
   * scala> implicit val decoder: HeaderDecoder[Foo] = HeaderDecoder.decoder("f1", "f2", "f3", "f4", "f5", "f6", "f7", "f8", "f9", "f10", "f11", "f12", "f13")(Foo.apply _)
   *
   * scala> "f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13\n1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13".asCsvReader[Foo](rfc.withHeader).next()
   * res12: ReadResult[Foo] = Right(Foo(1,2,3,4,5,6,7,8,9,10,11,12,13))
   * }}}
   *
   */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder, R](f1: String, f2: String, f3: String, f4: String, f5: String, f6: String, f7: String, f8: String, f9: String, f10: String, f11: String, f12: String, f13: String)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13) => R): HeaderDecoder[R] = new HeaderDecoder[R] {
    override def fromHeader(header: Seq[String]): DecodeResult[RowDecoder[R]] =
      HeaderDecoder.determineRowMappings(Seq(f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13), header).map(mapping => RowDecoder.decoder(mapping(0), mapping(1), mapping(2), mapping(3), mapping(4), mapping(5), mapping(6), mapping(7), mapping(8), mapping(9), mapping(10), mapping(11), mapping(12))(f))
    override def noHeader = RowDecoder.ordered(f)
  }

  /** Creates a new [[HeaderDecoder]] from the specified field list and function.
   *
   * @example
   * {{{
   * scala> import kantan.csv.ops._
   *
   * scala> case class Foo(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int)
   * scala> implicit val decoder: HeaderDecoder[Foo] = HeaderDecoder.decoder("f1", "f2", "f3", "f4", "f5", "f6", "f7", "f8", "f9", "f10", "f11", "f12", "f13", "f14")(Foo.apply _)
   *
   * scala> "f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14\n1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14".asCsvReader[Foo](rfc.withHeader).next()
   * res13: ReadResult[Foo] = Right(Foo(1,2,3,4,5,6,7,8,9,10,11,12,13,14))
   * }}}
   *
   */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder, A14: CellDecoder, R](f1: String, f2: String, f3: String, f4: String, f5: String, f6: String, f7: String, f8: String, f9: String, f10: String, f11: String, f12: String, f13: String, f14: String)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14) => R): HeaderDecoder[R] = new HeaderDecoder[R] {
    override def fromHeader(header: Seq[String]): DecodeResult[RowDecoder[R]] =
      HeaderDecoder.determineRowMappings(Seq(f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14), header).map(mapping => RowDecoder.decoder(mapping(0), mapping(1), mapping(2), mapping(3), mapping(4), mapping(5), mapping(6), mapping(7), mapping(8), mapping(9), mapping(10), mapping(11), mapping(12), mapping(13))(f))
    override def noHeader = RowDecoder.ordered(f)
  }

  /** Creates a new [[HeaderDecoder]] from the specified field list and function.
   *
   * @example
   * {{{
   * scala> import kantan.csv.ops._
   *
   * scala> case class Foo(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int)
   * scala> implicit val decoder: HeaderDecoder[Foo] = HeaderDecoder.decoder("f1", "f2", "f3", "f4", "f5", "f6", "f7", "f8", "f9", "f10", "f11", "f12", "f13", "f14", "f15")(Foo.apply _)
   *
   * scala> "f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15\n1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15".asCsvReader[Foo](rfc.withHeader).next()
   * res14: ReadResult[Foo] = Right(Foo(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15))
   * }}}
   *
   */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder, A14: CellDecoder, A15: CellDecoder, R](f1: String, f2: String, f3: String, f4: String, f5: String, f6: String, f7: String, f8: String, f9: String, f10: String, f11: String, f12: String, f13: String, f14: String, f15: String)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15) => R): HeaderDecoder[R] = new HeaderDecoder[R] {
    override def fromHeader(header: Seq[String]): DecodeResult[RowDecoder[R]] =
      HeaderDecoder.determineRowMappings(Seq(f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15), header).map(mapping => RowDecoder.decoder(mapping(0), mapping(1), mapping(2), mapping(3), mapping(4), mapping(5), mapping(6), mapping(7), mapping(8), mapping(9), mapping(10), mapping(11), mapping(12), mapping(13), mapping(14))(f))
    override def noHeader = RowDecoder.ordered(f)
  }

  /** Creates a new [[HeaderDecoder]] from the specified field list and function.
   *
   * @example
   * {{{
   * scala> import kantan.csv.ops._
   *
   * scala> case class Foo(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int)
   * scala> implicit val decoder: HeaderDecoder[Foo] = HeaderDecoder.decoder("f1", "f2", "f3", "f4", "f5", "f6", "f7", "f8", "f9", "f10", "f11", "f12", "f13", "f14", "f15", "f16")(Foo.apply _)
   *
   * scala> "f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16\n1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16".asCsvReader[Foo](rfc.withHeader).next()
   * res15: ReadResult[Foo] = Right(Foo(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16))
   * }}}
   *
   */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder, A14: CellDecoder, A15: CellDecoder, A16: CellDecoder, R](f1: String, f2: String, f3: String, f4: String, f5: String, f6: String, f7: String, f8: String, f9: String, f10: String, f11: String, f12: String, f13: String, f14: String, f15: String, f16: String)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16) => R): HeaderDecoder[R] = new HeaderDecoder[R] {
    override def fromHeader(header: Seq[String]): DecodeResult[RowDecoder[R]] =
      HeaderDecoder.determineRowMappings(Seq(f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16), header).map(mapping => RowDecoder.decoder(mapping(0), mapping(1), mapping(2), mapping(3), mapping(4), mapping(5), mapping(6), mapping(7), mapping(8), mapping(9), mapping(10), mapping(11), mapping(12), mapping(13), mapping(14), mapping(15))(f))
    override def noHeader = RowDecoder.ordered(f)
  }

  /** Creates a new [[HeaderDecoder]] from the specified field list and function.
   *
   * @example
   * {{{
   * scala> import kantan.csv.ops._
   *
   * scala> case class Foo(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int)
   * scala> implicit val decoder: HeaderDecoder[Foo] = HeaderDecoder.decoder("f1", "f2", "f3", "f4", "f5", "f6", "f7", "f8", "f9", "f10", "f11", "f12", "f13", "f14", "f15", "f16", "f17")(Foo.apply _)
   *
   * scala> "f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, f17\n1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17".asCsvReader[Foo](rfc.withHeader).next()
   * res16: ReadResult[Foo] = Right(Foo(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17))
   * }}}
   *
   */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder, A14: CellDecoder, A15: CellDecoder, A16: CellDecoder, A17: CellDecoder, R](f1: String, f2: String, f3: String, f4: String, f5: String, f6: String, f7: String, f8: String, f9: String, f10: String, f11: String, f12: String, f13: String, f14: String, f15: String, f16: String, f17: String)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17) => R): HeaderDecoder[R] = new HeaderDecoder[R] {
    override def fromHeader(header: Seq[String]): DecodeResult[RowDecoder[R]] =
      HeaderDecoder.determineRowMappings(Seq(f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, f17), header).map(mapping => RowDecoder.decoder(mapping(0), mapping(1), mapping(2), mapping(3), mapping(4), mapping(5), mapping(6), mapping(7), mapping(8), mapping(9), mapping(10), mapping(11), mapping(12), mapping(13), mapping(14), mapping(15), mapping(16))(f))
    override def noHeader = RowDecoder.ordered(f)
  }

  /** Creates a new [[HeaderDecoder]] from the specified field list and function.
   *
   * @example
   * {{{
   * scala> import kantan.csv.ops._
   *
   * scala> case class Foo(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int)
   * scala> implicit val decoder: HeaderDecoder[Foo] = HeaderDecoder.decoder("f1", "f2", "f3", "f4", "f5", "f6", "f7", "f8", "f9", "f10", "f11", "f12", "f13", "f14", "f15", "f16", "f17", "f18")(Foo.apply _)
   *
   * scala> "f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, f17, f18\n1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18".asCsvReader[Foo](rfc.withHeader).next()
   * res17: ReadResult[Foo] = Right(Foo(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18))
   * }}}
   *
   */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder, A14: CellDecoder, A15: CellDecoder, A16: CellDecoder, A17: CellDecoder, A18: CellDecoder, R](f1: String, f2: String, f3: String, f4: String, f5: String, f6: String, f7: String, f8: String, f9: String, f10: String, f11: String, f12: String, f13: String, f14: String, f15: String, f16: String, f17: String, f18: String)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18) => R): HeaderDecoder[R] = new HeaderDecoder[R] {
    override def fromHeader(header: Seq[String]): DecodeResult[RowDecoder[R]] =
      HeaderDecoder.determineRowMappings(Seq(f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, f17, f18), header).map(mapping => RowDecoder.decoder(mapping(0), mapping(1), mapping(2), mapping(3), mapping(4), mapping(5), mapping(6), mapping(7), mapping(8), mapping(9), mapping(10), mapping(11), mapping(12), mapping(13), mapping(14), mapping(15), mapping(16), mapping(17))(f))
    override def noHeader = RowDecoder.ordered(f)
  }

  /** Creates a new [[HeaderDecoder]] from the specified field list and function.
   *
   * @example
   * {{{
   * scala> import kantan.csv.ops._
   *
   * scala> case class Foo(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int)
   * scala> implicit val decoder: HeaderDecoder[Foo] = HeaderDecoder.decoder("f1", "f2", "f3", "f4", "f5", "f6", "f7", "f8", "f9", "f10", "f11", "f12", "f13", "f14", "f15", "f16", "f17", "f18", "f19")(Foo.apply _)
   *
   * scala> "f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, f17, f18, f19\n1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19".asCsvReader[Foo](rfc.withHeader).next()
   * res18: ReadResult[Foo] = Right(Foo(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19))
   * }}}
   *
   */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder, A14: CellDecoder, A15: CellDecoder, A16: CellDecoder, A17: CellDecoder, A18: CellDecoder, A19: CellDecoder, R](f1: String, f2: String, f3: String, f4: String, f5: String, f6: String, f7: String, f8: String, f9: String, f10: String, f11: String, f12: String, f13: String, f14: String, f15: String, f16: String, f17: String, f18: String, f19: String)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19) => R): HeaderDecoder[R] = new HeaderDecoder[R] {
    override def fromHeader(header: Seq[String]): DecodeResult[RowDecoder[R]] =
      HeaderDecoder.determineRowMappings(Seq(f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, f17, f18, f19), header).map(mapping => RowDecoder.decoder(mapping(0), mapping(1), mapping(2), mapping(3), mapping(4), mapping(5), mapping(6), mapping(7), mapping(8), mapping(9), mapping(10), mapping(11), mapping(12), mapping(13), mapping(14), mapping(15), mapping(16), mapping(17), mapping(18))(f))
    override def noHeader = RowDecoder.ordered(f)
  }

  /** Creates a new [[HeaderDecoder]] from the specified field list and function.
   *
   * @example
   * {{{
   * scala> import kantan.csv.ops._
   *
   * scala> case class Foo(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int)
   * scala> implicit val decoder: HeaderDecoder[Foo] = HeaderDecoder.decoder("f1", "f2", "f3", "f4", "f5", "f6", "f7", "f8", "f9", "f10", "f11", "f12", "f13", "f14", "f15", "f16", "f17", "f18", "f19", "f20")(Foo.apply _)
   *
   * scala> "f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, f17, f18, f19, f20\n1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20".asCsvReader[Foo](rfc.withHeader).next()
   * res19: ReadResult[Foo] = Right(Foo(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20))
   * }}}
   *
   */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder, A14: CellDecoder, A15: CellDecoder, A16: CellDecoder, A17: CellDecoder, A18: CellDecoder, A19: CellDecoder, A20: CellDecoder, R](f1: String, f2: String, f3: String, f4: String, f5: String, f6: String, f7: String, f8: String, f9: String, f10: String, f11: String, f12: String, f13: String, f14: String, f15: String, f16: String, f17: String, f18: String, f19: String, f20: String)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20) => R): HeaderDecoder[R] = new HeaderDecoder[R] {
    override def fromHeader(header: Seq[String]): DecodeResult[RowDecoder[R]] =
      HeaderDecoder.determineRowMappings(Seq(f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, f17, f18, f19, f20), header).map(mapping => RowDecoder.decoder(mapping(0), mapping(1), mapping(2), mapping(3), mapping(4), mapping(5), mapping(6), mapping(7), mapping(8), mapping(9), mapping(10), mapping(11), mapping(12), mapping(13), mapping(14), mapping(15), mapping(16), mapping(17), mapping(18), mapping(19))(f))
    override def noHeader = RowDecoder.ordered(f)
  }

  /** Creates a new [[HeaderDecoder]] from the specified field list and function.
   *
   * @example
   * {{{
   * scala> import kantan.csv.ops._
   *
   * scala> case class Foo(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int, i21: Int)
   * scala> implicit val decoder: HeaderDecoder[Foo] = HeaderDecoder.decoder("f1", "f2", "f3", "f4", "f5", "f6", "f7", "f8", "f9", "f10", "f11", "f12", "f13", "f14", "f15", "f16", "f17", "f18", "f19", "f20", "f21")(Foo.apply _)
   *
   * scala> "f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, f17, f18, f19, f20, f21\n1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21".asCsvReader[Foo](rfc.withHeader).next()
   * res20: ReadResult[Foo] = Right(Foo(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21))
   * }}}
   *
   */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder, A14: CellDecoder, A15: CellDecoder, A16: CellDecoder, A17: CellDecoder, A18: CellDecoder, A19: CellDecoder, A20: CellDecoder, A21: CellDecoder, R](f1: String, f2: String, f3: String, f4: String, f5: String, f6: String, f7: String, f8: String, f9: String, f10: String, f11: String, f12: String, f13: String, f14: String, f15: String, f16: String, f17: String, f18: String, f19: String, f20: String, f21: String)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21) => R): HeaderDecoder[R] = new HeaderDecoder[R] {
    override def fromHeader(header: Seq[String]): DecodeResult[RowDecoder[R]] =
      HeaderDecoder.determineRowMappings(Seq(f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, f17, f18, f19, f20, f21), header).map(mapping => RowDecoder.decoder(mapping(0), mapping(1), mapping(2), mapping(3), mapping(4), mapping(5), mapping(6), mapping(7), mapping(8), mapping(9), mapping(10), mapping(11), mapping(12), mapping(13), mapping(14), mapping(15), mapping(16), mapping(17), mapping(18), mapping(19), mapping(20))(f))
    override def noHeader = RowDecoder.ordered(f)
  }

  /** Creates a new [[HeaderDecoder]] from the specified field list and function.
   *
   * @example
   * {{{
   * scala> import kantan.csv.ops._
   *
   * scala> case class Foo(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int, i21: Int, i22: Int)
   * scala> implicit val decoder: HeaderDecoder[Foo] = HeaderDecoder.decoder("f1", "f2", "f3", "f4", "f5", "f6", "f7", "f8", "f9", "f10", "f11", "f12", "f13", "f14", "f15", "f16", "f17", "f18", "f19", "f20", "f21", "f22")(Foo.apply _)
   *
   * scala> "f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, f17, f18, f19, f20, f21, f22\n1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22".asCsvReader[Foo](rfc.withHeader).next()
   * res21: ReadResult[Foo] = Right(Foo(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22))
   * }}}
   *
   */
  def decoder[A1: CellDecoder, A2: CellDecoder, A3: CellDecoder, A4: CellDecoder, A5: CellDecoder, A6: CellDecoder, A7: CellDecoder, A8: CellDecoder, A9: CellDecoder, A10: CellDecoder, A11: CellDecoder, A12: CellDecoder, A13: CellDecoder, A14: CellDecoder, A15: CellDecoder, A16: CellDecoder, A17: CellDecoder, A18: CellDecoder, A19: CellDecoder, A20: CellDecoder, A21: CellDecoder, A22: CellDecoder, R](f1: String, f2: String, f3: String, f4: String, f5: String, f6: String, f7: String, f8: String, f9: String, f10: String, f11: String, f12: String, f13: String, f14: String, f15: String, f16: String, f17: String, f18: String, f19: String, f20: String, f21: String, f22: String)(f: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22) => R): HeaderDecoder[R] = new HeaderDecoder[R] {
    override def fromHeader(header: Seq[String]): DecodeResult[RowDecoder[R]] =
      HeaderDecoder.determineRowMappings(Seq(f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, f17, f18, f19, f20, f21, f22), header).map(mapping => RowDecoder.decoder(mapping(0), mapping(1), mapping(2), mapping(3), mapping(4), mapping(5), mapping(6), mapping(7), mapping(8), mapping(9), mapping(10), mapping(11), mapping(12), mapping(13), mapping(14), mapping(15), mapping(16), mapping(17), mapping(18), mapping(19), mapping(20), mapping(21))(f))
    override def noHeader = RowDecoder.ordered(f)
  }
}
